/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.ConversationProfile;
import com.google.cloud.dialogflow.v2beta1.ConversationProfileName;
import com.google.cloud.dialogflow.v2beta1.ConversationProfilesSettings;
import com.google.cloud.dialogflow.v2beta1.CreateConversationProfileRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteConversationProfileRequest;
import com.google.cloud.dialogflow.v2beta1.GetConversationProfileRequest;
import com.google.cloud.dialogflow.v2beta1.ListConversationProfilesRequest;
import com.google.cloud.dialogflow.v2beta1.ListConversationProfilesResponse;
import com.google.cloud.dialogflow.v2beta1.LocationName;
import com.google.cloud.dialogflow.v2beta1.ProjectName;
import com.google.cloud.dialogflow.v2beta1.UpdateConversationProfileRequest;
import com.google.cloud.dialogflow.v2beta1.stub.ConversationProfilesStub;
import com.google.cloud.dialogflow.v2beta1.stub.ConversationProfilesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ConversationProfilesClient
implements BackgroundResource {
    private final ConversationProfilesSettings settings;
    private final ConversationProfilesStub stub;

    public static final ConversationProfilesClient create() throws IOException {
        return ConversationProfilesClient.create(ConversationProfilesSettings.newBuilder().build());
    }

    public static final ConversationProfilesClient create(ConversationProfilesSettings settings) throws IOException {
        return new ConversationProfilesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ConversationProfilesClient create(ConversationProfilesStub stub) {
        return new ConversationProfilesClient(stub);
    }

    protected ConversationProfilesClient(ConversationProfilesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConversationProfilesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ConversationProfilesClient(ConversationProfilesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConversationProfilesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ConversationProfilesStub getStub() {
        return this.stub;
    }

    public final ListConversationProfilesPagedResponse listConversationProfiles(LocationName parent) {
        ListConversationProfilesRequest request = ListConversationProfilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConversationProfiles(request);
    }

    public final ListConversationProfilesPagedResponse listConversationProfiles(ProjectName parent) {
        ListConversationProfilesRequest request = ListConversationProfilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConversationProfiles(request);
    }

    public final ListConversationProfilesPagedResponse listConversationProfiles(String parent) {
        ListConversationProfilesRequest request = ListConversationProfilesRequest.newBuilder().setParent(parent).build();
        return this.listConversationProfiles(request);
    }

    public final ListConversationProfilesPagedResponse listConversationProfiles(ListConversationProfilesRequest request) {
        return (ListConversationProfilesPagedResponse)((Object)this.listConversationProfilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConversationProfilesRequest, ListConversationProfilesPagedResponse> listConversationProfilesPagedCallable() {
        return this.stub.listConversationProfilesPagedCallable();
    }

    public final UnaryCallable<ListConversationProfilesRequest, ListConversationProfilesResponse> listConversationProfilesCallable() {
        return this.stub.listConversationProfilesCallable();
    }

    public final ConversationProfile getConversationProfile(ConversationProfileName name) {
        GetConversationProfileRequest request = GetConversationProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConversationProfile(request);
    }

    public final ConversationProfile getConversationProfile(String name) {
        GetConversationProfileRequest request = GetConversationProfileRequest.newBuilder().setName(name).build();
        return this.getConversationProfile(request);
    }

    public final ConversationProfile getConversationProfile(GetConversationProfileRequest request) {
        return (ConversationProfile)this.getConversationProfileCallable().call((Object)request);
    }

    public final UnaryCallable<GetConversationProfileRequest, ConversationProfile> getConversationProfileCallable() {
        return this.stub.getConversationProfileCallable();
    }

    public final ConversationProfile createConversationProfile(LocationName parent, ConversationProfile conversationProfile) {
        CreateConversationProfileRequest request = CreateConversationProfileRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConversationProfile(conversationProfile).build();
        return this.createConversationProfile(request);
    }

    public final ConversationProfile createConversationProfile(ProjectName parent, ConversationProfile conversationProfile) {
        CreateConversationProfileRequest request = CreateConversationProfileRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConversationProfile(conversationProfile).build();
        return this.createConversationProfile(request);
    }

    public final ConversationProfile createConversationProfile(String parent, ConversationProfile conversationProfile) {
        CreateConversationProfileRequest request = CreateConversationProfileRequest.newBuilder().setParent(parent).setConversationProfile(conversationProfile).build();
        return this.createConversationProfile(request);
    }

    public final ConversationProfile createConversationProfile(CreateConversationProfileRequest request) {
        return (ConversationProfile)this.createConversationProfileCallable().call((Object)request);
    }

    public final UnaryCallable<CreateConversationProfileRequest, ConversationProfile> createConversationProfileCallable() {
        return this.stub.createConversationProfileCallable();
    }

    public final ConversationProfile updateConversationProfile(ConversationProfile conversationProfile, FieldMask updateMask) {
        UpdateConversationProfileRequest request = UpdateConversationProfileRequest.newBuilder().setConversationProfile(conversationProfile).setUpdateMask(updateMask).build();
        return this.updateConversationProfile(request);
    }

    public final ConversationProfile updateConversationProfile(UpdateConversationProfileRequest request) {
        return (ConversationProfile)this.updateConversationProfileCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateConversationProfileRequest, ConversationProfile> updateConversationProfileCallable() {
        return this.stub.updateConversationProfileCallable();
    }

    public final void deleteConversationProfile(ConversationProfileName name) {
        DeleteConversationProfileRequest request = DeleteConversationProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteConversationProfile(request);
    }

    public final void deleteConversationProfile(String name) {
        DeleteConversationProfileRequest request = DeleteConversationProfileRequest.newBuilder().setName(name).build();
        this.deleteConversationProfile(request);
    }

    public final void deleteConversationProfile(DeleteConversationProfileRequest request) {
        this.deleteConversationProfileCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteConversationProfileRequest, Empty> deleteConversationProfileCallable() {
        return this.stub.deleteConversationProfileCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListConversationProfilesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfile, ListConversationProfilesPage, ListConversationProfilesFixedSizeCollection> {
        private ListConversationProfilesFixedSizeCollection(List<ListConversationProfilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConversationProfilesFixedSizeCollection createEmptyCollection() {
            return new ListConversationProfilesFixedSizeCollection(null, 0);
        }

        protected ListConversationProfilesFixedSizeCollection createCollection(List<ListConversationProfilesPage> pages, int collectionSize) {
            return new ListConversationProfilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConversationProfilesPage
    extends AbstractPage<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfile, ListConversationProfilesPage> {
        private ListConversationProfilesPage(PageContext<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfile> context, ListConversationProfilesResponse response) {
            super(context, (Object)response);
        }

        private static ListConversationProfilesPage createEmptyPage() {
            return new ListConversationProfilesPage(null, null);
        }

        protected ListConversationProfilesPage createPage(PageContext<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfile> context, ListConversationProfilesResponse response) {
            return new ListConversationProfilesPage(context, response);
        }

        public ApiFuture<ListConversationProfilesPage> createPageAsync(PageContext<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfile> context, ApiFuture<ListConversationProfilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConversationProfilesPagedResponse
    extends AbstractPagedListResponse<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfile, ListConversationProfilesPage, ListConversationProfilesFixedSizeCollection> {
        public static ApiFuture<ListConversationProfilesPagedResponse> createAsync(PageContext<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfile> context, ApiFuture<ListConversationProfilesResponse> futureResponse) {
            ApiFuture<ListConversationProfilesPage> futurePage = ListConversationProfilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConversationProfilesPagedResponse((ListConversationProfilesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConversationProfilesPagedResponse(ListConversationProfilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConversationProfilesFixedSizeCollection.createEmptyCollection());
        }
    }
}

