/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.Transaction;
import com.google.cloud.firestore.TransactionOptions;
import com.google.cloud.firestore.WriteBatch;
import com.google.cloud.firestore.WriteResult;
import com.google.cloud.firestore.spi.v1beta1.FirestoreRpc;
import com.google.common.base.Preconditions;
import com.google.firestore.v1beta1.BatchGetDocumentsRequest;
import com.google.firestore.v1beta1.BatchGetDocumentsResponse;
import com.google.firestore.v1beta1.DatabaseRootName;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Instant;

class FirestoreImpl
implements Firestore {
    private static final Random RANDOM = new Random();
    private static final int AUTO_ID_LENGTH = 20;
    private static final String AUTO_ID_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private final FirestoreRpc firestoreClient;
    private final FirestoreOptions firestoreOptions;
    private final ResourcePath databasePath;
    private boolean closed;

    FirestoreImpl(FirestoreOptions options) {
        this(options, options.getFirestoreRpc());
    }

    FirestoreImpl(FirestoreOptions options, FirestoreRpc firestoreRpc) {
        this.firestoreClient = firestoreRpc;
        this.firestoreOptions = options;
        Preconditions.checkNotNull((Object)options.getProjectId(), (Object)"Failed to detect Project ID. Please explicitly set your Project ID in FirestoreOptions.");
        this.databasePath = ResourcePath.create(DatabaseRootName.of((String)options.getProjectId(), (String)options.getDatabaseId()));
    }

    static String autoId() {
        StringBuilder builder = new StringBuilder();
        int maxRandom = AUTO_ID_ALPHABET.length();
        for (int i = 0; i < 20; ++i) {
            builder.append(AUTO_ID_ALPHABET.charAt(RANDOM.nextInt(maxRandom)));
        }
        return builder.toString();
    }

    @Override
    @Nonnull
    public WriteBatch batch() {
        return new WriteBatch(this);
    }

    @Override
    @Nonnull
    public CollectionReference collection(@Nonnull String collectionPath) {
        return new CollectionReference(this, (ResourcePath)this.databasePath.append(collectionPath));
    }

    @Override
    @Nonnull
    public DocumentReference document(@Nonnull String documentPath) {
        ResourcePath document = (ResourcePath)this.databasePath.append(documentPath);
        Preconditions.checkArgument((boolean)document.isDocument(), (Object)String.format("Path should point to a Document Reference: %s", documentPath));
        return new DocumentReference(this, document);
    }

    @Override
    @Nonnull
    public Iterable<CollectionReference> getCollections() {
        DocumentReference rootDocument = new DocumentReference(this, this.databasePath);
        return rootDocument.getCollections();
    }

    @Override
    @Nonnull
    public ApiFuture<List<DocumentSnapshot>> getAll(DocumentReference ... documentReferences) {
        return this.getAll(documentReferences, (ByteString)null);
    }

    ApiFuture<List<DocumentSnapshot>> getAll(final DocumentReference[] documentReferences, @Nullable ByteString transactionId) {
        final SettableApiFuture futureList = SettableApiFuture.create();
        final HashMap resultMap = new HashMap();
        ApiStreamObserver<BatchGetDocumentsResponse> responseObserver = new ApiStreamObserver<BatchGetDocumentsResponse>(){

            public void onNext(BatchGetDocumentsResponse response) {
                DocumentSnapshot documentSnapshot;
                DocumentReference documentReference;
                switch (response.getResultCase()) {
                    case FOUND: {
                        documentReference = new DocumentReference(FirestoreImpl.this, ResourcePath.create(response.getFound().getName()));
                        documentSnapshot = DocumentSnapshot.fromDocument(FirestoreImpl.this, response.getReadTime(), response.getFound());
                        break;
                    }
                    case MISSING: {
                        documentReference = new DocumentReference(FirestoreImpl.this, ResourcePath.create(response.getMissing()));
                        documentSnapshot = DocumentSnapshot.fromMissing(FirestoreImpl.this, documentReference, Instant.ofEpochSecond((long)response.getReadTime().getSeconds(), (long)response.getReadTime().getNanos()));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                resultMap.put(documentReference, documentSnapshot);
            }

            public void onError(Throwable throwable) {
                futureList.setException(throwable);
            }

            public void onCompleted() {
                ArrayList documentSnapshots = new ArrayList();
                for (DocumentReference documentReference : documentReferences) {
                    documentSnapshots.add(resultMap.get(documentReference));
                }
                futureList.set(documentSnapshots);
            }
        };
        BatchGetDocumentsRequest.Builder request = BatchGetDocumentsRequest.newBuilder();
        request.setDatabase(this.getDatabaseName());
        if (transactionId != null) {
            request.setTransaction(transactionId);
        }
        for (DocumentReference docRef : documentReferences) {
            request.addDocuments(docRef.getName());
        }
        this.streamRequest(request.build(), responseObserver, this.firestoreClient.batchGetDocumentsCallable());
        return futureList;
    }

    @Override
    @Nonnull
    public <T> ApiFuture<T> runTransaction(@Nonnull Transaction.Function<T> updateFunction) {
        return this.runTransaction(updateFunction, TransactionOptions.create());
    }

    @Override
    @Nonnull
    public <T> ApiFuture<T> runTransaction(@Nonnull Transaction.Function<T> updateFunction, @Nonnull TransactionOptions transactionOptions) {
        SettableApiFuture resultFuture = SettableApiFuture.create();
        this.runTransaction(updateFunction, resultFuture, transactionOptions);
        return resultFuture;
    }

    private <T> void runTransaction(final Transaction.Function<T> transactionCallback, final SettableApiFuture<T> resultFuture, final TransactionOptions options) {
        final Transaction transaction = new Transaction(this, options.getPreviousTransactionId());
        final Executor userCallbackExecutor = options.getExecutor() != null ? options.getExecutor() : this.firestoreClient.getExecutor();
        final int attemptsRemaining = options.getNumberOfAttempts() - 1;
        ApiFutures.addCallback(transaction.begin(), (ApiFutureCallback)new ApiFutureCallback<Void>(){

            public void onFailure(Throwable throwable) {
                this.rejectTransaction(throwable);
            }

            public void onSuccess(Void ignored) {
                ApiFutures.addCallback(this.invokeUserCallback(), (ApiFutureCallback)new ApiFutureCallback<T>(){

                    public void onFailure(Throwable throwable) {
                        this.rejectTransaction(throwable);
                    }

                    public void onSuccess(final T userResult) {
                        ApiFutures.addCallback(transaction.commit(), (ApiFutureCallback)new ApiFutureCallback<List<WriteResult>>(){

                            public void onFailure(Throwable throwable) {
                                this.maybeRetry();
                            }

                            public void onSuccess(List<WriteResult> writeResults) {
                                resultFuture.set(userResult);
                            }
                        });
                    }
                });
            }

            private SettableApiFuture<T> invokeUserCallback() {
                final SettableApiFuture callbackResult = SettableApiFuture.create();
                userCallbackExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            callbackResult.set(transactionCallback.updateCallback(transaction));
                        }
                        catch (Exception e) {
                            callbackResult.setException((Throwable)e);
                        }
                    }
                });
                return callbackResult;
            }

            private void maybeRetry() {
                if (attemptsRemaining > 0) {
                    FirestoreImpl.this.runTransaction(transactionCallback, resultFuture, new TransactionOptions(attemptsRemaining, options.getExecutor(), transaction.getTransactionId()));
                } else {
                    this.rejectTransaction((Throwable)((Object)FirestoreException.serverRejected(Status.ABORTED, "Transaction was cancelled because of too many retries.", new Object[0])));
                }
            }

            private void rejectTransaction(final Throwable throwable) {
                if (transaction.isPending()) {
                    ApiFutures.addCallback(transaction.rollback(), (ApiFutureCallback)new ApiFutureCallback<Void>(){

                        public void onFailure(Throwable throwable2) {
                            resultFuture.setException(throwable2);
                        }

                        public void onSuccess(Void ignored) {
                            resultFuture.setException(throwable);
                        }
                    });
                } else {
                    resultFuture.setException(throwable);
                }
            }
        });
    }

    String getDatabaseName() {
        return this.databasePath.toString();
    }

    FirestoreRpc getClient() {
        return this.firestoreClient;
    }

    <RequestT, ResponseT> ApiFuture<ResponseT> sendRequest(RequestT requestT, UnaryCallable<RequestT, ResponseT> callable) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Firestore client has already been closed");
        return callable.futureCall(requestT);
    }

    <RequestT, ResponseT> void streamRequest(RequestT requestT, ApiStreamObserver<ResponseT> responseObserverT, ServerStreamingCallable<RequestT, ResponseT> callable) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Firestore client has already been closed");
        callable.serverStreamingCall(requestT, responseObserverT);
    }

    <RequestT, ResponseT> ApiStreamObserver<RequestT> streamRequest(ApiStreamObserver<ResponseT> responseObserverT, BidiStreamingCallable<RequestT, ResponseT> callable) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Firestore client has already been closed");
        return callable.bidiStreamingCall(responseObserverT);
    }

    public FirestoreOptions getOptions() {
        return this.firestoreOptions;
    }

    @Override
    public void close() throws Exception {
        this.firestoreClient.close();
        this.closed = true;
    }
}

