/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.UserDataConverter;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SetOptions {
    static final SetOptions OVERWRITE = new SetOptions(false, null);
    private static final SetOptions MERGE_ALL_FIELDS = new SetOptions(true, null);
    private final boolean merge;
    @Nullable
    private final List<FieldPath> fieldMask;

    private SetOptions(boolean merge, @Nullable List<FieldPath> fieldMask) {
        Preconditions.checkArgument((fieldMask == null || merge ? 1 : 0) != 0, (Object)"Cannot specify a fieldMask for non-merge sets()");
        this.merge = merge;
        this.fieldMask = fieldMask;
    }

    boolean isMerge() {
        return this.merge;
    }

    @Nullable
    List<FieldPath> getFieldMask() {
        return this.fieldMask;
    }

    @Nonnull
    public static SetOptions merge() {
        return MERGE_ALL_FIELDS;
    }

    @Nonnull
    public static SetOptions mergeFields(List<String> fields) {
        ArrayList<FieldPath> fieldPaths = new ArrayList<FieldPath>();
        for (String field : fields) {
            fieldPaths.add(FieldPath.fromDotSeparatedString(field));
        }
        return new SetOptions(true, fieldPaths);
    }

    @Nonnull
    public static SetOptions mergeFields(String ... fields) {
        ArrayList<FieldPath> fieldPaths = new ArrayList<FieldPath>();
        for (String field : fields) {
            fieldPaths.add(FieldPath.fromDotSeparatedString(field));
        }
        return new SetOptions(true, fieldPaths);
    }

    @Nonnull
    public static SetOptions mergeFieldPaths(List<FieldPath> fields) {
        return new SetOptions(true, fields);
    }

    UserDataConverter.EncodingOptions getEncodingOptions() {
        if (!this.merge) {
            return UserDataConverter.NO_DELETES;
        }
        if (this.fieldMask == null) {
            return UserDataConverter.ALLOW_ALL_DELETES;
        }
        return new UserDataConverter.EncodingOptions(){

            @Override
            public boolean allowDelete(FieldPath fieldPath) {
                return SetOptions.this.fieldMask.contains(fieldPath);
            }
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SetOptions that = (SetOptions)obj;
        return this.merge == that.merge && Objects.equals(this.fieldMask, that.fieldMask);
    }

    public int hashCode() {
        return Objects.hash(this.merge, this.fieldMask);
    }
}

