/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.logging.v2.LoggingSettings;
import com.google.cloud.logging.v2.PagedResponseWrappers;
import com.google.cloud.logging.v2.stub.LoggingServiceV2Stub;
import com.google.logging.v2.DeleteLogRequest;
import com.google.logging.v2.ListLogEntriesRequest;
import com.google.logging.v2.ListLogEntriesResponse;
import com.google.logging.v2.ListLogsRequest;
import com.google.logging.v2.ListLogsResponse;
import com.google.logging.v2.ListMonitoredResourceDescriptorsRequest;
import com.google.logging.v2.ListMonitoredResourceDescriptorsResponse;
import com.google.logging.v2.WriteLogEntriesRequest;
import com.google.logging.v2.WriteLogEntriesResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcLoggingServiceV2Stub
extends LoggingServiceV2Stub {
    private static final MethodDescriptor<DeleteLogRequest, Empty> deleteLogMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.logging.v2.LoggingServiceV2/DeleteLog").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteLogRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.logging.v2.LoggingServiceV2/WriteLogEntries").setRequestMarshaller(ProtoUtils.marshaller((Message)WriteLogEntriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)WriteLogEntriesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLogEntriesRequest, ListLogEntriesResponse> listLogEntriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.logging.v2.LoggingServiceV2/ListLogEntries").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLogEntriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLogEntriesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.logging.v2.LoggingServiceV2/ListMonitoredResourceDescriptors").setRequestMarshaller(ProtoUtils.marshaller((Message)ListMonitoredResourceDescriptorsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListMonitoredResourceDescriptorsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLogsRequest, ListLogsResponse> listLogsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.logging.v2.LoggingServiceV2/ListLogs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLogsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLogsResponse.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteLogRequest, Empty> deleteLogCallable;
    private final UnaryCallable<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesCallable;
    private final UnaryCallable<ListLogEntriesRequest, ListLogEntriesResponse> listLogEntriesCallable;
    private final UnaryCallable<ListLogEntriesRequest, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesPagedCallable;
    private final UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable;
    private final UnaryCallable<ListMonitoredResourceDescriptorsRequest, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsPagedCallable;
    private final UnaryCallable<ListLogsRequest, ListLogsResponse> listLogsCallable;
    private final UnaryCallable<ListLogsRequest, PagedResponseWrappers.ListLogsPagedResponse> listLogsPagedCallable;

    public static final GrpcLoggingServiceV2Stub create(LoggingSettings settings) throws IOException {
        return new GrpcLoggingServiceV2Stub(settings, ClientContext.create((ClientSettings)settings));
    }

    public static final GrpcLoggingServiceV2Stub create(ClientContext clientContext) throws IOException {
        return new GrpcLoggingServiceV2Stub(LoggingSettings.newBuilder().build(), clientContext);
    }

    protected GrpcLoggingServiceV2Stub(LoggingSettings settings, ClientContext clientContext) throws IOException {
        GrpcCallSettings deleteLogTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteLogMethodDescriptor).build();
        GrpcCallSettings writeLogEntriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(writeLogEntriesMethodDescriptor).build();
        GrpcCallSettings listLogEntriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLogEntriesMethodDescriptor).build();
        GrpcCallSettings listMonitoredResourceDescriptorsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listMonitoredResourceDescriptorsMethodDescriptor).build();
        GrpcCallSettings listLogsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLogsMethodDescriptor).build();
        this.deleteLogCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)deleteLogTransportSettings, settings.deleteLogSettings(), (ClientContext)clientContext);
        this.writeLogEntriesCallable = GrpcCallableFactory.createBatchingCallable((GrpcCallSettings)writeLogEntriesTransportSettings, settings.writeLogEntriesSettings(), (ClientContext)clientContext);
        this.listLogEntriesCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)listLogEntriesTransportSettings, settings.listLogEntriesSettings(), (ClientContext)clientContext);
        this.listLogEntriesPagedCallable = GrpcCallableFactory.createPagedCallable((GrpcCallSettings)listLogEntriesTransportSettings, settings.listLogEntriesSettings(), (ClientContext)clientContext);
        this.listMonitoredResourceDescriptorsCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)listMonitoredResourceDescriptorsTransportSettings, settings.listMonitoredResourceDescriptorsSettings(), (ClientContext)clientContext);
        this.listMonitoredResourceDescriptorsPagedCallable = GrpcCallableFactory.createPagedCallable((GrpcCallSettings)listMonitoredResourceDescriptorsTransportSettings, settings.listMonitoredResourceDescriptorsSettings(), (ClientContext)clientContext);
        this.listLogsCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)listLogsTransportSettings, settings.listLogsSettings(), (ClientContext)clientContext);
        this.listLogsPagedCallable = GrpcCallableFactory.createPagedCallable((GrpcCallSettings)listLogsTransportSettings, settings.listLogsSettings(), (ClientContext)clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<DeleteLogRequest, Empty> deleteLogCallable() {
        return this.deleteLogCallable;
    }

    @Override
    public UnaryCallable<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesCallable() {
        return this.writeLogEntriesCallable;
    }

    @Override
    public UnaryCallable<ListLogEntriesRequest, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesPagedCallable() {
        return this.listLogEntriesPagedCallable;
    }

    @Override
    public UnaryCallable<ListLogEntriesRequest, ListLogEntriesResponse> listLogEntriesCallable() {
        return this.listLogEntriesCallable;
    }

    @Override
    public UnaryCallable<ListMonitoredResourceDescriptorsRequest, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsPagedCallable() {
        return this.listMonitoredResourceDescriptorsPagedCallable;
    }

    @Override
    public UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable() {
        return this.listMonitoredResourceDescriptorsCallable;
    }

    @Override
    public UnaryCallable<ListLogsRequest, PagedResponseWrappers.ListLogsPagedResponse> listLogsPagedCallable() {
        return this.listLogsPagedCallable;
    }

    @Override
    public UnaryCallable<ListLogsRequest, ListLogsResponse> listLogsCallable() {
        return this.listLogsCallable;
    }

    public final void close() throws Exception {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

