/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.pathtemplate.PathTemplate;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;

public final class InstanceConfigId {
    private static final PathTemplate NAME_TEMPLATE = PathTemplate.create((String)"projects/{project}/instanceConfigs/{instanceconfig}");
    private final String project;
    private final String instanceConfig;

    InstanceConfigId(String project, String instanceConfig) {
        this.project = project;
        this.instanceConfig = instanceConfig;
    }

    public String getProject() {
        return this.project;
    }

    public String getInstanceConfig() {
        return this.instanceConfig;
    }

    public String getName() {
        return String.format("projects/%s/instanceConfigs/%s", this.project, this.instanceConfig);
    }

    public int hashCode() {
        return Objects.hash(this.project, this.instanceConfig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceConfigId that = (InstanceConfigId)o;
        return that.project.equals(this.project) && that.instanceConfig.equals(this.instanceConfig);
    }

    public String toString() {
        return this.getName();
    }

    static InstanceConfigId of(String name) {
        Map parts = NAME_TEMPLATE.match(name);
        Preconditions.checkArgument((parts != null ? 1 : 0) != 0, (String)"Name should confirm to pattern %s: %s", (Object)NAME_TEMPLATE, (Object)name);
        return new InstanceConfigId((String)parts.get("project"), (String)parts.get("instanceconfig"));
    }

    public static InstanceConfigId of(String project, String instanceConfig) {
        return new InstanceConfigId(project, instanceConfig);
    }
}

