/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.plugins.common.RawConfiguration;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;

public class PlatformParameters
implements RawConfiguration.PlatformConfiguration {
    @Nullable
    private String os;
    @Nullable
    private String architecture;

    static PlatformParameters of(String osArchitecture) {
        Matcher matcher = Pattern.compile("([^/ ]+)/([^/ ]+)").matcher(osArchitecture);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Platform must be of form os/architecture.");
        }
        PlatformParameters platformParameters = new PlatformParameters();
        platformParameters.os = matcher.group(1);
        platformParameters.architecture = matcher.group(2);
        return platformParameters;
    }

    @Input
    @Nullable
    public String getOs() {
        return this.os;
    }

    @Override
    @Internal
    public Optional<String> getOsName() {
        return Optional.ofNullable(this.os);
    }

    public void setOs(String os) {
        this.os = os;
    }

    @Input
    @Nullable
    public String getArchitecture() {
        return this.architecture;
    }

    @Override
    @Internal
    public Optional<String> getArchitectureName() {
        return Optional.ofNullable(this.architecture);
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlatformParameters)) {
            return false;
        }
        PlatformParameters otherPlatform = (PlatformParameters)other;
        return Objects.equals(this.architecture, otherPlatform.getArchitecture()) && Objects.equals(this.os, otherPlatform.getOs());
    }

    public int hashCode() {
        return Objects.hash(this.architecture, this.os);
    }
}

