/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle.skaffold;

import com.google.cloud.tools.jib.filesystem.TempDirectoryProvider;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.GradleRawConfiguration;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.plugins.common.ContainerizingMode;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerizingModeException;
import com.google.cloud.tools.jib.plugins.common.PluginConfigurationProcessor;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class SyncMapTask
extends DefaultTask {
    @Nullable
    private JibExtension jibExtension;

    public SyncMapTask setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }

    @TaskAction
    public void listFilesAndTargets() {
        Preconditions.checkNotNull((Object)this.jibExtension);
        try (TempDirectoryProvider tempDirectoryProvider = new TempDirectoryProvider();){
            GradleProjectProperties projectProperties = GradleProjectProperties.getForProject(this.getProject(), this.getLogger(), tempDirectoryProvider, (String)this.jibExtension.getConfigurationName().get());
            GradleRawConfiguration configuration = new GradleRawConfiguration(this.jibExtension);
            if (projectProperties.isWarProject()) {
                throw new GradleException("Skaffold sync is currently only available for 'jar' style Jib projects, but the project " + this.getProject().getName() + " is configured to generate a 'war'");
            }
            try {
                if (!ContainerizingMode.EXPLODED.equals((Object)ContainerizingMode.from(this.jibExtension.getContainerizingMode()))) {
                    throw new GradleException("Skaffold sync is currently only available for Jib projects in 'exploded' containerizing mode, but the containerizing mode of " + this.getProject().getName() + " is '" + this.jibExtension.getContainerizingMode() + "'");
                }
            }
            catch (InvalidContainerizingModeException ex) {
                throw new GradleException("Invalid containerizing mode", (Throwable)ex);
            }
            try {
                String syncMapJson = PluginConfigurationProcessor.getSkaffoldSyncMap(configuration, projectProperties, this.jibExtension.getSkaffold().getSync().getExcludes());
                System.out.println();
                System.out.println("BEGIN JIB JSON: SYNCMAP/1");
                System.out.println(syncMapJson);
            }
            catch (Exception ex) {
                throw new GradleException("Failed to generate a Jib file map for sync with Skaffold", (Throwable)ex);
            }
        }
    }
}

