/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.CredentialRetriever;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;

public class DefaultCredentialRetrievers {
    private static final Path DOCKER_CONFIG_FILE = Paths.get("config.json", new String[0]);
    private static final Path KUBERNETES_DOCKER_CONFIG_FILE = Paths.get(".dockerconfigjson", new String[0]);
    private static final Path LEGACY_DOCKER_CONFIG_FILE = Paths.get(".dockercfg", new String[0]);
    private static final Path XDG_AUTH_FILE = Paths.get("containers", new String[0]).resolve("auth.json");
    private final CredentialRetrieverFactory credentialRetrieverFactory;
    @Nullable
    private CredentialRetriever knownCredentialRetriever;
    @Nullable
    private CredentialRetriever inferredCredentialRetriever;
    @Nullable
    private String credentialHelper;
    private final Properties systemProperties;
    private final Map<String, String> environment;

    public static DefaultCredentialRetrievers init(CredentialRetrieverFactory credentialRetrieverFactory) {
        return new DefaultCredentialRetrievers(credentialRetrieverFactory, System.getProperties(), System.getenv());
    }

    @VisibleForTesting
    DefaultCredentialRetrievers(CredentialRetrieverFactory credentialRetrieverFactory, Properties systemProperties, Map<String, String> environment) {
        this.credentialRetrieverFactory = credentialRetrieverFactory;
        this.systemProperties = systemProperties;
        this.environment = environment;
    }

    public DefaultCredentialRetrievers setKnownCredential(Credential knownCredential, String credentialSource) {
        this.knownCredentialRetriever = this.credentialRetrieverFactory.known(knownCredential, credentialSource);
        return this;
    }

    public DefaultCredentialRetrievers setInferredCredential(Credential inferredCredential, String credentialSource) {
        this.inferredCredentialRetriever = this.credentialRetrieverFactory.known(inferredCredential, credentialSource);
        return this;
    }

    public DefaultCredentialRetrievers setCredentialHelper(@Nullable String credentialHelper) {
        this.credentialHelper = credentialHelper;
        return this;
    }

    public List<CredentialRetriever> asList() throws FileNotFoundException {
        String dockerConfigEnv;
        String homeEnvVar;
        String homeProperty;
        String xdgConfigHome;
        ArrayList<CredentialRetriever> credentialRetrievers = new ArrayList<CredentialRetriever>();
        if (this.knownCredentialRetriever != null) {
            credentialRetrievers.add(this.knownCredentialRetriever);
        }
        if (this.credentialHelper != null) {
            if (this.credentialHelper.contains(FileSystems.getDefault().getSeparator())) {
                String osName;
                if (!(Files.exists(Paths.get(this.credentialHelper, new String[0]), new LinkOption[0]) || (osName = this.systemProperties.getProperty("os.name").toLowerCase(Locale.ENGLISH)).contains("windows") && (Files.exists(Paths.get(this.credentialHelper + ".cmd", new String[0]), new LinkOption[0]) || Files.exists(Paths.get(this.credentialHelper + ".exe", new String[0]), new LinkOption[0])))) {
                    throw new FileNotFoundException("Specified credential helper was not found: " + this.credentialHelper);
                }
                credentialRetrievers.add(this.credentialRetrieverFactory.dockerCredentialHelper(this.credentialHelper));
            } else {
                String suffix = this.credentialHelper;
                credentialRetrievers.add(this.credentialRetrieverFactory.dockerCredentialHelper("docker-credential-" + suffix));
            }
        }
        if (this.inferredCredentialRetriever != null) {
            credentialRetrievers.add(this.inferredCredentialRetriever);
        }
        LinkedHashSet<Path> dockerConfigFiles = new LinkedHashSet<Path>();
        String xdgRuntime = this.environment.get("XDG_RUNTIME_DIR");
        if (xdgRuntime != null) {
            dockerConfigFiles.add(Paths.get(xdgRuntime, new String[0]).resolve(XDG_AUTH_FILE));
        }
        if ((xdgConfigHome = this.environment.get("XDG_CONFIG_HOME")) != null) {
            dockerConfigFiles.add(Paths.get(xdgConfigHome, new String[0]).resolve(XDG_AUTH_FILE));
        }
        if ((homeProperty = this.systemProperties.getProperty("user.home")) != null) {
            dockerConfigFiles.add(Paths.get(homeProperty, new String[0]).resolve(".config").resolve(XDG_AUTH_FILE));
        }
        if ((homeEnvVar = this.environment.get("HOME")) != null) {
            dockerConfigFiles.add(Paths.get(homeEnvVar, new String[0]).resolve(".config").resolve(XDG_AUTH_FILE));
        }
        if ((dockerConfigEnv = this.environment.get("DOCKER_CONFIG")) != null) {
            dockerConfigFiles.addAll(this.getDockerFiles(Paths.get(dockerConfigEnv, new String[0])));
        }
        if (homeProperty != null) {
            dockerConfigFiles.addAll(this.getDockerFiles(Paths.get(homeProperty, new String[0]).resolve(".docker")));
        }
        if (homeEnvVar != null) {
            dockerConfigFiles.addAll(this.getDockerFiles(Paths.get(homeEnvVar, new String[0]).resolve(".docker")));
        }
        dockerConfigFiles.stream().map(path -> path.endsWith(LEGACY_DOCKER_CONFIG_FILE) ? this.credentialRetrieverFactory.legacyDockerConfig((Path)path) : this.credentialRetrieverFactory.dockerConfig((Path)path)).forEach(credentialRetrievers::add);
        credentialRetrievers.add(this.credentialRetrieverFactory.wellKnownCredentialHelpers());
        credentialRetrievers.add(this.credentialRetrieverFactory.googleApplicationDefaultCredentials());
        return credentialRetrievers;
    }

    private List<Path> getDockerFiles(Path configDir) {
        return Arrays.asList(configDir.resolve(DOCKER_CONFIG_FILE), configDir.resolve(KUBERNETES_DOCKER_CONFIG_FILE), configDir.resolve(LEGACY_DOCKER_CONFIG_FILE));
    }
}

