/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.SuccessorsFunction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TarjanSCCs {
    public static <NodeT> ImmutableSet<ImmutableSet<NodeT>> compute(ImmutableCollection<NodeT> nodes, SuccessorsFunction<NodeT> successorsFunction) {
        return ((TarjanSCC)new TarjanSCC<NodeT>(nodes, successorsFunction)).compute();
    }

    private TarjanSCCs() {
    }

    private static class TarjanSCC<NodeT> {
        private final ImmutableCollection<NodeT> nodes;
        private final SuccessorsFunction<NodeT> successorsFunction;
        private final Deque<NodeT> stack;
        private final Set<NodeT> onStack;
        private final Map<NodeT, Integer> indexes;
        private final Map<NodeT, Integer> lowLinks;
        private final List<ImmutableSet<NodeT>> stronglyConnectedComponents = new ArrayList<ImmutableSet<NodeT>>();

        TarjanSCC(ImmutableCollection<NodeT> nodes, SuccessorsFunction<NodeT> successorsFunction) {
            this.nodes = nodes;
            this.successorsFunction = successorsFunction;
            this.stack = new ArrayDeque<NodeT>(nodes.size());
            this.onStack = Sets.newHashSetWithExpectedSize((int)nodes.size());
            this.indexes = Maps.newHashMapWithExpectedSize((int)nodes.size());
            this.lowLinks = Maps.newHashMapWithExpectedSize((int)nodes.size());
        }

        private ImmutableSet<ImmutableSet<NodeT>> compute() {
            Preconditions.checkState((boolean)this.indexes.isEmpty(), (Object)"TarjanSCC#compute() can only be called once per instance!");
            for (Object node : this.nodes) {
                if (this.indexes.containsKey(node)) continue;
                this.stronglyConnect(node);
            }
            return ImmutableSet.copyOf(this.stronglyConnectedComponents);
        }

        private void stronglyConnect(NodeT node) {
            this.lowLinks.put(node, this.indexes.size());
            this.indexes.put(node, this.indexes.size());
            this.stack.push(node);
            this.onStack.add(node);
            for (Object successor : this.successorsFunction.successors(node)) {
                if (!this.indexes.containsKey(successor)) {
                    this.stronglyConnect(successor);
                    this.lowLinks.put(node, Math.min(this.lowLinks.get(node), this.lowLinks.get(successor)));
                    continue;
                }
                if (!this.onStack.contains(successor)) continue;
                this.lowLinks.put(node, Math.min(this.lowLinks.get(node), this.indexes.get(successor)));
            }
            if (this.lowLinks.get(node).equals(this.indexes.get(node))) {
                NodeT currNode;
                ImmutableSet.Builder scc = ImmutableSet.builder();
                do {
                    currNode = this.stack.pop();
                    this.onStack.remove(currNode);
                    scc.add(currNode);
                } while (!node.equals(currNode));
                this.stronglyConnectedComponents.add(scc.build());
            }
        }
    }
}

