/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.kotlin;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.AutoValue_KotlinMetadata;
import dagger.internal.codegen.kotlin.AutoValue_KotlinMetadata_ClassMetadata;
import dagger.internal.codegen.kotlin.AutoValue_KotlinMetadata_FunctionMetadata;
import dagger.internal.codegen.kotlin.AutoValue_KotlinMetadata_MethodForAnnotations;
import dagger.internal.codegen.kotlin.AutoValue_KotlinMetadata_PropertyMetadata;
import dagger.internal.codegen.kotlin.AutoValue_KotlinMetadata_ValueParameterMetadata;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.kotlinx.metadata.Flag;
import dagger.spi.shaded.kotlinx.metadata.KmClass;
import dagger.spi.shaded.kotlinx.metadata.KmConstructor;
import dagger.spi.shaded.kotlinx.metadata.KmFunction;
import dagger.spi.shaded.kotlinx.metadata.KmProperty;
import dagger.spi.shaded.kotlinx.metadata.jvm.JvmExtensionsKt;
import dagger.spi.shaded.kotlinx.metadata.jvm.JvmFieldSignature;
import dagger.spi.shaded.kotlinx.metadata.jvm.JvmMetadataUtil;
import dagger.spi.shaded.kotlinx.metadata.jvm.JvmMethodSignature;
import dagger.spi.shaded.kotlinx.metadata.jvm.KotlinClassMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import kotlin.Metadata;

@AutoValue
abstract class KotlinMetadata {
    private static final String DELEGATED_PROPERTY_NAME_SUFFIX = "$delegate";
    private final Map<XFieldElement, Optional<MethodForAnnotations>> elementFieldAnnotationMethodMap = new HashMap<XFieldElement, Optional<MethodForAnnotations>>();
    private final Map<XFieldElement, Optional<XMethodElement>> elementFieldGetterMethodMap = new HashMap<XFieldElement, Optional<XMethodElement>>();

    KotlinMetadata() {
    }

    abstract XTypeElement typeElement();

    abstract ClassMetadata classMetadata();

    @Memoized
    ImmutableMap<String, XMethodElement> methodDescriptors() {
        return (ImmutableMap)this.typeElement().getDeclaredMethods().stream().collect(DaggerStreams.toImmutableMap(XExecutableElement::getJvmDescriptor, Function.identity()));
    }

    Optional<XMethodElement> getSyntheticAnnotationMethod(XFieldElement fieldElement) {
        return this.getAnnotationMethod(fieldElement).map(methodForAnnotations -> {
            if (methodForAnnotations == MethodForAnnotations.MISSING) {
                throw new IllegalStateException("Method for annotations is missing for " + fieldElement);
            }
            return methodForAnnotations.method();
        });
    }

    boolean isMissingSyntheticAnnotationMethod(XFieldElement fieldElement) {
        return this.getAnnotationMethod(fieldElement).map(methodForAnnotations -> methodForAnnotations == MethodForAnnotations.MISSING).orElse(false);
    }

    private Optional<MethodForAnnotations> getAnnotationMethod(XFieldElement fieldElement) {
        return this.elementFieldAnnotationMethodMap.computeIfAbsent(fieldElement, this::getAnnotationMethodUncached);
    }

    private Optional<MethodForAnnotations> getAnnotationMethodUncached(XFieldElement fieldElement) {
        return this.findProperty(fieldElement).methodForAnnotationsSignature().map(signature -> Optional.ofNullable((XMethodElement)this.methodDescriptors().get(signature)).map(MethodForAnnotations::create).orElse(MethodForAnnotations.MISSING));
    }

    Optional<XMethodElement> getPropertyGetter(XFieldElement fieldElement) {
        return this.elementFieldGetterMethodMap.computeIfAbsent(fieldElement, this::getPropertyGetterUncached);
    }

    private Optional<XMethodElement> getPropertyGetterUncached(XFieldElement fieldElement) {
        return this.findProperty(fieldElement).getterSignature().flatMap(signature -> Optional.ofNullable((XMethodElement)this.methodDescriptors().get(signature)));
    }

    private PropertyMetadata findProperty(XFieldElement field) {
        String fieldDescriptor = field.getJvmDescriptor();
        if (this.classMetadata().propertiesByFieldSignature().containsKey((Object)fieldDescriptor)) {
            return (PropertyMetadata)this.classMetadata().propertiesByFieldSignature().get((Object)fieldDescriptor);
        }
        String propertyName = KotlinMetadata.getPropertyNameFromField(field);
        return (PropertyMetadata)this.classMetadata().propertiesByFieldSignature().values().stream().filter(property -> propertyName.contentEquals(property.name())).collect(DaggerCollectors.onlyElement());
    }

    private static String getPropertyNameFromField(XFieldElement field) {
        String name = XElements.getSimpleName((XElement)field);
        if (name.endsWith(DELEGATED_PROPERTY_NAME_SUFFIX)) {
            return name.substring(0, name.length() - DELEGATED_PROPERTY_NAME_SUFFIX.length());
        }
        return name;
    }

    static KotlinMetadata from(XTypeElement typeElement) {
        return new AutoValue_KotlinMetadata(typeElement, ClassMetadata.create(KotlinMetadata.metadataOf(typeElement)));
    }

    private static KotlinClassMetadata.Class metadataOf(XTypeElement typeElement) {
        XAnnotation annotationMirror = typeElement.getAnnotation(TypeNames.KOTLIN_METADATA);
        Preconditions.checkNotNull((Object)annotationMirror);
        Metadata metadataAnnotation = JvmMetadataUtil.Metadata((Integer)annotationMirror.getAsInt("k"), (int[])annotationMirror.getAsIntList("mv").stream().mapToInt(Integer::intValue).toArray(), (String[])annotationMirror.getAsStringList("d1").toArray(new String[0]), (String[])annotationMirror.getAsStringList("d2").toArray(new String[0]), (String)annotationMirror.getAsString("xs"), (String)(annotationMirror.getAnnotationValue("pn").hasStringValue() ? annotationMirror.getAsString("pn") : null), annotationMirror.getAnnotationValue("xi").hasIntValue() ? Integer.valueOf(annotationMirror.getAsInt("xi")) : null);
        KotlinClassMetadata metadata = KotlinClassMetadata.read((Metadata)metadataAnnotation);
        if (metadata == null) {
            throw new IllegalStateException("Unable to read Kotlin metadata due to unsupported metadata version.");
        }
        if (metadata instanceof KotlinClassMetadata.Class) {
            return (KotlinClassMetadata.Class)metadata;
        }
        throw new IllegalStateException("Unsupported metadata type: " + metadata);
    }

    @AutoValue
    static abstract class MethodForAnnotations {
        static final MethodForAnnotations MISSING = MethodForAnnotations.create(null);

        MethodForAnnotations() {
        }

        static MethodForAnnotations create(XMethodElement method) {
            return new AutoValue_KotlinMetadata_MethodForAnnotations(method);
        }

        @Nullable
        abstract XMethodElement method();
    }

    static abstract class BaseMetadata {
        BaseMetadata() {
        }

        abstract int flags();

        boolean flags(Flag flag) {
            return flag.invoke(this.flags());
        }

        abstract String name();

        static interface Builder<BuilderT> {
            public BuilderT flags(int var1);

            public BuilderT name(String var1);
        }
    }

    @AutoValue
    static abstract class ValueParameterMetadata
    extends BaseMetadata {
        ValueParameterMetadata() {
        }

        private static ValueParameterMetadata create(int flags, String name) {
            return new AutoValue_KotlinMetadata_ValueParameterMetadata(flags, name);
        }
    }

    @AutoValue
    static abstract class PropertyMetadata
    extends BaseMetadata {
        PropertyMetadata() {
        }

        abstract Optional<String> fieldSignature();

        abstract Optional<String> getterSignature();

        abstract Optional<String> methodForAnnotationsSignature();

        static PropertyMetadata create(KmProperty metadata) {
            Builder builder = PropertyMetadata.builder(metadata.getFlags(), metadata.getName());
            builder.fieldSignature(Optional.ofNullable(JvmExtensionsKt.getFieldSignature((KmProperty)metadata)).map(JvmFieldSignature::asString));
            builder.getterSignature(Optional.ofNullable(JvmExtensionsKt.getGetterSignature((KmProperty)metadata)).map(JvmMethodSignature::asString));
            builder.methodForAnnotationsSignature(Optional.ofNullable(JvmExtensionsKt.getSyntheticMethodForAnnotations((KmProperty)metadata)).map(JvmMethodSignature::asString));
            return builder.build();
        }

        private static Builder builder(int flags, String name) {
            return (Builder)new AutoValue_KotlinMetadata_PropertyMetadata.Builder().flags(flags).name(name);
        }

        @AutoValue.Builder
        static interface Builder
        extends BaseMetadata.Builder<Builder> {
            public Builder fieldSignature(Optional<String> var1);

            public Builder getterSignature(Optional<String> var1);

            public Builder methodForAnnotationsSignature(Optional<String> var1);

            public PropertyMetadata build();
        }
    }

    @AutoValue
    static abstract class FunctionMetadata
    extends BaseMetadata {
        FunctionMetadata() {
        }

        abstract String signature();

        abstract ImmutableList<ValueParameterMetadata> parameters();

        static FunctionMetadata create(KmConstructor metadata) {
            Builder builder = FunctionMetadata.builder(metadata.getFlags(), "<init>");
            metadata.getValueParameters().forEach(it -> builder.addParameter(ValueParameterMetadata.create(it.getFlags(), it.getName())));
            builder.signature(Objects.requireNonNull(JvmExtensionsKt.getSignature((KmConstructor)metadata)).asString());
            return builder.build();
        }

        static FunctionMetadata create(KmFunction metadata) {
            Builder builder = FunctionMetadata.builder(metadata.getFlags(), metadata.getName());
            metadata.getValueParameters().forEach(it -> builder.addParameter(ValueParameterMetadata.create(it.getFlags(), it.getName())));
            builder.signature(Objects.requireNonNull(JvmExtensionsKt.getSignature((KmFunction)metadata)).asString());
            return builder.build();
        }

        private static Builder builder(int flags, String name) {
            return (Builder)new AutoValue_KotlinMetadata_FunctionMetadata.Builder().flags(flags).name(name);
        }

        @AutoValue.Builder
        static abstract class Builder
        implements BaseMetadata.Builder<Builder> {
            Builder() {
            }

            abstract Builder signature(String var1);

            abstract ImmutableList.Builder<ValueParameterMetadata> parametersBuilder();

            Builder addParameter(ValueParameterMetadata parameter) {
                this.parametersBuilder().add((Object)parameter);
                return this;
            }

            abstract FunctionMetadata build();
        }
    }

    @AutoValue
    static abstract class ClassMetadata
    extends BaseMetadata {
        ClassMetadata() {
        }

        abstract Optional<String> companionObjectName();

        abstract ImmutableSet<FunctionMetadata> constructors();

        abstract ImmutableMap<String, FunctionMetadata> functionsBySignature();

        abstract ImmutableMap<String, PropertyMetadata> propertiesByFieldSignature();

        static ClassMetadata create(KotlinClassMetadata.Class metadata) {
            KmClass kmClass = metadata.toKmClass();
            Builder builder = ClassMetadata.builder(kmClass.getFlags(), kmClass.getName());
            builder.companionObjectName(Optional.ofNullable(kmClass.getCompanionObject()));
            kmClass.getConstructors().forEach(it -> builder.addConstructor(FunctionMetadata.create(it)));
            kmClass.getFunctions().forEach(it -> builder.addFunction(FunctionMetadata.create(it)));
            kmClass.getProperties().forEach(it -> builder.addProperty(PropertyMetadata.create(it)));
            return builder.build();
        }

        private static Builder builder(int flags, String name) {
            return (Builder)new AutoValue_KotlinMetadata_ClassMetadata.Builder().flags(flags).name(name);
        }

        @AutoValue.Builder
        static abstract class Builder
        implements BaseMetadata.Builder<Builder> {
            Builder() {
            }

            abstract Builder companionObjectName(Optional<String> var1);

            abstract ImmutableSet.Builder<FunctionMetadata> constructorsBuilder();

            abstract ImmutableMap.Builder<String, FunctionMetadata> functionsBySignatureBuilder();

            abstract ImmutableMap.Builder<String, PropertyMetadata> propertiesByFieldSignatureBuilder();

            Builder addConstructor(FunctionMetadata constructor) {
                this.constructorsBuilder().add((Object)constructor);
                this.functionsBySignatureBuilder().put((Object)constructor.signature(), (Object)constructor);
                return this;
            }

            Builder addFunction(FunctionMetadata function) {
                this.functionsBySignatureBuilder().put((Object)function.signature(), (Object)function);
                return this;
            }

            Builder addProperty(PropertyMetadata property) {
                if (property.fieldSignature().isPresent()) {
                    this.propertiesByFieldSignatureBuilder().put((Object)property.fieldSignature().get(), (Object)property);
                }
                return this;
            }

            abstract ClassMetadata build();
        }
    }
}

