/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotationKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeKt;
import java.util.List;
import javax.inject.Inject;

public final class MapKeyValidator {
    private final XProcessingEnv processingEnv;

    @Inject
    MapKeyValidator(XProcessingEnv processingEnv) {
        this.processingEnv = processingEnv;
    }

    public ValidationReport validate(XTypeElement element) {
        ValidationReport.Builder builder = ValidationReport.about((XElement)element);
        List members = element.getDeclaredMethods();
        if (members.isEmpty()) {
            builder.addError("Map key annotations must have members", (XElement)element);
        } else if (((Boolean)XAnnotationKt.get((XAnnotation)element.getAnnotation(TypeNames.MAP_KEY), (String)"unwrapValue", Boolean.class)).booleanValue()) {
            if (members.size() > 1) {
                builder.addError("Map key annotations with unwrapped values must have exactly one member", (XElement)element);
            } else if (XTypeKt.isArray((XType)((XMethodElement)members.get(0)).getReturnType())) {
                builder.addError("Map key annotations with unwrapped values cannot use arrays", (XElement)element);
            }
        } else if (this.autoAnnotationIsMissing()) {
            builder.addError("@AutoAnnotation is a necessary dependency if @MapKey(unwrapValue = false). Add a dependency for the annotation, \"com.google.auto.value:auto-value-annotations:<current version>\", and the annotation processor, \"com.google.auto.value:auto-value:<current version>\"");
        }
        return builder.build();
    }

    private boolean autoAnnotationIsMissing() {
        return this.processingEnv.findTypeElement("com.google.auto.value.AutoAnnotation") == null;
    }
}

