/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.codegen.base.OptionalType;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.AutoValue_OptionalFactories_PresentFactorySpec;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.GeneratedImplementation;
import dagger.internal.codegen.writing.PerGeneratedFile;
import dagger.internal.codegen.writing.TopLevel;
import dagger.producers.internal.Producers;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

final class OptionalFactories {
    private final PerGeneratedFileCache perGeneratedFileCache;
    private final GeneratedImplementation topLevelImplementation;

    @Inject
    OptionalFactories(PerGeneratedFileCache perGeneratedFileCache, @TopLevel GeneratedImplementation topLevelImplementation) {
        this.perGeneratedFileCache = perGeneratedFileCache;
        this.topLevelImplementation = topLevelImplementation;
    }

    CodeBlock absentOptionalProvider(ContributionBinding binding) {
        Verify.verify((boolean)binding.bindingType().equals((Object)BindingType.PROVISION), (String)"Absent optional bindings should be provisions: %s", (Object)binding);
        OptionalType.OptionalKind optionalKind = OptionalType.from(binding.key()).kind();
        return CodeBlock.of((String)"$N()", (Object[])new Object[]{this.perGeneratedFileCache.absentOptionalProviderMethods.computeIfAbsent(optionalKind, kind -> {
            MethodSpec method = this.absentOptionalProviderMethod((OptionalType.OptionalKind)((Object)kind));
            this.topLevelImplementation.addMethod(ComponentImplementation.MethodSpecKind.ABSENT_OPTIONAL_METHOD, method);
            return method;
        })});
    }

    private MethodSpec absentOptionalProviderMethod(OptionalType.OptionalKind optionalKind) {
        TypeVariableName typeVariable = TypeVariableName.get((String)"T");
        return MethodSpec.methodBuilder((String)String.format("absent%sProvider", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, optionalKind.name()))).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addTypeVariable(typeVariable).returns((TypeName)TypeNames.providerOf((TypeName)optionalKind.of((TypeName)typeVariable))).addJavadoc("Returns a {@link $T} that returns {@code $L}.", new Object[]{TypeNames.PROVIDER, optionalKind.absentValueExpression()}).addCode("$L // safe covariant cast\n", new Object[]{AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0])}).addStatement("$1T provider = ($1T) $2N", new Object[]{TypeNames.providerOf((TypeName)optionalKind.of((TypeName)typeVariable)), this.perGeneratedFileCache.absentOptionalProviderFields.computeIfAbsent(optionalKind, kind -> {
            FieldSpec field = this.absentOptionalProviderField((OptionalType.OptionalKind)((Object)kind));
            this.topLevelImplementation.addField(ComponentImplementation.FieldSpecKind.ABSENT_OPTIONAL_FIELD, field);
            return field;
        })}).addStatement("return provider", new Object[0]).build();
    }

    private FieldSpec absentOptionalProviderField(OptionalType.OptionalKind optionalKind) {
        return FieldSpec.builder((TypeName)TypeNames.PROVIDER, (String)String.format("ABSENT_%s_PROVIDER", optionalKind.name()), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0])).initializer("$T.create($L)", new Object[]{InstanceFactory.class, optionalKind.absentValueExpression()}).addJavadoc("A {@link $T} that returns {@code $L}.", new Object[]{TypeNames.PROVIDER, optionalKind.absentValueExpression()}).build();
    }

    CodeBlock presentOptionalFactory(ContributionBinding binding, CodeBlock delegateFactory) {
        return CodeBlock.of((String)"$N.of($L)", (Object[])new Object[]{this.perGeneratedFileCache.presentFactoryClasses.computeIfAbsent(PresentFactorySpec.of(binding), spec -> {
            TypeSpec type = this.presentOptionalFactoryClass((PresentFactorySpec)spec);
            this.topLevelImplementation.addType(ComponentImplementation.TypeSpecKind.PRESENT_FACTORY, type);
            return type;
        }), delegateFactory});
    }

    private TypeSpec presentOptionalFactoryClass(PresentFactorySpec spec) {
        FieldSpec delegateField = FieldSpec.builder((TypeName)spec.delegateType(), (String)"delegate", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        ParameterSpec delegateParameter = ParameterSpec.builder((TypeName)delegateField.type, (String)"delegate", (Modifier[])new Modifier[0]).build();
        TypeSpec.Builder factoryClassBuilder = TypeSpec.classBuilder((String)spec.factoryClassName()).addTypeVariable(spec.typeVariable()).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addJavadoc("A {@code $T} that uses a delegate {@code $T}.", new Object[]{spec.factoryType(), delegateField.type});
        spec.superclass().ifPresent(arg_0 -> ((TypeSpec.Builder)factoryClassBuilder).superclass(arg_0));
        spec.superinterface().ifPresent(arg_0 -> ((TypeSpec.Builder)factoryClassBuilder).addSuperinterface(arg_0));
        return factoryClassBuilder.addField(delegateField).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(delegateParameter).addCode("this.$N = $T.checkNotNull($N);", new Object[]{delegateField, Preconditions.class, delegateParameter}).build()).addMethod(this.presentOptionalFactoryGetMethod(spec, delegateField)).addMethod(MethodSpec.methodBuilder((String)"of").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addTypeVariable(spec.typeVariable()).returns((TypeName)spec.factoryType()).addParameter(delegateParameter).addCode("return new $L<$T>($N);", new Object[]{spec.factoryClassName(), spec.typeVariable(), delegateParameter}).build()).build();
    }

    private MethodSpec presentOptionalFactoryGetMethod(PresentFactorySpec spec, FieldSpec delegateField) {
        MethodSpec.Builder getMethodBuilder = MethodSpec.methodBuilder((String)spec.factoryMethodName()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        switch (spec.frameworkType()) {
            case PROVIDER: {
                return getMethodBuilder.returns((TypeName)spec.optionalType()).addCode("return $L;", new Object[]{spec.optionalKind().presentExpression(FrameworkType.PROVIDER.to(spec.valueKind(), CodeBlock.of((String)"$N", (Object[])new Object[]{delegateField})))}).build();
            }
            case PRODUCER_NODE: {
                getMethodBuilder.returns((TypeName)TypeNames.listenableFutureOf((TypeName)spec.optionalType()));
                switch (spec.valueKind()) {
                    case FUTURE: 
                    case PRODUCER: {
                        return getMethodBuilder.addCode("return $T.immediateFuture($L);", new Object[]{Futures.class, spec.optionalKind().presentExpression(FrameworkType.PRODUCER_NODE.to(spec.valueKind(), CodeBlock.of((String)"$N", (Object[])new Object[]{delegateField})))}).build();
                    }
                    case INSTANCE: {
                        return getMethodBuilder.addCode("return $L;", new Object[]{OptionalFactories.transformFutureToOptional(spec.optionalKind(), (TypeName)spec.typeVariable(), CodeBlock.of((String)"$N.get()", (Object[])new Object[]{delegateField}))}).build();
                    }
                    case PRODUCED: {
                        return getMethodBuilder.addCode("return $L;", new Object[]{OptionalFactories.transformFutureToOptional(spec.optionalKind(), spec.valueType(), CodeBlock.of((String)"$T.createFutureProduced($N.get())", (Object[])new Object[]{Producers.class, delegateField}))}).build();
                    }
                }
                throw new UnsupportedOperationException(spec.factoryType() + " objects are not supported");
            }
        }
        throw new AssertionError((Object)spec.frameworkType());
    }

    private static CodeBlock transformFutureToOptional(OptionalType.OptionalKind optionalKind, TypeName inputType, CodeBlock inputFuture) {
        return CodeBlock.of((String)"$T.transform($L, $L, $T.directExecutor())", (Object[])new Object[]{Futures.class, inputFuture, TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{inputType, optionalKind.of(inputType)})).addMethod(MethodSpec.methodBuilder((String)"apply").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)optionalKind.of(inputType)).addParameter(inputType, "input", new Modifier[0]).addCode("return $L;", new Object[]{optionalKind.presentExpression(CodeBlock.of((String)"input", (Object[])new Object[0]))}).build()).build(), MoreExecutors.class});
    }

    @AutoValue
    static abstract class PresentFactorySpec {
        PresentFactorySpec() {
        }

        abstract FrameworkType frameworkType();

        abstract OptionalType.OptionalKind optionalKind();

        abstract RequestKind valueKind();

        TypeVariableName typeVariable() {
            return TypeVariableName.get((String)"T");
        }

        TypeName valueType() {
            return RequestKinds.requestTypeName(this.valueKind(), (TypeName)this.typeVariable());
        }

        ParameterizedTypeName optionalType() {
            return this.optionalKind().of(this.valueType());
        }

        ParameterizedTypeName factoryType() {
            return this.frameworkType().frameworkClassOf((TypeName)this.optionalType());
        }

        ParameterizedTypeName delegateType() {
            return this.frameworkType().frameworkClassOf((TypeName)this.typeVariable());
        }

        Optional<ParameterizedTypeName> superclass() {
            switch (this.frameworkType()) {
                case PRODUCER_NODE: {
                    return Optional.of(TypeNames.abstractProducerOf((TypeName)this.optionalType()));
                }
            }
            return Optional.empty();
        }

        Optional<ParameterizedTypeName> superinterface() {
            switch (this.frameworkType()) {
                case PROVIDER: {
                    return Optional.of(this.factoryType());
                }
            }
            return Optional.empty();
        }

        String factoryMethodName() {
            switch (this.frameworkType()) {
                case PROVIDER: {
                    return "get";
                }
                case PRODUCER_NODE: {
                    return "compute";
                }
            }
            throw new AssertionError((Object)this.frameworkType());
        }

        String factoryClassName() {
            return "Present" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.optionalKind().name()) + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.valueKind().toString()) + this.frameworkType().frameworkClassName().simpleName();
        }

        private static PresentFactorySpec of(ContributionBinding binding) {
            return new AutoValue_OptionalFactories_PresentFactorySpec(FrameworkType.forBindingType(binding.bindingType()), OptionalType.from(binding.key()).kind(), ((DependencyRequest)Iterables.getOnlyElement(binding.dependencies())).kind());
        }
    }

    @PerGeneratedFile
    static final class PerGeneratedFileCache {
        private final Map<PresentFactorySpec, TypeSpec> presentFactoryClasses = new TreeMap<PresentFactorySpec, TypeSpec>(Comparator.comparing(PresentFactorySpec::valueKind).thenComparing(PresentFactorySpec::frameworkType).thenComparing(PresentFactorySpec::optionalKind));
        private final Map<OptionalType.OptionalKind, MethodSpec> absentOptionalProviderMethods = new TreeMap<OptionalType.OptionalKind, MethodSpec>();
        private final Map<OptionalType.OptionalKind, FieldSpec> absentOptionalProviderFields = new TreeMap<OptionalType.OptionalKind, FieldSpec>();

        @Inject
        PerGeneratedFileCache() {
        }
    }
}

