/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.devtools.ksp.symbol.KSType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Optional;
import javax.lang.model.SourceVersion;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class XProcessingEnvs {
    public static boolean isPreJava8SourceVersion(XProcessingEnv processingEnv) {
        Optional<SourceVersion> javaSourceVersion = XProcessingEnvs.javaSourceVersion(processingEnv);
        return javaSourceVersion.isPresent() && javaSourceVersion.get().compareTo(SourceVersion.RELEASE_8) < 0;
    }

    private static Optional<SourceVersion> javaSourceVersion(XProcessingEnv processingEnv) {
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return Optional.of(XConverters.toJavac((XProcessingEnv)processingEnv).getSourceVersion());
            }
            case KSP: {
                return Optional.empty();
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + processingEnv.getBackend()));
    }

    public static boolean javacOverrides(XMethodElement overrider, XMethodElement overridden, XTypeElement type) {
        XProcessingEnv processingEnv = XConverters.getProcessingEnv((XElement)type);
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return XConverters.toJavac((XProcessingEnv)processingEnv).getElementUtils().overrides(XConverters.toJavac((XExecutableElement)overrider), XConverters.toJavac((XExecutableElement)overridden), XConverters.toJavac((XTypeElement)type));
            }
            case KSP: {
                return overrider.overrides(overridden, type);
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + processingEnv.getBackend()));
    }

    public static XType getUnboundedWildcardType(XProcessingEnv processingEnv) {
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return XConverters.toXProcessing((TypeMirror)XConverters.toJavac((XProcessingEnv)processingEnv).getTypeUtils().getWildcardType(null, null), (XProcessingEnv)processingEnv);
            }
            case KSP: {
                return (XType)XConverters.toXProcessing((KSType)XConverters.toKS((XType)processingEnv.requireType("java.util.List")).starProjection(), (XProcessingEnv)processingEnv).getTypeArguments().get(0);
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + processingEnv.getBackend()));
    }

    public static XType unwrapType(XType type) {
        XType unwrapped = XProcessingEnvs.unwrapTypeOrDefault(type, null);
        Preconditions.checkArgument((unwrapped != null ? 1 : 0) != 0, (String)"%s is a raw type", (Object)type);
        return unwrapped;
    }

    public static XType unwrapTypeOrObject(XType type, XProcessingEnv processingEnv) {
        return XProcessingEnvs.unwrapTypeOrDefault(type, processingEnv.requireType((TypeName)TypeName.OBJECT));
    }

    private static XType unwrapTypeOrDefault(XType type, XType defaultType) {
        XTypeElement typeElement = type.getTypeElement();
        Preconditions.checkArgument((!typeElement.getType().getTypeArguments().isEmpty() ? 1 : 0) != 0, (String)"%s does not have a type parameter", (Object)typeElement.getQualifiedName());
        return (XType)Iterables.getOnlyElement((Iterable)type.getTypeArguments(), (Object)defaultType);
    }

    public static XType getPrimitiveIntType(XProcessingEnv processingEnv) {
        return XConverters.toXProcessing((TypeMirror)XConverters.toJavac((XProcessingEnv)processingEnv).getTypeUtils().getPrimitiveType(TypeKind.INT), (XProcessingEnv)processingEnv);
    }

    public static XType wrapType(ClassName wrapper, XType type, XProcessingEnv processingEnv) {
        return processingEnv.getDeclaredType(processingEnv.requireTypeElement((TypeName)wrapper), new XType[]{type});
    }

    private XProcessingEnvs() {
    }
}

