/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XArrayType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMemberContainer;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeKt;
import java.util.Iterator;

public final class KeyVariableNamer {
    private static final ImmutableSet<String> VERY_SIMPLE_NAMES = ImmutableSet.of((Object)"Builder", (Object)"Factory", (Object)"Component", (Object)"Subcomponent", (Object)"Injector");

    private KeyVariableNamer() {
    }

    public static String name(Key key) {
        if (key.multibindingContributionIdentifier().isPresent()) {
            return XElements.getSimpleName((XElement)key.multibindingContributionIdentifier().get().bindingMethod().xprocessing());
        }
        StringBuilder builder = new StringBuilder();
        if (key.qualifier().isPresent()) {
            builder.append(XElements.getSimpleName((XMemberContainer)key.qualifier().get().xprocessing().getType().getTypeElement()));
        }
        KeyVariableNamer.typeNamer(key.type().xprocessing(), builder);
        return SourceFiles.protectAgainstKeywords(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, builder.toString()));
    }

    private static void typeNamer(XType type, StringBuilder builder) {
        if (XTypes.isDeclared(type)) {
            XTypeElement element = type.getTypeElement();
            if (element.isNested() && VERY_SIMPLE_NAMES.contains((Object)XElements.getSimpleName((XMemberContainer)element))) {
                builder.append(XElements.getSimpleName((XMemberContainer)element.getEnclosingTypeElement()));
            }
            builder.append(XElements.getSimpleName((XMemberContainer)element));
            Iterator argumentIterator = type.getTypeArguments().iterator();
            if (argumentIterator.hasNext()) {
                builder.append("Of");
                XType first = (XType)argumentIterator.next();
                KeyVariableNamer.typeNamer(first, builder);
                while (argumentIterator.hasNext()) {
                    builder.append("And");
                    KeyVariableNamer.typeNamer((XType)argumentIterator.next(), builder);
                }
            }
        } else if (XTypes.isPrimitive(type)) {
            builder.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, type.toString()));
        } else if (XTypeKt.isArray((XType)type)) {
            KeyVariableNamer.typeNamer(((XArrayType)type).getComponentType(), builder);
            builder.append("Array");
        }
    }
}

