/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.LazyClassKeyProviders;
import dagger.internal.codegen.writing.MultibindingFactoryCreationExpression;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import java.util.Optional;
import java.util.stream.Stream;

final class MapFactoryCreationExpression
extends MultibindingFactoryCreationExpression {
    private final XProcessingEnv processingEnv;
    private final ComponentImplementation componentImplementation;
    private final BindingGraph graph;
    private final ContributionBinding binding;
    private final boolean useLazyClassKey;
    private final LazyClassKeyProviders lazyClassKeyProviders;

    @AssistedInject
    MapFactoryCreationExpression(@Assisted ContributionBinding binding, XProcessingEnv processingEnv, ComponentImplementation componentImplementation, ComponentRequestRepresentations componentRequestRepresentations, BindingGraph graph) {
        super(binding, componentImplementation, componentRequestRepresentations);
        this.processingEnv = processingEnv;
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.componentImplementation = componentImplementation;
        this.graph = graph;
        this.useLazyClassKey = MapKeys.useLazyClassKey(binding, graph);
        this.lazyClassKeyProviders = componentImplementation.shardImplementation(binding).getLazyClassKeyProviders();
    }

    @Override
    public CodeBlock creationExpression() {
        ClassName mapFactoryClassName = SourceFiles.mapFactoryClassName(this.binding);
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.", new Object[]{mapFactoryClassName});
        ClassName valueTypeName = TypeName.OBJECT;
        if (!this.useRawType()) {
            MapType mapType = MapType.from(this.binding.key());
            valueTypeName = ((Optional)Stream.of(TypeNames.PROVIDER, TypeNames.PRODUCER, TypeNames.PRODUCED).filter(mapType::valuesAreTypeOf).map(mapType::unwrappedValueType).collect(DaggerCollectors.toOptional())).orElseGet(mapType::valueType).getTypeName();
            builder.add("<$T, $T>", new Object[]{this.useLazyClassKey ? TypeNames.STRING : mapType.keyType().getTypeName(), valueTypeName});
        }
        builder.add("builder($L)", new Object[]{this.binding.dependencies().size()});
        for (DependencyRequest dependency : this.binding.dependencies()) {
            ContributionBinding contributionBinding = this.graph.contributionBinding(dependency.key());
            builder.add(".put($L, $L)", new Object[]{this.useLazyClassKey ? this.lazyClassKeyProviders.getMapKeyExpression(dependency.key()) : MapKeys.getMapKeyExpression(contributionBinding, this.componentImplementation.name(), this.processingEnv), this.multibindingDependencyExpression(dependency)});
        }
        return this.useLazyClassKey ? CodeBlock.of((String)"$T.<$T>of($L)", (Object[])new Object[]{TypeNames.LAZY_CLASS_KEY_MAP_FACTORY, valueTypeName, builder.add(".build()", new Object[0]).build()}) : builder.add(".build()", new Object[0]).build();
    }

    @AssistedFactory
    static interface Factory {
        public MapFactoryCreationExpression create(ContributionBinding var1);
    }
}

