/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.viewmodel;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ImmutableNetwork;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.viewmodel.ViewModelValidationPluginKt;
import dagger.hilt.processor.internal.DaggerModelsKt;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.model.Binding;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.BindingGraphPlugin;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.DaggerProcessingEnv;
import dagger.spi.model.DaggerType;
import dagger.spi.model.DiagnosticReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ldagger/hilt/android/processor/internal/viewmodel/ViewModelValidationPlugin;", "Ldagger/spi/model/BindingGraphPlugin;", "()V", "daggerProcessingEnv", "Ldagger/spi/model/DaggerProcessingEnv;", "env", "Ldagger/spi/internal/shaded/androidx/room/compiler/processing/XProcessingEnv;", "getAssistedFactoryMethods", "", "Ldagger/spi/internal/shaded/androidx/room/compiler/processing/XMethodElement;", "factory", "Ldagger/spi/internal/shaded/androidx/room/compiler/processing/XTypeElement;", "getAssistedInjectTypeElement", "factoryType", "Ldagger/spi/internal/shaded/androidx/room/compiler/processing/XType;", "init", "", "processingEnv", "options", "", "", "isHiltViewModelBinding", "", "target", "Ldagger/spi/model/Binding;", "isInternalHiltViewModelUsage", "source", "Ldagger/spi/model/BindingGraph$Node;", "isInternalViewModelAssistedFactoryUsage", "isViewModelAssistedFactory", "onProcessingRoundBegin", "visitGraph", "bindingGraph", "Ldagger/spi/model/BindingGraph;", "diagnosticReporter", "Ldagger/spi/model/DiagnosticReporter;", "java_dagger_hilt_android_processor_internal_viewmodel-validation_plugin_lib"})
@AutoService(value={BindingGraphPlugin.class})
@SourceDebugExtension(value={"SMAP\nViewModelValidationPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewModelValidationPlugin.kt\ndagger/hilt/android/processor/internal/viewmodel/ViewModelValidationPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1855#2,2:179\n766#2:181\n857#2,2:182\n766#2:184\n857#2,2:185\n*S KotlinDebug\n*F\n+ 1 ViewModelValidationPlugin.kt\ndagger/hilt/android/processor/internal/viewmodel/ViewModelValidationPlugin\n*L\n69#1:179,2\n143#1:181\n143#1:182,2\n144#1:184\n144#1:185,2\n*E\n"})
public final class ViewModelValidationPlugin
implements BindingGraphPlugin {
    private XProcessingEnv env;
    private DaggerProcessingEnv daggerProcessingEnv;

    public void init(@NotNull DaggerProcessingEnv processingEnv, @NotNull Map<String, String> options) {
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.daggerProcessingEnv = processingEnv;
    }

    public void onProcessingRoundBegin() {
        DaggerProcessingEnv daggerProcessingEnv = this.daggerProcessingEnv;
        if (daggerProcessingEnv == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"daggerProcessingEnv");
            daggerProcessingEnv = null;
        }
        this.env = ViewModelValidationPluginKt.access$toXProcessingEnv(daggerProcessingEnv);
    }

    public void visitGraph(@NotNull BindingGraph bindingGraph, @NotNull DiagnosticReporter diagnosticReporter) {
        Intrinsics.checkNotNullParameter((Object)bindingGraph, (String)"bindingGraph");
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        if (bindingGraph.rootComponentNode().isSubcomponent()) {
            return;
        }
        ImmutableNetwork immutableNetwork = bindingGraph.network();
        Intrinsics.checkNotNullExpressionValue((Object)immutableNetwork, (String)"bindingGraph.network()");
        ImmutableNetwork network = immutableNetwork;
        ImmutableSet immutableSet = bindingGraph.dependencyEdges();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"bindingGraph.dependencyEdges()");
        Iterable $this$forEach$iv = (Iterable)immutableSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EndpointPair pair;
            BindingGraph.DependencyEdge edge = (BindingGraph.DependencyEdge)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)network.incidentNodes((Object)edge), (String)"network.incidentNodes(edge)");
            Object object = pair.target();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pair.target()");
            BindingGraph.Node target = (BindingGraph.Node)object;
            Object object2 = pair.source();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"pair.source()");
            BindingGraph.Node source = (BindingGraph.Node)object2;
            if (!(target instanceof Binding)) continue;
            if (this.isHiltViewModelBinding((Binding)target) && !this.isInternalHiltViewModelUsage(source)) {
                diagnosticReporter.reportDependency(Diagnostic.Kind.ERROR, edge, "\nInjection of an @HiltViewModel class is prohibited since it does not create a ViewModel instance correctly.\nAccess the ViewModel via the Android APIs (e.g. ViewModelProvider) instead.\nInjected ViewModel: " + ((Binding)target).key().type() + '\n');
                continue;
            }
            if (!this.isViewModelAssistedFactory((Binding)target) || this.isInternalViewModelAssistedFactoryUsage(source)) continue;
            diagnosticReporter.reportDependency(Diagnostic.Kind.ERROR, edge, "\nInjection of an assisted factory for Hilt ViewModel is prohibited since it can not be used to create a ViewModel instance correctly.\nAccess the ViewModel via the Android APIs (e.g. ViewModelProvider) instead.\nInjected factory: " + ((Binding)target).key().type() + '\n');
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isHiltViewModelBinding(Binding target) {
        if (target.kind() != BindingKind.INJECTION) return false;
        DaggerType daggerType = target.key().type();
        Intrinsics.checkNotNullExpressionValue((Object)daggerType, (String)"target.key().type()");
        ClassName className = AndroidClassNames.HILT_VIEW_MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"HILT_VIEW_MODEL");
        if (!DaggerModelsKt.hasAnnotation(daggerType, className)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInternalHiltViewModelUsage(BindingGraph.Node source) {
        if (!(source instanceof Binding)) return false;
        if (!((Binding)source).key().qualifier().isPresent()) return false;
        Object t = ((Binding)source).key().qualifier().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"source.key().qualifier().get()");
        if (!Intrinsics.areEqual((Object)DaggerModelsKt.getQualifiedName((DaggerAnnotation)t), (Object)AndroidClassNames.HILT_VIEW_MODEL_MAP_QUALIFIER.canonicalName())) return false;
        if (!((Binding)source).key().multibindingContributionIdentifier().isPresent()) return false;
        return true;
    }

    private final boolean isViewModelAssistedFactory(Binding target) {
        if (target.kind() != BindingKind.ASSISTED_FACTORY) {
            return false;
        }
        DaggerType factoryType = target.key().type();
        Intrinsics.checkNotNullExpressionValue((Object)factoryType, (String)"factoryType");
        XProcessingEnv xProcessingEnv = this.env;
        if (xProcessingEnv == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"env");
            xProcessingEnv = null;
        }
        XTypeElement xTypeElement = this.getAssistedInjectTypeElement(ViewModelValidationPluginKt.access$toXType(factoryType, xProcessingEnv));
        ClassName className = AndroidClassNames.HILT_VIEW_MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"HILT_VIEW_MODEL");
        return xTypeElement.hasAnnotation(className);
    }

    private final XTypeElement getAssistedInjectTypeElement(XType factoryType) {
        XTypeElement xTypeElement = ((XMethodElement)CollectionsKt.single(this.getAssistedFactoryMethods(factoryType.getTypeElement()))).asMemberOf(factoryType).getReturnType().getTypeElement();
        Intrinsics.checkNotNull((Object)xTypeElement);
        return xTypeElement;
    }

    private final List<XMethodElement> getAssistedFactoryMethods(XTypeElement factory) {
        XMethodElement it;
        Iterable $this$filterTo$iv$iv;
        ImmutableList immutableList = XTypeElements.getAllNonPrivateInstanceMethods((XTypeElement)factory);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getAllNonPrivateInstanceMethods(factory)");
        Iterable $this$filter$iv = (Iterable)immutableList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (XMethodElement)element$iv$iv;
            boolean bl = false;
            if (!it.isAbstract()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (XMethodElement)element$iv$iv;
            boolean bl = false;
            if (!(!it.isJavaDefault())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInternalViewModelAssistedFactoryUsage(BindingGraph.Node source) {
        if (!(source instanceof Binding)) return false;
        if (!((Binding)source).key().qualifier().isPresent()) return false;
        Object t = ((Binding)source).key().qualifier().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"source.key().qualifier().get()");
        if (!Intrinsics.areEqual((Object)DaggerModelsKt.getQualifiedName((DaggerAnnotation)t), (Object)AndroidClassNames.HILT_VIEW_MODEL_ASSISTED_FACTORY_MAP_QUALIFIER.canonicalName())) return false;
        if (!((Binding)source).key().multibindingContributionIdentifier().isPresent()) return false;
        return true;
    }
}

