/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.managers;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Bundle;
import android.view.LayoutInflater;
import androidx.fragment.app.Fragment;
import dagger.hilt.EntryPoint;
import dagger.hilt.InstallIn;
import dagger.hilt.android.components.ActivityComponent;
import dagger.hilt.android.internal.builders.FragmentComponentBuilder;
import dagger.hilt.android.internal.managers.ViewComponentManager;
import dagger.hilt.internal.GeneratedComponentManager;
import dagger.hilt.internal.Preconditions;

public class FragmentComponentManager
implements GeneratedComponentManager<Object> {
    private volatile Object component;
    private final Object componentLock = new Object();
    private final Fragment fragment;

    public FragmentComponentManager(Fragment fragment) {
        this.fragment = fragment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object generatedComponent() {
        if (this.component == null) {
            Object object = this.componentLock;
            synchronized (object) {
                if (this.component == null) {
                    this.component = this.createComponent();
                }
            }
        }
        return this.component;
    }

    private Object createComponent() {
        Preconditions.checkNotNull(this.fragment.getHost(), "Hilt Fragments must be attached before creating the component.");
        Preconditions.checkState(this.fragment.getHost() instanceof GeneratedComponentManager, "Hilt Fragments must be attached to an @AndroidEntryPoint Activity. Found: %s", this.fragment.getHost().getClass());
        this.validate(this.fragment);
        return ((FragmentComponentBuilderEntryPoint)((GeneratedComponentManager)this.fragment.getHost()).generatedComponent()).fragmentComponentBuilder().fragment(this.fragment).build();
    }

    public static final void initializeArguments(Fragment fragment) {
        Preconditions.checkNotNull(fragment);
        if (fragment.getArguments() == null) {
            fragment.setArguments(new Bundle());
        }
    }

    public static final Context findActivity(Context context) {
        while (context instanceof ContextWrapper && !(context instanceof Activity)) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        return context;
    }

    public static ContextWrapper createContextWrapper(Context base, Fragment fragment) {
        return new ViewComponentManager.FragmentContextWrapper(base, fragment);
    }

    public static ContextWrapper createContextWrapper(LayoutInflater baseInflater, Fragment fragment) {
        return new ViewComponentManager.FragmentContextWrapper(baseInflater, fragment);
    }

    protected void validate(Fragment fragment) {
    }

    @EntryPoint
    @InstallIn(value={ActivityComponent.class})
    public static interface FragmentComponentBuilderEntryPoint {
        public FragmentComponentBuilder fragmentComponentBuilder();
    }
}

