/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.managers;

import androidx.activity.ComponentActivity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import dagger.Binds;
import dagger.Module;
import dagger.hilt.EntryPoint;
import dagger.hilt.EntryPoints;
import dagger.hilt.InstallIn;
import dagger.hilt.android.ActivityRetainedLifecycle;
import dagger.hilt.android.components.ActivityRetainedComponent;
import dagger.hilt.android.internal.ThreadUtil;
import dagger.hilt.android.internal.builders.ActivityRetainedComponentBuilder;
import dagger.hilt.android.scopes.ActivityRetainedScoped;
import dagger.hilt.components.SingletonComponent;
import dagger.hilt.internal.GeneratedComponentManager;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;

final class ActivityRetainedComponentManager
implements GeneratedComponentManager<ActivityRetainedComponent> {
    private final ViewModelProvider viewModelProvider;
    @Nullable
    private volatile ActivityRetainedComponent component;
    private final Object componentLock = new Object();

    ActivityRetainedComponentManager(final ComponentActivity activity) {
        this.viewModelProvider = new ViewModelProvider((ViewModelStoreOwner)activity, new ViewModelProvider.Factory(){

            @NonNull
            public <T extends ViewModel> T create(@NonNull Class<T> aClass) {
                ActivityRetainedComponent component = ((ActivityRetainedComponentBuilderEntryPoint)EntryPoints.get((Object)activity.getApplication(), ActivityRetainedComponentBuilderEntryPoint.class)).retainedComponentBuilder().build();
                return (T)((Object)new ActivityRetainedComponentViewModel(component));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityRetainedComponent generatedComponent() {
        if (this.component == null) {
            Object object = this.componentLock;
            synchronized (object) {
                if (this.component == null) {
                    this.component = this.createComponent();
                }
            }
        }
        return this.component;
    }

    private ActivityRetainedComponent createComponent() {
        return ((ActivityRetainedComponentViewModel)this.viewModelProvider.get(ActivityRetainedComponentViewModel.class)).getComponent();
    }

    @Module
    @InstallIn(value={ActivityRetainedComponent.class})
    static abstract class LifecycleModule {
        LifecycleModule() {
        }

        @Binds
        abstract ActivityRetainedLifecycle bind(Lifecycle var1);
    }

    @ActivityRetainedScoped
    static final class Lifecycle
    implements ActivityRetainedLifecycle {
        private final Set<ActivityRetainedLifecycle.OnClearedListener> listeners = new HashSet<ActivityRetainedLifecycle.OnClearedListener>();
        private boolean onClearedDispatched = false;

        @Inject
        Lifecycle() {
        }

        @Override
        public void addOnClearedListener(@NonNull ActivityRetainedLifecycle.OnClearedListener listener) {
            ThreadUtil.ensureMainThread();
            this.throwIfOnClearedDispatched();
            this.listeners.add(listener);
        }

        @Override
        public void removeOnClearedListener(@NonNull ActivityRetainedLifecycle.OnClearedListener listener) {
            ThreadUtil.ensureMainThread();
            this.throwIfOnClearedDispatched();
            this.listeners.remove(listener);
        }

        void dispatchOnCleared() {
            ThreadUtil.ensureMainThread();
            this.onClearedDispatched = true;
            for (ActivityRetainedLifecycle.OnClearedListener listener : this.listeners) {
                listener.onCleared();
            }
        }

        private void throwIfOnClearedDispatched() {
            if (this.onClearedDispatched) {
                throw new IllegalStateException("There was a race between the call to add/remove an OnClearedListener and onCleared(). This can happen when posting to the Main thread from a background thread, which is not supported.");
            }
        }
    }

    static final class ActivityRetainedComponentViewModel
    extends ViewModel {
        private final ActivityRetainedComponent component;

        ActivityRetainedComponentViewModel(ActivityRetainedComponent component) {
            this.component = component;
        }

        ActivityRetainedComponent getComponent() {
            return this.component;
        }

        protected void onCleared() {
            super.onCleared();
            ActivityRetainedLifecycle lifecycle = ((ActivityRetainedLifecycleEntryPoint)EntryPoints.get((Object)this.component, ActivityRetainedLifecycleEntryPoint.class)).getActivityRetainedLifecycle();
            ((Lifecycle)lifecycle).dispatchOnCleared();
        }
    }

    @EntryPoint
    @InstallIn(value={ActivityRetainedComponent.class})
    public static interface ActivityRetainedLifecycleEntryPoint {
        public ActivityRetainedLifecycle getActivityRetainedLifecycle();
    }

    @EntryPoint
    @InstallIn(value={SingletonComponent.class})
    public static interface ActivityRetainedComponentBuilderEntryPoint {
        public ActivityRetainedComponentBuilder retainedComponentBuilder();
    }
}

