/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.managers;

import android.app.Application;
import android.app.Service;
import dagger.hilt.EntryPoint;
import dagger.hilt.EntryPoints;
import dagger.hilt.InstallIn;
import dagger.hilt.android.internal.builders.ServiceComponentBuilder;
import dagger.hilt.components.SingletonComponent;
import dagger.hilt.internal.GeneratedComponentManager;
import dagger.hilt.internal.Preconditions;

public final class ServiceComponentManager
implements GeneratedComponentManager<Object> {
    private final Service service;
    private Object component;

    public ServiceComponentManager(Service service) {
        this.service = service;
    }

    public Object generatedComponent() {
        if (this.component == null) {
            this.component = this.createComponent();
        }
        return this.component;
    }

    private Object createComponent() {
        Application application = this.service.getApplication();
        Preconditions.checkState((boolean)(application instanceof GeneratedComponentManager), (String)"Hilt service must be attached to an @AndroidEntryPoint Application. Found: %s", (Object[])new Object[]{application.getClass()});
        return ((ServiceComponentBuilderEntryPoint)EntryPoints.get((Object)application, ServiceComponentBuilderEntryPoint.class)).serviceComponentBuilder().service(this.service).build();
    }

    @EntryPoint
    @InstallIn(value={SingletonComponent.class})
    public static interface ServiceComponentBuilderEntryPoint {
        public ServiceComponentBuilder serviceComponentBuilder();
    }
}

