/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.lifecycle;

import android.os.Bundle;
import androidx.activity.ComponentActivity;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.savedstate.SavedStateRegistryOwner;
import dagger.Module;
import dagger.hilt.EntryPoint;
import dagger.hilt.EntryPoints;
import dagger.hilt.InstallIn;
import dagger.hilt.android.components.ActivityComponent;
import dagger.hilt.android.components.FragmentComponent;
import dagger.hilt.android.internal.builders.ViewModelComponentBuilder;
import dagger.hilt.android.internal.lifecycle.HiltViewModelFactory;
import dagger.hilt.android.internal.lifecycle.HiltViewModelMap;
import dagger.hilt.internal.Preconditions;
import dagger.multibindings.Multibinds;
import java.util.Set;
import javax.inject.Inject;

public final class DefaultViewModelFactories {
    public static ViewModelProvider.Factory getActivityFactory(ComponentActivity activity, ViewModelProvider.Factory delegateFactory) {
        return ((ActivityEntryPoint)EntryPoints.get((Object)activity, ActivityEntryPoint.class)).getHiltInternalFactoryFactory().fromActivity(activity, delegateFactory);
    }

    public static ViewModelProvider.Factory getFragmentFactory(Fragment fragment, ViewModelProvider.Factory delegateFactory) {
        return ((FragmentEntryPoint)EntryPoints.get((Object)fragment, FragmentEntryPoint.class)).getHiltInternalFactoryFactory().fromFragment(fragment, delegateFactory);
    }

    private DefaultViewModelFactories() {
    }

    @EntryPoint
    @InstallIn(value={FragmentComponent.class})
    public static interface FragmentEntryPoint {
        public InternalFactoryFactory getHiltInternalFactoryFactory();
    }

    @EntryPoint
    @InstallIn(value={ActivityComponent.class})
    public static interface ActivityEntryPoint {
        public InternalFactoryFactory getHiltInternalFactoryFactory();
    }

    @Module
    @InstallIn(value={ActivityComponent.class})
    static interface ActivityModule {
        @Multibinds
        @HiltViewModelMap.KeySet
        public Set<String> viewModelKeys();
    }

    public static final class InternalFactoryFactory {
        private final Set<String> keySet;
        private final ViewModelComponentBuilder viewModelComponentBuilder;

        @Inject
        InternalFactoryFactory(@HiltViewModelMap.KeySet Set<String> keySet, ViewModelComponentBuilder viewModelComponentBuilder) {
            this.keySet = keySet;
            this.viewModelComponentBuilder = viewModelComponentBuilder;
        }

        ViewModelProvider.Factory fromActivity(ComponentActivity activity, ViewModelProvider.Factory delegateFactory) {
            return this.getHiltViewModelFactory((SavedStateRegistryOwner)activity, activity.getIntent() != null ? activity.getIntent().getExtras() : null, delegateFactory);
        }

        ViewModelProvider.Factory fromFragment(Fragment fragment, ViewModelProvider.Factory delegateFactory) {
            return this.getHiltViewModelFactory((SavedStateRegistryOwner)fragment, fragment.getArguments(), delegateFactory);
        }

        private ViewModelProvider.Factory getHiltViewModelFactory(SavedStateRegistryOwner owner, @Nullable Bundle defaultArgs, ViewModelProvider.Factory delegate) {
            return new HiltViewModelFactory(owner, defaultArgs, this.keySet, (ViewModelProvider.Factory)Preconditions.checkNotNull((Object)delegate), this.viewModelComponentBuilder);
        }
    }
}

