/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.managers;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateHandleSupport;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.lifecycle.viewmodel.MutableCreationExtras;
import dagger.hilt.android.internal.ThreadUtil;
import dagger.hilt.internal.Preconditions;

public final class SavedStateHandleHolder {
    @Nullable
    private CreationExtras extras;
    @Nullable
    private SavedStateHandle handle;
    private final boolean isComponentActivity;

    public SavedStateHandleHolder(@Nullable CreationExtras extras) {
        this.isComponentActivity = extras != null;
        this.extras = extras;
    }

    public SavedStateHandle getSavedStateHandle() {
        ThreadUtil.ensureMainThread();
        Preconditions.checkState((boolean)this.isComponentActivity, (String)"Activity that does not extend ComponentActivity cannot use SavedStateHandle", (Object[])new Object[0]);
        if (this.handle != null) {
            return this.handle;
        }
        Preconditions.checkNotNull((Object)this.extras, (String)"The first access to SavedStateHandle should happen between super.onCreate() and super.onDestroy()");
        MutableCreationExtras mutableExtras = new MutableCreationExtras(this.extras);
        mutableExtras.set(SavedStateHandleSupport.DEFAULT_ARGS_KEY, (Object)Bundle.EMPTY);
        this.extras = mutableExtras;
        this.handle = SavedStateHandleSupport.createSavedStateHandle((CreationExtras)this.extras);
        this.extras = null;
        return this.handle;
    }

    public void clear() {
        this.extras = null;
    }

    public void setExtras(CreationExtras extras) {
        Preconditions.checkState((boolean)this.isComponentActivity, (String)"setExtras should only be called for an Activity that extends ComponentActivity", (Object[])new Object[0]);
        if (this.handle != null) {
            return;
        }
        this.extras = extras;
    }

    public boolean isInvalid() {
        return this.handle == null && this.extras == null;
    }
}

