/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Preconditions;
import com.google.firebase.auth.FirebaseCredential;
import com.google.firebase.auth.GoogleOAuthAccessToken;
import com.google.firebase.tasks.Tasks;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutionException;

public final class FirebaseCredentialsAdapter
extends GoogleCredentials {
    private final FirebaseCredential credential;

    public FirebaseCredentialsAdapter(FirebaseCredential credential) {
        this.credential = (FirebaseCredential)Preconditions.checkNotNull((Object)credential);
    }

    public AccessToken refreshAccessToken() throws IOException {
        try {
            GoogleOAuthAccessToken token = Tasks.await(this.credential.getAccessToken());
            return new AccessToken(token.getAccessToken(), new Date(token.getExpiryTime()));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Error while obtaining OAuth2 token", e);
        }
    }
}

