/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaca;
import com.google.android.gms.internal.measurement.zzacb;
import com.google.android.gms.internal.measurement.zzacd;
import com.google.android.gms.internal.measurement.zzea;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzen;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzjo;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzjt;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.internal.measurement.zzkc;
import com.google.android.gms.internal.measurement.zzkd;
import com.google.android.gms.internal.measurement.zzkg;
import com.google.android.gms.internal.measurement.zzkh;
import com.google.android.gms.internal.measurement.zzkk;
import com.google.android.gms.internal.measurement.zzkr;
import com.google.android.gms.internal.measurement.zzks;
import com.google.android.gms.internal.measurement.zzku;
import com.google.android.gms.internal.measurement.zzkv;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class zzek
extends zzjs {
    private static final String[] zzagl = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;"};
    private static final String[] zzagm = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzagn = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;", "ssaid_reporting_enabled", "ALTER TABLE apps ADD COLUMN ssaid_reporting_enabled INTEGER;"};
    private static final String[] zzago = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zzagp = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;", "retry_count", "ALTER TABLE queue ADD COLUMN retry_count INTEGER;"};
    private static final String[] zzagq = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private final zzen zzagr;
    private final zzjo zzags = new zzjo(this.zzbt());

    zzek(zzjt zzjt2) {
        super(zzjt2);
        String string = "google_app_measurement.db";
        this.zzagr = new zzen(this, this.getContext(), string);
    }

    @Override
    protected final boolean zzgn() {
        return false;
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzch();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzch();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzch();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzgi().zziv().zze("Database error", (Object)string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @VisibleForTesting
    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzab();
        try {
            return this.zzagr.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziy().zzg("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzet zzf(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Boolean bl = null;
            if (!cursor.isNull(6)) {
                bl = cursor.getLong(6) == 1L;
            }
            zzet zzet2 = new zzet(string, string2, l, l2, l3, l4, l5, l6, bl);
            if (cursor.moveToNext()) {
                this.zzgi().zziv().zzg("Got multiple records for event aggregates, expected one. appId", zzfi.zzbp((String)string));
            }
            zzet zzet3 = zzet2;
            return zzet3;
        }
    }

    @WorkerThread
    public final void zza(zzet zzet2) {
        Preconditions.checkNotNull((Object)zzet2);
        this.zzab();
        this.zzch();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzet2.zzth);
        contentValues.put("name", zzet2.name);
        contentValues.put("lifetime_count", Long.valueOf(zzet2.zzahh));
        contentValues.put("current_bundle_count", Long.valueOf(zzet2.zzahi));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzet2.zzahj));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzet2.zzahk));
        contentValues.put("last_sampled_complex_event_id", zzet2.zzahl);
        contentValues.put("last_sampling_rate", zzet2.zzahm);
        Long l = null;
        if (zzet2.zzahn != null && zzet2.zzahn.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzgi().zziv().zzg("Failed to insert/update event aggregates (got -1). appId", zzfi.zzbp((String)zzet2.zzth));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zze("Error storing event aggregates. appId", zzfi.zzbp((String)zzet2.zzth), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzg(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzgi().zzjc().zzg("Deleted user attribute rows", (Object)n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zzd("Error deleting user attribute. appId", zzfi.zzbp((String)string), (Object)this.zzgf().zzbo(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzkc zzkc2) {
        Preconditions.checkNotNull((Object)zzkc2);
        this.zzab();
        this.zzch();
        if (this.zzh(zzkc2.zzth, zzkc2.name) == null && (zzkd.zzcg((String)zzkc2.name) ? this.zza("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzkc2.zzth}) >= 25L : this.zza("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzkc2.zzth, zzkc2.origin}) >= 25L)) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzkc2.zzth);
        contentValues.put("origin", zzkc2.origin);
        contentValues.put("name", zzkc2.name);
        contentValues.put("set_timestamp", Long.valueOf(zzkc2.zzast));
        zzek.zza(contentValues, "value", zzkc2.value);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzgi().zziv().zzg("Failed to insert/update user property (got -1). appId", zzfi.zzbp((String)zzkc2.zzth));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zze("Error storing user property. appId", zzfi.zzbp((String)zzkc2.zzth), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzkc zzh(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzkc zzkc2 = new zzkc(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzgi().zziv().zzg("Got multiple records for user property, expected one. appId", zzfi.zzbp((String)string));
            }
            zzkc zzkc3 = zzkc2;
            return zzkc3;
        }
    }

    @WorkerThread
    public final List<zzkc> zzbe(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        ArrayList<zzkc> arrayList = new ArrayList<zzkc>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzkc> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzgi().zziv().zzg("Read invalid user property value, ignoring it. appId", zzfi.zzbp((String)string));
                    continue;
                }
                zzkc zzkc2 = new zzkc(string, string2, (String)object, l, object2);
                arrayList.add(zzkc2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzkc> zzb(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        ArrayList<zzkc> arrayList = new ArrayList<zzkc>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, stringBuilder.toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzkc> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzgi().zziv().zzg("Read more than the max allowed user properties, ignoring excess", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzgi().zziv().zzd("(2)Read invalid user property value, ignoring it", zzfi.zzbp((String)string), (Object)string2, (Object)string3);
                    continue;
                }
                zzkc zzkc2 = new zzkc(string, string2, (String)object, l, object2);
                arrayList.add(zzkc2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzef zzef2) {
        Preconditions.checkNotNull((Object)zzef2);
        this.zzab();
        this.zzch();
        if (this.zzh(zzef2.packageName, zzef2.zzage.name) == null && this.zza("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzef2.packageName}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzef2.packageName);
        contentValues.put("origin", zzef2.origin);
        contentValues.put("name", zzef2.zzage.name);
        zzek.zza(contentValues, "value", zzef2.zzage.getValue());
        contentValues.put("active", Boolean.valueOf(zzef2.active));
        contentValues.put("trigger_event_name", zzef2.triggerEventName);
        contentValues.put("trigger_timeout", Long.valueOf(zzef2.triggerTimeout));
        this.zzgg();
        contentValues.put("timed_out_event", zzkd.zza((Parcelable)zzef2.zzagf));
        contentValues.put("creation_timestamp", Long.valueOf(zzef2.creationTimestamp));
        this.zzgg();
        contentValues.put("triggered_event", zzkd.zza((Parcelable)zzef2.zzagg));
        contentValues.put("triggered_timestamp", Long.valueOf(zzef2.zzage.zzast));
        contentValues.put("time_to_live", Long.valueOf(zzef2.timeToLive));
        this.zzgg();
        contentValues.put("expired_event", zzkd.zza((Parcelable)zzef2.zzagh));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzgi().zziv().zzg("Failed to insert/update conditional user property (got -1)", zzfi.zzbp((String)zzef2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zze("Error storing conditional user property", zzfi.zzbp((String)zzef2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzef zzi(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzex zzex2 = (zzex)this.zzjf().zza(cursor.getBlob(5), zzex.CREATOR);
            long l2 = cursor.getLong(6);
            zzex zzex3 = (zzex)this.zzjf().zza(cursor.getBlob(7), zzex.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzex zzex4 = (zzex)this.zzjf().zza(cursor.getBlob(10), zzex.CREATOR);
            zzka zzka2 = new zzka(string2, l3, object, string3);
            zzef zzef2 = new zzef(string, string3, zzka2, l2, bl, string4, zzex2, l, zzex3, l4, zzex4);
            if (cursor.moveToNext()) {
                this.zzgi().zziv().zze("Got multiple records for conditional property, expected one", zzfi.zzbp((String)string), (Object)this.zzgf().zzbo(string2));
            }
            zzef zzef3 = zzef2;
            return zzef3;
        }
    }

    @WorkerThread
    public final int zzj(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zzd("Error deleting conditional property", zzfi.zzbp((String)string), (Object)this.zzgf().zzbo(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzef> zzc(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzb(stringBuilder.toString(), stringArray);
    }

    public final List<zzef> zzb(String string, String[] stringArray) {
        this.zzab();
        this.zzch();
        ArrayList<zzef> arrayList = new ArrayList<zzef>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzef> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzgi().zziv().zzg("Read more than the max allowed conditional properties, ignoring extra", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzex zzex2 = (zzex)this.zzjf().zza(cursor.getBlob(7), zzex.CREATOR);
                long l2 = cursor.getLong(8);
                zzex zzex3 = (zzex)this.zzjf().zza(cursor.getBlob(9), zzex.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzex zzex4 = (zzex)this.zzjf().zza(cursor.getBlob(12), zzex.CREATOR);
                zzka zzka2 = new zzka(string3, l3, object2, string2);
                zzef zzef2 = new zzef((String)object, string2, zzka2, l2, bl, string4, zzex2, l, zzex3, l4, zzex4);
                arrayList.add(zzef2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzea zzbf(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled", "ssaid_reporting_enabled"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzea zzea2 = new zzea(this.zzalo.zzlm(), string);
            zzea2.zzam(cursor.getString(0));
            zzea2.zzan(cursor.getString(1));
            zzea2.zzao(cursor.getString(2));
            zzea2.zzw(cursor.getLong(3));
            zzea2.zzr(cursor.getLong(4));
            zzea2.zzs(cursor.getLong(5));
            zzea2.setAppVersion(cursor.getString(6));
            zzea2.zzaq(cursor.getString(7));
            zzea2.zzu(cursor.getLong(8));
            zzea2.zzv(cursor.getLong(9));
            zzea2.setMeasurementEnabled(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzea2.zzz(cursor.getLong(11));
            zzea2.zzaa(cursor.getLong(12));
            zzea2.zzab(cursor.getLong(13));
            zzea2.zzac(cursor.getLong(14));
            zzea2.zzx(cursor.getLong(15));
            zzea2.zzy(cursor.getLong(16));
            zzea2.zzt(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzea2.zzap(cursor.getString(18));
            zzea2.zzae(cursor.getLong(19));
            zzea2.zzad(cursor.getLong(20));
            zzea2.zzar(cursor.getString(21));
            zzea2.zzaf(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzea2.zzd(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzea2.zze(cursor.isNull(24) || cursor.getInt(24) != 0);
            zzea2.zzgp();
            if (cursor.moveToNext()) {
                this.zzgi().zziv().zzg("Got multiple records for app, expected one. appId", zzfi.zzbp((String)string));
            }
            zzea zzea3 = zzea2;
            return zzea3;
        }
    }

    @WorkerThread
    public final void zza(zzea zzea2) {
        Preconditions.checkNotNull((Object)zzea2);
        this.zzab();
        this.zzch();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzea2.zzah());
        contentValues.put("app_instance_id", zzea2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzea2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzea2.zzgq());
        contentValues.put("last_bundle_index", Long.valueOf(zzea2.zzgy()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzea2.zzgs()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzea2.zzgt()));
        contentValues.put("app_version", zzea2.zzag());
        contentValues.put("app_store", zzea2.zzgv());
        contentValues.put("gmp_version", Long.valueOf(zzea2.zzgw()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzea2.zzgx()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzea2.isMeasurementEnabled()));
        contentValues.put("day", Long.valueOf(zzea2.zzhc()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzea2.zzhd()));
        contentValues.put("daily_events_count", Long.valueOf(zzea2.zzhe()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzea2.zzhf()));
        contentValues.put("config_fetched_time", Long.valueOf(zzea2.zzgz()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzea2.zzha()));
        contentValues.put("app_version_int", Long.valueOf(zzea2.zzgu()));
        contentValues.put("firebase_instance_id", zzea2.zzgr());
        contentValues.put("daily_error_events_count", Long.valueOf(zzea2.zzhh()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzea2.zzhg()));
        contentValues.put("health_monitor_sample", zzea2.zzhi());
        contentValues.put("android_id", Long.valueOf(zzea2.zzhk()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzea2.zzhl()));
        contentValues.put("ssaid_reporting_enabled", Boolean.valueOf(zzea2.zzhm()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzea2.zzah()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzgi().zziv().zzg("Failed to insert/update app (got -1). appId", zzfi.zzbp((String)zzea2.zzah()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zze("Error storing app. appId", zzfi.zzbp((String)zzea2.zzah()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzbg(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzgk().zzb(string2, zzez.zzait);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zze("Error deleting over the limit events. appId", zzfi.zzbp((String)string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzel zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        String[] stringArray = new String[]{string};
        zzel zzel2 = new zzel();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzgi().zziy().zzg("Not updating daily counts, app is not known. appId", zzfi.zzbp((String)string));
                zzel zzel3 = zzel2;
                return zzel3;
            }
            if (cursor.getLong(0) == l) {
                zzel2.zzagu = cursor.getLong(1);
                zzel2.zzagt = cursor.getLong(2);
                zzel2.zzagv = cursor.getLong(3);
                zzel2.zzagw = cursor.getLong(4);
                zzel2.zzagx = cursor.getLong(5);
            }
            if (bl) {
                ++zzel2.zzagu;
            }
            if (bl2) {
                ++zzel2.zzagt;
            }
            if (bl3) {
                ++zzel2.zzagv;
            }
            if (bl4) {
                ++zzel2.zzagw;
            }
            if (bl5) {
                ++zzel2.zzagx;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzel2.zzagt));
            contentValues.put("daily_events_count", Long.valueOf(zzel2.zzagu));
            contentValues.put("daily_conversions_count", Long.valueOf(zzel2.zzagv));
            contentValues.put("daily_error_events_count", Long.valueOf(zzel2.zzagw));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzel2.zzagx));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzel zzel4 = zzel2;
            return zzel4;
        }
    }

    @WorkerThread
    public final byte[] zzbh(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzgi().zziv().zzg("Got multiple records for app config, expected one. appId", zzfi.zzbp((String)string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzku zzku2, boolean bl) {
        byte[] byArray;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)((Object)zzku2));
        Preconditions.checkNotEmpty((String)zzku2.zzth);
        Preconditions.checkNotNull((Object)zzku2.zzavm);
        this.zzhx();
        long l = this.zzbt().currentTimeMillis();
        if (zzku2.zzavm < l - zzeh.zzhq() || zzku2.zzavm > l + zzeh.zzhq()) {
            this.zzgi().zziy().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzfi.zzbp((String)zzku2.zzth), (Object)l, (Object)zzku2.zzavm);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzku2.zzwb()];
            zzacb zzacb2 = zzacb.zzb((byte[])byArray2, (int)0, (int)byArray3.length);
            zzku2.zza(zzacb2);
            zzacb2.zzvt();
            byArray = this.zzjf().zzb(byArray2);
        }
        catch (IOException iOException) {
            this.zzgi().zziv().zze("Data loss. Failed to serialize bundle. appId", zzfi.zzbp((String)zzku2.zzth), (Object)iOException);
            return false;
        }
        this.zzgi().zzjc().zzg("Saving bundle, size", (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzku2.zzth);
        contentValues.put("bundle_end_timestamp", zzku2.zzavm);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        if (zzku2.zzawj != null) {
            contentValues.put("retry_count", zzku2.zzawj);
        }
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzgi().zziv().zzg("Failed to insert bundle (got -1). appId", zzfi.zzbp((String)zzku2.zzth));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zze("Error storing bundle. appId", zzfi.zzbp((String)zzku2.zzth), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzhv() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzhw() {
        return this.zza("select count(1) > 0 from queue where has_realtime = 1", (String[])null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzku, Long>> zzb(String string, int n, int n2) {
        this.zzab();
        this.zzch();
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((n2 > 0 ? 1 : 0) != 0);
        Preconditions.checkNotEmpty((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data", "retry_count"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzku, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzku, Long>> arrayList = new ArrayList<Pair<zzku, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzjf().zza((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzgi().zziv().zze("Failed to unzip queued bundle. appId", zzfi.zzbp((String)string), (Object)iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = zzaca.zza((byte[])byArray, (int)0, (int)byArray2.length);
                zzku zzku2 = new zzku();
                try {
                    zzku2.zzb((zzaca)object);
                }
                catch (IOException iOException) {
                    this.zzgi().zziv().zze("Failed to merge queued bundle. appId", zzfi.zzbp((String)string), (Object)iOException);
                    continue;
                }
                if (!cursor.isNull(2)) {
                    zzku2.zzawj = cursor.getInt(2);
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzku, Long>)Pair.create((Object)((Object)zzku2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzku, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzhx() {
        this.zzab();
        this.zzch();
        if (!this.zzid()) {
            return;
        }
        long l = this.zzgj().zzalw.get();
        long l2 = this.zzbt().elapsedRealtime();
        if (Math.abs(l2 - l) > (Long)zzez.zzajc.get()) {
            this.zzgj().zzalw.set(l2);
            zzek zzek2 = this;
            zzek2.zzab();
            zzek2.zzch();
            if (zzek2.zzid()) {
                SQLiteDatabase sQLiteDatabase = zzek2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzek2.zzbt().currentTimeMillis()), String.valueOf(zzeh.zzhq())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzek2.zzgi().zzjc().zzg("Deleted stale rows. rowsDeleted", (Object)n);
                }
            }
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzc(List<Long> list) {
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull(list);
        Preconditions.checkNotZero((int)list.size());
        if (!this.zzid()) {
            return;
        }
        String string = TextUtils.join((CharSequence)",", list);
        String string2 = new StringBuilder(2 + String.valueOf(string).length()).append("(").append(string).append(")").toString();
        if (this.zza(new StringBuilder(80 + String.valueOf(string2).length()).append("SELECT COUNT(1) FROM queue WHERE rowid IN ").append(string2).append(" AND retry_count =  2147483647 LIMIT 1").toString(), (String[])null) > 0L) {
            this.zzgi().zziy().log("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            this.getWritableDatabase().execSQL(new StringBuilder(127 + String.valueOf(string2).length()).append("UPDATE queue SET retry_count = IFNULL(retry_count, 0) + 1 WHERE rowid IN ").append(string2).append(" AND (retry_count IS NULL OR retry_count < 2147483647)").toString());
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zzg("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    final void zzb(String string, zzkg[] zzkgArray) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzkgArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzek zzek2 = this;
            zzek2.zzch();
            zzek2.zzab();
            Preconditions.checkNotEmpty((String)string2);
            Object object = zzek2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzkgArray;
            int n2 = zzkgArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzkh zzkh2;
                int n3;
                int n4;
                zzkg zzkg2 = object2[n];
                object = zzkg2;
                string2 = string;
                zzek2 = this;
                zzek2.zzch();
                zzek2.zzab();
                Preconditions.checkNotEmpty((String)string2);
                Preconditions.checkNotNull((Object)object);
                Preconditions.checkNotNull((Object)object.zzatg);
                Preconditions.checkNotNull((Object)object.zzatf);
                if (object.zzate == null) {
                    zzek2.zzgi().zziy().zzg("Audience with no ID. appId", zzfi.zzbp((String)string2));
                    continue;
                }
                int n5 = object.zzate;
                zzacd[] zzacdArray = object.zzatg;
                int n6 = object.zzatg.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzacdArray[n4].zzatk != null) continue;
                    zzek2.zzgi().zziy().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzfi.zzbp((String)string2), (Object)object.zzate);
                    continue block3;
                }
                zzacdArray = object.zzatf;
                n6 = object.zzatf.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzacdArray[n4].zzatk != null) continue;
                    zzek2.zzgi().zziy().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzfi.zzbp((String)string2), (Object)object.zzate);
                    continue block3;
                }
                boolean bl = true;
                zzacd[] zzacdArray2 = object.zzatg;
                n4 = object.zzatg.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzkh2 = zzacdArray2[n3];
                    if (zzek2.zza(string2, n5, zzkh2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    zzacdArray2 = object.zzatf;
                    n4 = object.zzatf.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzkh2 = zzacdArray2[n3];
                        if (zzek2.zza(string2, n5, (zzkk)((Object)zzkh2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzek zzek3 = zzek2;
                zzek3.zzch();
                zzek3.zzab();
                Preconditions.checkNotEmpty((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzek3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzkg[] zzkgArray2 = zzkgArray;
            n = zzkgArray.length;
            for (int i = 0; i < n; ++i) {
                zzkg zzkg3 = zzkgArray2[i];
                object2.add(zzkg3.zzate);
            }
            this.zza(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzkh zzkh2) {
        byte[] byArray;
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzkh2));
        if (TextUtils.isEmpty((CharSequence)zzkh2.zzatl)) {
            this.zzgi().zziy().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzfi.zzbp((String)string), (Object)n, (Object)String.valueOf(zzkh2.zzatk));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzkh2.zzwb()];
            zzacb zzacb2 = zzacb.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkh2.zza(zzacb2);
            zzacb2.zzvt();
        }
        catch (IOException iOException) {
            this.zzgi().zziv().zze("Configuration loss. Failed to serialize event filter. appId", zzfi.zzbp((String)string), (Object)iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzkh2.zzatk);
        contentValues.put("event_name", zzkh2.zzatl);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzgi().zziv().zzg("Failed to insert event filter (got -1). appId", zzfi.zzbp((String)string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zze("Error storing event filter. appId", zzfi.zzbp((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzkk zzkk2) {
        byte[] byArray;
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzkk2));
        if (TextUtils.isEmpty((CharSequence)zzkk2.zzauc)) {
            this.zzgi().zziy().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzfi.zzbp((String)string), (Object)n, (Object)String.valueOf(zzkk2.zzatk));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzkk2.zzwb()];
            zzacb zzacb2 = zzacb.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkk2.zza(zzacb2);
            zzacb2.zzvt();
        }
        catch (IOException iOException) {
            this.zzgi().zziv().zze("Configuration loss. Failed to serialize property filter. appId", zzfi.zzbp((String)string), (Object)iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzkk2.zzatk);
        contentValues.put("property_name", zzkk2.zzauc);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzgi().zziv().zzg("Failed to insert property filter (got -1). appId", zzfi.zzbp((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zze("Error storing property filter. appId", zzfi.zzbp((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzkh>> zzk(String string, String string2) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzkh>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzaca zzaca2 = zzaca.zza((byte[])byArray, (int)0, (int)byArray.length);
                zzkh zzkh2 = new zzkh();
                try {
                    zzkh2.zzb(zzaca2);
                }
                catch (IOException iOException) {
                    this.zzgi().zziv().zze("Failed to merge filter. appId", zzfi.zzbp((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzkh> arrayList = (ArrayList<zzkh>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzkh>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzkh2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzkk>> zzl(String string, String string2) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzkk>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzaca zzaca2 = zzaca.zza((byte[])byArray, (int)0, (int)byArray.length);
                zzkk zzkk2 = new zzkk();
                try {
                    zzkk2.zzb(zzaca2);
                }
                catch (IOException iOException) {
                    this.zzgi().zziv().zze("Failed to merge filter", zzfi.zzbp((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzkk> arrayList = (ArrayList<zzkk>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzkk>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzkk2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zza(String string, List<Integer> list) {
        Object object;
        long l;
        Preconditions.checkNotEmpty((String)string);
        this.zzch();
        this.zzab();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zza("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zze("Database error querying filters. appId", zzfi.zzbp((String)string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzgk().zzb(string2, zzez.zzajj);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzkv> zzbi(String string) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzaca zzaca2 = zzaca.zza((byte[])byArray, (int)0, (int)byArray.length);
                zzkv zzkv2 = new zzkv();
                try {
                    zzkv2.zzb(zzaca2);
                }
                catch (IOException iOException) {
                    this.zzgi().zziv().zzd("Failed to merge filter results. appId, audienceId, error", zzfi.zzbp((String)string), (Object)n, (Object)iOException);
                    continue;
                }
                arrayMap.put(n, zzkv2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @VisibleForTesting
    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzgi().zziv().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzgi().zziv().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzgi().zziv().zzg("Loaded invalid unknown value type, ignoring it", (Object)n3);
        return null;
    }

    @WorkerThread
    public final long zzhy() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    @VisibleForTesting
    protected final long zzm(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzgi().zziv().zze("Failed to insert column (got -1). appId", zzfi.zzbp((String)string), (Object)string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzgi().zziv().zze("Failed to update column (got 0). appId", zzfi.zzbp((String)string), (Object)string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zzd("Error inserting column. appId", zzfi.zzbp((String)string), (Object)string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzhz() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzku zzku2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)((Object)zzku2));
        Preconditions.checkNotEmpty((String)zzku2.zzth);
        try {
            object = byArray = new byte[zzku2.zzwb()];
            zzacb zzacb2 = zzacb.zzb((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzku2.zza(zzacb2);
            zzacb2.zzvt();
        }
        catch (IOException iOException) {
            this.zzgi().zziv().zze("Data loss. Failed to serialize event metadata. appId", zzfi.zzbp((String)zzku2.zzth), (Object)iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = (Object)this.zzjf();
        Preconditions.checkNotNull((Object)byArray2);
        object.zzgg().zzab();
        MessageDigest messageDigest = zzkd.getMessageDigest();
        if (messageDigest == null) {
            object.zzgi().zziv().log("Failed to get MD5");
            l = 0L;
        } else {
            l = zzkd.zzc((byte[])messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzku2.zzth);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zze("Error storing raw event metadata. appId", zzfi.zzbp((String)zzku2.zzth), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzia() {
        return this.zza("select count(1) > 0 from raw_events", (String[])null) != 0L;
    }

    public final boolean zzib() {
        return this.zza("select count(1) > 0 from raw_events where realtime = 1", (String[])null) != 0L;
    }

    public final long zzbj(String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzag(long l) {
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzgi().zzjc().log("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzic() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final Pair<zzkr, Long> zza(String string, Long l) {
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzgi().zzjc().log("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            byte[] byArray2 = byArray;
            zzaca zzaca2 = zzaca.zza((byte[])byArray, (int)0, (int)byArray2.length);
            zzkr zzkr2 = new zzkr();
            try {
                zzkr2.zzb(zzaca2);
            }
            catch (IOException iOException) {
                this.zzgi().zziv().zzd("Failed to merge main event. appId, eventId", zzfi.zzbp((String)string), (Object)l, (Object)iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)((Object)zzkr2), (Object)l2);
            return pair;
        }
        return null;
    }

    public final boolean zza(String string, Long l, long l2, zzkr zzkr2) {
        byte[] byArray;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)((Object)zzkr2));
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)l);
        try {
            byte[] byArray2 = byArray = new byte[zzkr2.zzwb()];
            zzacb zzacb2 = zzacb.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkr2.zza(zzacb2);
            zzacb2.zzvt();
        }
        catch (IOException iOException) {
            this.zzgi().zziv().zzd("Data loss. Failed to serialize event params/data. appId, eventId", zzfi.zzbp((String)string), (Object)l, (Object)iOException);
            return false;
        }
        this.zzgi().zzjc().zze("Saving complex main event, appId, data size", (Object)this.zzgf().zzbm(string), (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzgi().zziv().zzg("Failed to insert complex main event (got -1). appId", zzfi.zzbp((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zze("Error storing complex main event. appId", zzfi.zzbp((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzes zzes2, long l, boolean bl) {
        Object object;
        zzks zzks2;
        String string2;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)zzes2);
        Preconditions.checkNotEmpty((String)zzes2.zzth);
        zzkr zzkr2 = new zzkr();
        new zzkr().zzavc = zzes2.zzahf;
        zzkr2.zzava = new zzks[zzes2.zzahg.size()];
        int n = 0;
        for (String string2 : zzes2.zzahg) {
            zzks2 = new zzks();
            zzkr2.zzava[n++] = zzks2;
            zzks2.name = string2;
            Object object2 = zzes2.zzahg.get(string2);
            this.zzjf().zza(zzks2, object2);
        }
        try {
            byte[] byArray = new byte[zzkr2.zzwb()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzks2 = zzacb.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkr2.zza((zzacb)zzks2);
            zzks2.zzvt();
        }
        catch (IOException iOException) {
            this.zzgi().zziv().zze("Data loss. Failed to serialize event params/data. appId", zzfi.zzbp((String)zzes2.zzth), (Object)iOException);
            return false;
        }
        this.zzgi().zzjc().zze("Saving event, name, data size", (Object)this.zzgf().zzbm(zzes2.name), (Object)((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzes2.zzth);
        string2.put("name", zzes2.name);
        string2.put("timestamp", Long.valueOf(zzes2.timestamp));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzgi().zziv().zzg("Failed to insert raw event (got -1). appId", zzfi.zzbp((String)zzes2.zzth));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgi().zziv().zze("Error storing raw event. appId", zzfi.zzbp((String)zzes2.zzth), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzid() {
        return this.getContext().getDatabasePath("google_app_measurement.db").exists();
    }

    static /* synthetic */ zzjo zza(zzek zzek2) {
        return zzek2.zzags;
    }

    static /* synthetic */ String[] zzie() {
        return zzagl;
    }

    static /* synthetic */ String[] zzif() {
        return zzagm;
    }

    static /* synthetic */ String[] zzig() {
        return zzagn;
    }

    static /* synthetic */ String[] zzih() {
        return zzagp;
    }

    static /* synthetic */ String[] zzii() {
        return zzago;
    }

    static /* synthetic */ String[] zzij() {
        return zzagq;
    }
}

