/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzgp;
import com.google.android.gms.internal.measurement.zzjf;
import com.google.android.gms.internal.measurement.zzjg;
import com.google.android.gms.internal.measurement.zzjh;
import com.google.android.gms.internal.measurement.zzji;
import com.google.android.gms.internal.measurement.zzjt;

public final class zzje<T extends Context> {
    private final T zzabl;

    public zzje(T t) {
        Preconditions.checkNotNull(t);
        this.zzabl = t;
    }

    @MainThread
    public final void onCreate() {
        zzgn zzgn2 = zzgn.zza(this.zzabl, null, null);
        zzfi zzfi2 = zzgn2.zzgi();
        zzee zzee2 = zzgn2.zzgl();
        zzfi2.zzjc().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public final void onDestroy() {
        zzgn zzgn2 = zzgn.zza(this.zzabl, null, null);
        zzfi zzfi2 = zzgn2.zzgi();
        zzee zzee2 = zzgn2.zzgl();
        zzfi2.zzjc().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public final int onStartCommand(Intent intent, int n, int n2) {
        zzgn zzgn2 = zzgn.zza(this.zzabl, null, null);
        zzfi zzfi2 = zzgn2.zzgi();
        if (intent == null) {
            zzfi2.zziy().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzee zzee2 = zzgn2.zzgl();
        zzfi2.zzjc().zze("Local AppMeasurementService called. startId, action", (Object)n2, (Object)string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzb(new zzjf(this, n2, zzfi2, intent));
        }
        return 2;
    }

    private final void zzb(Runnable runnable) {
        zzjt zzjt2 = zzjt.zzg(this.zzabl);
        zzjt2.zzgh().zzc((Runnable)new zzjh(this, zzjt2, runnable));
    }

    @MainThread
    public final IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzgi().zziv().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzgp(zzjt.zzg(this.zzabl));
        }
        this.zzgi().zziy().zzg("onBind received unknown action", (Object)string);
        return null;
    }

    @MainThread
    public final boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzgi().zziv().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzgi().zzjc().zzg("onUnbind called for intent. action", (Object)string);
        return true;
    }

    @MainThread
    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzgn zzgn2 = zzgn.zza(this.zzabl, null, null);
        zzfi zzfi2 = zzgn2.zzgi();
        String string = jobParameters.getExtras().getString("action");
        zzee zzee2 = zzgn2.zzgl();
        zzfi2.zzjc().zzg("Local AppMeasurementJobService called. action", (Object)string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzb(new zzjg(this, zzfi2, jobParameters));
        }
        return true;
    }

    @MainThread
    public final void onRebind(Intent intent) {
        if (intent == null) {
            this.zzgi().zziv().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzgi().zzjc().zzg("onRebind called. action", (Object)string);
    }

    private final zzfi zzgi() {
        return zzgn.zza(this.zzabl, null, null).zzgi();
    }

    final /* synthetic */ void zza(zzfi zzfi2, JobParameters jobParameters) {
        zzfi2.zzjc().log("AppMeasurementJobService processed last upload request.");
        ((zzji)this.zzabl).zza(jobParameters, false);
    }

    final /* synthetic */ void zza(int n, zzfi zzfi2, Intent intent) {
        if (((zzji)this.zzabl).callServiceStopSelfResult(n)) {
            zzfi2.zzjc().zzg("Local AppMeasurementService processed last upload request. StartId", (Object)n);
            this.zzgi().zzjc().log("Completed wakeful intent.");
            ((zzji)this.zzabl).zzb(intent);
        }
    }
}

