/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzgd;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.internal.measurement.zzjq;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzjt;
import com.google.android.gms.internal.measurement.zzkd;

public final class zzjp
extends zzjs {
    private final AlarmManager zzyh = (AlarmManager)this.getContext().getSystemService("alarm");
    private final zzep zzarp;
    private Integer zzyi;

    protected zzjp(zzjt zzjt2) {
        super(zzjt2);
        this.zzarp = new zzjq(this, (zzhk)zzjt2.zzlm(), zzjt2);
    }

    @Override
    protected final boolean zzgn() {
        this.zzyh.cancel(this.zzek());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzkx();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzkx() {
        JobScheduler jobScheduler = (JobScheduler)this.getContext().getSystemService("jobscheduler");
        this.zzgi().zzjc().zzg("Cancelling job. JobID", (Object)this.getJobId());
        jobScheduler.cancel(this.getJobId());
    }

    public final void zzh(long l) {
        this.zzch();
        zzee zzee2 = this.zzgl();
        if (!zzgd.zza((Context)this.getContext())) {
            this.zzgi().zzjb().log("Receiver not registered/enabled");
        }
        zzee2 = this.zzgl();
        if (!zzkd.zza((Context)this.getContext(), (boolean)false)) {
            this.zzgi().zzjb().log("Service not registered/enabled");
        }
        this.cancel();
        long l2 = this.zzbt().elapsedRealtime() + l;
        if (l < Math.max(0L, (Long)zzez.zzajb.get()) && !this.zzarp.zzef()) {
            this.zzgi().zzjc().log("Scheduling upload with DelayedRunnable");
            this.zzarp.zzh(l);
        }
        zzee2 = this.zzgl();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzgi().zzjc().log("Scheduling upload with JobScheduler");
            long l3 = l;
            zzjp zzjp2 = this;
            ComponentName componentName = new ComponentName(zzjp2.getContext(), "com.google.android.gms.measurement.AppMeasurementJobService");
            JobScheduler jobScheduler = (JobScheduler)zzjp2.getContext().getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(zzjp2.getJobId(), componentName);
            builder.setMinimumLatency(l3);
            builder.setOverrideDeadline(l3 << 1);
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            builder.setExtras(persistableBundle);
            JobInfo jobInfo = builder.build();
            zzjp2.zzgi().zzjc().zzg("Scheduling job. JobID", (Object)zzjp2.getJobId());
            jobScheduler.schedule(jobInfo);
            return;
        }
        this.zzgi().zzjc().log("Scheduling upload with AlarmManager");
        this.zzyh.setInexactRepeating(2, l2, Math.max((Long)zzez.zzaiw.get(), l), this.zzek());
    }

    private final int getJobId() {
        if (this.zzyi == null) {
            String string = String.valueOf(this.getContext().getPackageName());
            this.zzyi = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzyi;
    }

    public final void cancel() {
        this.zzch();
        this.zzyh.cancel(this.zzek());
        this.zzarp.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzkx();
        }
    }

    private final PendingIntent zzek() {
        Intent intent = new Intent().setClassName(this.getContext(), "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent.setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)this.getContext(), (int)0, (Intent)intent, (int)0);
    }
}

