/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.debug.internal;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;

public class StorageHelper {
    @VisibleForTesting
    static final String PREFS_TEMPLATE = "com.google.firebase.appcheck.debug.store.%s";
    @VisibleForTesting
    static final String DEBUG_SECRET_KEY = "com.google.firebase.appcheck.debug.DEBUG_SECRET";
    private final SharedPreferences sharedPreferences;

    public StorageHelper(@NonNull Context context, @NonNull String persistenceKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotEmpty((String)persistenceKey);
        String prefsName = String.format(PREFS_TEMPLATE, persistenceKey);
        this.sharedPreferences = context.getSharedPreferences(prefsName, 0);
    }

    public void saveDebugSecret(@NonNull String debugSecret) {
        this.sharedPreferences.edit().putString(DEBUG_SECRET_KEY, debugSecret).apply();
    }

    @Nullable
    public String retrieveDebugSecret() {
        return this.sharedPreferences.getString(DEBUG_SECRET_KEY, null);
    }
}

