/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Strings;
import org.json.JSONException;
import org.json.JSONObject;

public class AppCheckTokenResponse {
    @VisibleForTesting
    static final String ATTESTATION_TOKEN_KEY = "attestationToken";
    @VisibleForTesting
    static final String TIME_TO_LIVE_KEY = "ttl";
    private String attestationToken;
    private String timeToLive;

    @NonNull
    public static AppCheckTokenResponse fromJsonString(@NonNull String jsonString) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonString);
        String attestationToken = Strings.emptyToNull((String)jsonObject.optString(ATTESTATION_TOKEN_KEY));
        String timeToLive = Strings.emptyToNull((String)jsonObject.optString(TIME_TO_LIVE_KEY));
        return new AppCheckTokenResponse(attestationToken, timeToLive);
    }

    private AppCheckTokenResponse(@NonNull String attestationToken, @NonNull String timeToLive) {
        Preconditions.checkNotNull((Object)attestationToken);
        Preconditions.checkNotNull((Object)timeToLive);
        this.attestationToken = attestationToken;
        this.timeToLive = timeToLive;
    }

    @NonNull
    public String getAttestationToken() {
        return this.attestationToken;
    }

    @NonNull
    public String getTimeToLive() {
        return this.timeToLive;
    }
}

