/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal;

import android.app.Application;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.api.internal.BackgroundDetector;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.appcheck.AppCheckToken;
import com.google.firebase.appcheck.internal.DefaultAppCheckToken;
import com.google.firebase.appcheck.internal.DefaultFirebaseAppCheck;
import com.google.firebase.appcheck.internal.DefaultTokenRefresher;
import com.google.firebase.appcheck.internal.util.Clock;

public final class TokenRefreshManager {
    private static final long REFRESH_BUFFER_ABSOLUTE_MILLIS = 60000L;
    private static final double REFRESH_BUFFER_FRACTION = 0.5;
    private static final long FIVE_MINUTES_IN_MILLIS = 300000L;
    private static final long UNSET_REFRESH_TIME = -1L;
    private final DefaultTokenRefresher tokenRefresher;
    private final Clock clock;
    private volatile boolean isBackgrounded;
    private volatile int currentListenerCount;
    private volatile long nextRefreshTimeMillis;
    private volatile boolean isAutoRefreshEnabled;

    TokenRefreshManager(@NonNull Context context, @NonNull DefaultFirebaseAppCheck firebaseAppCheck) {
        this((Context)Preconditions.checkNotNull((Object)context), new DefaultTokenRefresher((DefaultFirebaseAppCheck)Preconditions.checkNotNull((Object)firebaseAppCheck)), new Clock.DefaultClock());
    }

    @VisibleForTesting
    TokenRefreshManager(Context context, final DefaultTokenRefresher tokenRefresher, final Clock clock) {
        this.tokenRefresher = tokenRefresher;
        this.clock = clock;
        this.nextRefreshTimeMillis = -1L;
        BackgroundDetector.initialize((Application)((Application)context.getApplicationContext()));
        BackgroundDetector.getInstance().addListener(new BackgroundDetector.BackgroundStateChangeListener(){

            public void onBackgroundStateChanged(boolean background) {
                TokenRefreshManager.this.isBackgrounded = background;
                if (background) {
                    tokenRefresher.cancel();
                } else if (TokenRefreshManager.this.shouldScheduleRefresh()) {
                    tokenRefresher.scheduleRefresh(TokenRefreshManager.this.nextRefreshTimeMillis - clock.currentTimeMillis());
                }
            }
        });
    }

    public void maybeScheduleTokenRefresh(@NonNull AppCheckToken token) {
        DefaultAppCheckToken defaultToken = token instanceof DefaultAppCheckToken ? (DefaultAppCheckToken)token : DefaultAppCheckToken.constructFromRawToken(token.getToken());
        this.nextRefreshTimeMillis = defaultToken.getReceivedAtTimestamp() + (long)(0.5 * (double)defaultToken.getExpiresInMillis()) + 300000L;
        if (this.nextRefreshTimeMillis > defaultToken.getExpireTimeMillis()) {
            this.nextRefreshTimeMillis = defaultToken.getExpireTimeMillis() - 60000L;
        }
        if (this.shouldScheduleRefresh()) {
            this.tokenRefresher.scheduleRefresh(this.nextRefreshTimeMillis - this.clock.currentTimeMillis());
        }
    }

    public void onListenerCountChanged(int newListenerCount) {
        if (this.currentListenerCount == 0 && newListenerCount > 0) {
            this.currentListenerCount = newListenerCount;
            if (this.shouldScheduleRefresh()) {
                this.tokenRefresher.scheduleRefresh(this.nextRefreshTimeMillis - this.clock.currentTimeMillis());
            }
        } else if (this.currentListenerCount > 0 && newListenerCount == 0) {
            this.tokenRefresher.cancel();
        }
        this.currentListenerCount = newListenerCount;
    }

    public void setIsAutoRefreshEnabled(boolean isAutoRefreshEnabled) {
        this.isAutoRefreshEnabled = isAutoRefreshEnabled;
    }

    private boolean shouldScheduleRefresh() {
        return this.isAutoRefreshEnabled && !this.isBackgrounded && this.currentListenerCount > 0 && this.nextRefreshTimeMillis != -1L;
    }
}

