/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal.util;

import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.appcheck.internal.util.Logger;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TokenParser {
    @NonNull
    public static Map<String, Object> parseTokenClaims(@NonNull String token) {
        Preconditions.checkNotEmpty((String)token);
        String[] tokenSubSections = token.split("\\.", -1);
        if (tokenSubSections.length < 2) {
            Logger.getLogger().e("Invalid token (too few subsections):\n" + token);
            return Collections.emptyMap();
        }
        String encodedToken = tokenSubSections[1];
        try {
            String decodedToken = new String(Base64.decode((String)encodedToken, (int)11), "UTF-8");
            Map<String, Object> map = TokenParser.parseJsonIntoMap(decodedToken);
            return map == null ? Collections.emptyMap() : map;
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger().e("Unable to decode token (charset unknown):\n" + e);
            return Collections.emptyMap();
        }
    }

    @Nullable
    private static Map<String, Object> parseJsonIntoMap(String rawJson) {
        if (TextUtils.isEmpty((CharSequence)rawJson)) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(rawJson);
            if (jsonObject != JSONObject.NULL) {
                return TokenParser.toMap(jsonObject);
            }
            return null;
        }
        catch (Exception e) {
            Logger.getLogger().d("Failed to parse JSONObject into Map:\n" + e);
            return Collections.emptyMap();
        }
    }

    private static Map<String, Object> toMap(JSONObject json) throws JSONException {
        ArrayMap map = new ArrayMap();
        Iterator keyItr = json.keys();
        while (keyItr.hasNext()) {
            String key = (String)keyItr.next();
            List<Object> value = json.get(key);
            if (value instanceof JSONArray) {
                value = TokenParser.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = TokenParser.toMap((JSONObject)value);
            } else if (((Object)value).equals(JSONObject.NULL)) {
                value = null;
            }
            map.put(key, value);
        }
        return map;
    }

    private static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = TokenParser.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = TokenParser.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }
}

