/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.appcheck.AppCheckToken;
import com.google.firebase.appcheck.internal.DefaultAppCheckToken;
import com.google.firebase.appcheck.internal.util.Logger;

public class StorageHelper {
    private static final Logger logger = new Logger(StorageHelper.class.getSimpleName());
    @VisibleForTesting
    static final String PREFS_TEMPLATE = "com.google.firebase.appcheck.store.%s";
    @VisibleForTesting
    static final String TOKEN_KEY = "com.google.firebase.appcheck.APP_CHECK_TOKEN";
    @VisibleForTesting
    static final String TOKEN_TYPE_KEY = "com.google.firebase.appcheck.TOKEN_TYPE";
    private SharedPreferences sharedPreferences;

    public StorageHelper(@NonNull Context context, @NonNull String persistenceKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotEmpty((String)persistenceKey);
        String prefsName = String.format(PREFS_TEMPLATE, persistenceKey);
        this.sharedPreferences = context.getSharedPreferences(prefsName, 0);
    }

    public void saveAppCheckToken(@NonNull AppCheckToken appCheckToken) {
        if (appCheckToken instanceof DefaultAppCheckToken) {
            this.sharedPreferences.edit().putString(TOKEN_KEY, ((DefaultAppCheckToken)appCheckToken).serializeTokenToString()).putString(TOKEN_TYPE_KEY, TokenType.DEFAULT_APP_CHECK_TOKEN.name()).apply();
        } else {
            this.sharedPreferences.edit().putString(TOKEN_KEY, appCheckToken.getToken()).putString(TOKEN_TYPE_KEY, TokenType.UNKNOWN_APP_CHECK_TOKEN.name()).apply();
        }
    }

    @Nullable
    public AppCheckToken retrieveAppCheckToken() {
        String tokenType = this.sharedPreferences.getString(TOKEN_TYPE_KEY, null);
        String serializedToken = this.sharedPreferences.getString(TOKEN_KEY, null);
        if (tokenType == null || serializedToken == null) {
            return null;
        }
        try {
            switch (TokenType.valueOf(tokenType)) {
                case DEFAULT_APP_CHECK_TOKEN: {
                    return DefaultAppCheckToken.deserializeTokenFromJsonString(serializedToken);
                }
                case UNKNOWN_APP_CHECK_TOKEN: {
                    return DefaultAppCheckToken.constructFromRawToken(serializedToken);
                }
            }
        }
        catch (IllegalArgumentException e) {
            logger.e("Failed to parse TokenType of stored token  with type [" + tokenType + "] with exception: " + e.getMessage());
            this.clearSharedPrefs();
            return null;
        }
        logger.e("Reached unreachable section in #retrieveAppCheckToken()");
        return null;
    }

    void clearSharedPrefs() {
        this.sharedPreferences.edit().remove(TOKEN_KEY).remove(TOKEN_TYPE_KEY).apply();
    }

    @VisibleForTesting
    static enum TokenType {
        DEFAULT_APP_CHECK_TOKEN,
        UNKNOWN_APP_CHECK_TOKEN;

    }
}

