/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import com.google.firebase.components.OptionalProvider$$Lambda$1;
import com.google.firebase.components.OptionalProvider$$Lambda$4;
import com.google.firebase.components.OptionalProvider$$Lambda$5;
import com.google.firebase.inject.Deferred;
import com.google.firebase.inject.Provider;

class OptionalProvider<T>
implements Provider<T>,
Deferred<T> {
    private static final Deferred.DeferredHandler<Object> NOOP_HANDLER = OptionalProvider$$Lambda$4.lambdaFactory$();
    private static final Provider<Object> EMPTY_PROVIDER = OptionalProvider$$Lambda$5.lambdaFactory$();
    @GuardedBy(value="this")
    private Deferred.DeferredHandler<T> handler;
    private volatile Provider<T> delegate;

    private OptionalProvider(Deferred.DeferredHandler<T> handler, Provider<T> provider) {
        this.handler = handler;
        this.delegate = provider;
    }

    static <T> OptionalProvider<T> empty() {
        return new OptionalProvider<Object>(NOOP_HANDLER, EMPTY_PROVIDER);
    }

    static <T> OptionalProvider<T> of(Provider<T> provider) {
        return new OptionalProvider<T>(null, provider);
    }

    @Override
    public T get() {
        return this.delegate.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(Provider<T> provider) {
        Deferred.DeferredHandler<T> localHandler;
        if (this.delegate != EMPTY_PROVIDER) {
            throw new IllegalStateException("provide() can be called only once.");
        }
        OptionalProvider optionalProvider = this;
        synchronized (optionalProvider) {
            localHandler = this.handler;
            this.handler = null;
            this.delegate = provider;
        }
        localHandler.handle(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void whenAvailable(@NonNull Deferred.DeferredHandler<T> handler) {
        Provider<T> provider = this.delegate;
        if (provider != EMPTY_PROVIDER) {
            handler.handle(provider);
            return;
        }
        Provider<T> toRun = null;
        OptionalProvider optionalProvider = this;
        synchronized (optionalProvider) {
            provider = this.delegate;
            if (provider != EMPTY_PROVIDER) {
                toRun = provider;
            } else {
                Deferred.DeferredHandler<T> existingHandler = this.handler;
                this.handler = OptionalProvider$$Lambda$1.lambdaFactory$(existingHandler, handler);
            }
        }
        if (toRun != null) {
            handler.handle(provider);
        }
    }

    static /* synthetic */ void lambda$whenAvailable$2(Deferred.DeferredHandler existingHandler, Deferred.DeferredHandler handler, Provider p) {
        existingHandler.handle(p);
        handler.handle(p);
    }

    static /* synthetic */ Object lambda$static$1() {
        return null;
    }

    static /* synthetic */ void lambda$static$0(Provider p) {
    }
}

