/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.internal.ConfigFetchHandler;
import com.google.firebase.remoteconfig.internal.FirebaseRemoteConfigInfoImpl;
import java.util.Date;

public class ConfigMetadataClient {
    @VisibleForTesting
    public static final long LAST_FETCH_TIME_IN_MILLIS_NO_FETCH_YET = -1L;
    static final Date LAST_FETCH_TIME_NO_FETCH_YET = new Date(-1L);
    @VisibleForTesting
    static final int NO_FAILED_FETCHES = 0;
    private static final long NO_BACKOFF_TIME_IN_MILLIS = -1L;
    @VisibleForTesting
    static final Date NO_BACKOFF_TIME = new Date(-1L);
    private static final String FETCH_TIMEOUT_IN_SECONDS_KEY = "fetch_timeout_in_seconds";
    private static final String MINIMUM_FETCH_INTERVAL_IN_SECONDS_KEY = "minimum_fetch_interval_in_seconds";
    private static final String LAST_FETCH_STATUS_KEY = "last_fetch_status";
    private static final String LAST_SUCCESSFUL_FETCH_TIME_IN_MILLIS_KEY = "last_fetch_time_in_millis";
    private static final String LAST_FETCH_ETAG_KEY = "last_fetch_etag";
    private static final String BACKOFF_END_TIME_IN_MILLIS_KEY = "backoff_end_time_in_millis";
    private static final String NUM_FAILED_FETCHES_KEY = "num_failed_fetches";
    private final SharedPreferences frcMetadata;
    private final Object frcInfoLock;
    private final Object backoffMetadataLock;

    public ConfigMetadataClient(SharedPreferences frcMetadata) {
        this.frcMetadata = frcMetadata;
        this.frcInfoLock = new Object();
        this.backoffMetadataLock = new Object();
    }

    public long getFetchTimeoutInSeconds() {
        return this.frcMetadata.getLong(FETCH_TIMEOUT_IN_SECONDS_KEY, 60L);
    }

    public long getMinimumFetchIntervalInSeconds() {
        return this.frcMetadata.getLong(MINIMUM_FETCH_INTERVAL_IN_SECONDS_KEY, ConfigFetchHandler.DEFAULT_MINIMUM_FETCH_INTERVAL_IN_SECONDS);
    }

    int getLastFetchStatus() {
        return this.frcMetadata.getInt(LAST_FETCH_STATUS_KEY, 0);
    }

    Date getLastSuccessfulFetchTime() {
        return new Date(this.frcMetadata.getLong(LAST_SUCCESSFUL_FETCH_TIME_IN_MILLIS_KEY, -1L));
    }

    @Nullable
    String getLastFetchETag() {
        return this.frcMetadata.getString(LAST_FETCH_ETAG_KEY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigInfo getInfo() {
        Object object = this.frcInfoLock;
        synchronized (object) {
            long lastSuccessfulFetchTimeInMillis = this.frcMetadata.getLong(LAST_SUCCESSFUL_FETCH_TIME_IN_MILLIS_KEY, -1L);
            int lastFetchStatus = this.frcMetadata.getInt(LAST_FETCH_STATUS_KEY, 0);
            FirebaseRemoteConfigSettings settings = new FirebaseRemoteConfigSettings.Builder().setFetchTimeoutInSeconds(this.frcMetadata.getLong(FETCH_TIMEOUT_IN_SECONDS_KEY, 60L)).setMinimumFetchIntervalInSeconds(this.frcMetadata.getLong(MINIMUM_FETCH_INTERVAL_IN_SECONDS_KEY, ConfigFetchHandler.DEFAULT_MINIMUM_FETCH_INTERVAL_IN_SECONDS)).build();
            return FirebaseRemoteConfigInfoImpl.newBuilder().withLastFetchStatus(lastFetchStatus).withLastSuccessfulFetchTimeInMillis(lastSuccessfulFetchTimeInMillis).withConfigSettings(settings).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void clear() {
        Object object = this.frcInfoLock;
        synchronized (object) {
            this.frcMetadata.edit().clear().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void setConfigSettings(FirebaseRemoteConfigSettings settings) {
        Object object = this.frcInfoLock;
        synchronized (object) {
            this.frcMetadata.edit().putLong(FETCH_TIMEOUT_IN_SECONDS_KEY, settings.getFetchTimeoutInSeconds()).putLong(MINIMUM_FETCH_INTERVAL_IN_SECONDS_KEY, settings.getMinimumFetchIntervalInSeconds()).commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigSettingsWithoutWaitingOnDiskWrite(FirebaseRemoteConfigSettings settings) {
        Object object = this.frcInfoLock;
        synchronized (object) {
            this.frcMetadata.edit().putLong(FETCH_TIMEOUT_IN_SECONDS_KEY, settings.getFetchTimeoutInSeconds()).putLong(MINIMUM_FETCH_INTERVAL_IN_SECONDS_KEY, settings.getMinimumFetchIntervalInSeconds()).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLastFetchAsSuccessfulAt(Date fetchTime) {
        Object object = this.frcInfoLock;
        synchronized (object) {
            this.frcMetadata.edit().putInt(LAST_FETCH_STATUS_KEY, -1).putLong(LAST_SUCCESSFUL_FETCH_TIME_IN_MILLIS_KEY, fetchTime.getTime()).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLastFetchAsFailed() {
        Object object = this.frcInfoLock;
        synchronized (object) {
            this.frcMetadata.edit().putInt(LAST_FETCH_STATUS_KEY, 1).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLastFetchAsThrottled() {
        Object object = this.frcInfoLock;
        synchronized (object) {
            this.frcMetadata.edit().putInt(LAST_FETCH_STATUS_KEY, 2).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLastFetchETag(String eTag) {
        Object object = this.frcInfoLock;
        synchronized (object) {
            this.frcMetadata.edit().putString(LAST_FETCH_ETAG_KEY, eTag).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackoffMetadata getBackoffMetadata() {
        Object object = this.backoffMetadataLock;
        synchronized (object) {
            return new BackoffMetadata(this.frcMetadata.getInt(NUM_FAILED_FETCHES_KEY, 0), new Date(this.frcMetadata.getLong(BACKOFF_END_TIME_IN_MILLIS_KEY, -1L)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBackoffMetadata(int numFailedFetches, Date backoffEndTime) {
        Object object = this.backoffMetadataLock;
        synchronized (object) {
            this.frcMetadata.edit().putInt(NUM_FAILED_FETCHES_KEY, numFailedFetches).putLong(BACKOFF_END_TIME_IN_MILLIS_KEY, backoffEndTime.getTime()).apply();
        }
    }

    void resetBackoff() {
        this.setBackoffMetadata(0, NO_BACKOFF_TIME);
    }

    static class BackoffMetadata {
        private int numFailedFetches;
        private Date backoffEndTime;

        BackoffMetadata(int numFailedFetches, Date backoffEndTime) {
            this.numFailedFetches = numFailedFetches;
            this.backoffEndTime = backoffEndTime;
        }

        int getNumFailedFetches() {
            return this.numFailedFetches;
        }

        Date getBackoffEndTime() {
            return this.backoffEndTime;
        }
    }
}

