/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.NamedRange;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.FileContext;
import java.util.List;
import java.util.Map;

public class CompilationUnitContext {
    public final FileContext fileContext;
    public final Header header;
    public final Map<Long, String> specificationMap;
    public final Map<Long, String> abstractOriginMap;
    public final List<NamedRange> namedRanges = Lists.newLinkedList();
    private final Long debugLineOffset;
    private final Long lowPc;

    public CompilationUnitContext(FileContext fileContext, Header header, Map<Long, String> specificationMap, Map<Long, String> abstractOriginMap) {
        this(fileContext, header, specificationMap, abstractOriginMap, null, null);
    }

    public CompilationUnitContext(FileContext fileContext, Header header, Map<Long, String> specificationMap, Map<Long, String> abstractOriginMap, EntryData entryData) {
        this(fileContext, header, specificationMap, abstractOriginMap, entryData.lowPc, entryData.stmtList);
    }

    private CompilationUnitContext(FileContext fileContext, Header header, Map<Long, String> specificationMap, Map<Long, String> abstractOriginMap, Long lowPc, Long debugLineOffset) {
        this.fileContext = fileContext;
        this.header = header;
        this.specificationMap = specificationMap;
        this.abstractOriginMap = abstractOriginMap;
        this.lowPc = lowPc;
        this.debugLineOffset = debugLineOffset;
    }

    public Optional<Long> getDebugLineOffset() {
        return Optional.of((Object)this.debugLineOffset);
    }

    public long getLowPc() {
        return (Long)Optional.of((Object)this.lowPc).or((Object)0L);
    }

    public static class EntryData {
        final Long lowPc;
        final Long stmtList;

        public EntryData(Long lowPc, Long stmtList) {
            this.lowPc = lowPc;
            this.stmtList = stmtList;
        }
    }

    public static class Header {
        public final long offset;
        public final long length;
        public final int version;
        public final long abbrevOffset;
        public final int addressSize;
        public final int referenceSize;

        public Header(long offset, long length, int version, long abbrevOffset, int addressSize, int referenceSize) {
            this.offset = offset;
            this.length = length;
            this.version = version;
            this.abbrevOffset = abbrevOffset;
            this.addressSize = addressSize;
            this.referenceSize = referenceSize;
        }
    }
}

