/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.log;

import com.google.firebase.crashlytics.buildtools.log.CrashlyticsLogger;
import java.io.PrintStream;

public class ConsoleLogger
implements CrashlyticsLogger {
    private CrashlyticsLogger.Level level;

    public ConsoleLogger() {
        this(CrashlyticsLogger.Level.INFO);
    }

    public ConsoleLogger(CrashlyticsLogger.Level level) {
        this.level = level;
    }

    @Override
    public void setLevel(CrashlyticsLogger.Level level) {
        this.level = level;
    }

    @Override
    public synchronized void logV(String msg) {
        this.log(CrashlyticsLogger.Level.VERBOSE, msg, System.out);
    }

    @Override
    public synchronized void logD(String msg) {
        this.log(CrashlyticsLogger.Level.DEBUG, msg, System.out);
    }

    @Override
    public synchronized void logI(String msg) {
        this.log(CrashlyticsLogger.Level.INFO, msg, System.out);
    }

    @Override
    public synchronized void logW(String msg, Throwable t) {
        this.log(CrashlyticsLogger.Level.WARNING, msg, System.err);
        this.logThrowable(t);
    }

    @Override
    public synchronized void logE(String msg, Throwable t) {
        this.log(CrashlyticsLogger.Level.ERROR, msg, System.err);
        this.logThrowable(t);
    }

    private void log(CrashlyticsLogger.Level l, String msg, PrintStream stream) {
        if (this.level.logsFor(l)) {
            stream.println("[CRASHLYTICS LOG " + l.toString() + "] " + msg);
        }
    }

    private void logThrowable(Throwable t) {
        if (t != null && this.level.logsFor(CrashlyticsLogger.Level.DEBUG)) {
            t.printStackTrace(System.out);
        }
    }
}

