/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;

final class AutoValue_CrashlyticsReport
extends CrashlyticsReport {
    private final String sdkVersion;
    private final String gmpAppId;
    private final int platform;
    private final String installationUuid;
    private final String buildVersion;
    private final String displayVersion;
    private final CrashlyticsReport.Session session;
    private final CrashlyticsReport.FilesPayload ndkPayload;

    private AutoValue_CrashlyticsReport(String sdkVersion, String gmpAppId, int platform, String installationUuid, String buildVersion, String displayVersion, @Nullable CrashlyticsReport.Session session, @Nullable CrashlyticsReport.FilesPayload ndkPayload) {
        this.sdkVersion = sdkVersion;
        this.gmpAppId = gmpAppId;
        this.platform = platform;
        this.installationUuid = installationUuid;
        this.buildVersion = buildVersion;
        this.displayVersion = displayVersion;
        this.session = session;
        this.ndkPayload = ndkPayload;
    }

    @Override
    @NonNull
    public String getSdkVersion() {
        return this.sdkVersion;
    }

    @Override
    @NonNull
    public String getGmpAppId() {
        return this.gmpAppId;
    }

    @Override
    public int getPlatform() {
        return this.platform;
    }

    @Override
    @NonNull
    public String getInstallationUuid() {
        return this.installationUuid;
    }

    @Override
    @NonNull
    public String getBuildVersion() {
        return this.buildVersion;
    }

    @Override
    @NonNull
    public String getDisplayVersion() {
        return this.displayVersion;
    }

    @Override
    @Nullable
    public CrashlyticsReport.Session getSession() {
        return this.session;
    }

    @Override
    @Nullable
    public CrashlyticsReport.FilesPayload getNdkPayload() {
        return this.ndkPayload;
    }

    public String toString() {
        return "CrashlyticsReport{sdkVersion=" + this.sdkVersion + ", gmpAppId=" + this.gmpAppId + ", platform=" + this.platform + ", installationUuid=" + this.installationUuid + ", buildVersion=" + this.buildVersion + ", displayVersion=" + this.displayVersion + ", session=" + this.session + ", ndkPayload=" + this.ndkPayload + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CrashlyticsReport) {
            CrashlyticsReport that = (CrashlyticsReport)o;
            return this.sdkVersion.equals(that.getSdkVersion()) && this.gmpAppId.equals(that.getGmpAppId()) && this.platform == that.getPlatform() && this.installationUuid.equals(that.getInstallationUuid()) && this.buildVersion.equals(that.getBuildVersion()) && this.displayVersion.equals(that.getDisplayVersion()) && (this.session == null ? that.getSession() == null : this.session.equals(that.getSession())) && (this.ndkPayload == null ? that.getNdkPayload() == null : this.ndkPayload.equals(that.getNdkPayload()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.sdkVersion.hashCode();
        h$ *= 1000003;
        h$ ^= this.gmpAppId.hashCode();
        h$ *= 1000003;
        h$ ^= this.platform;
        h$ *= 1000003;
        h$ ^= this.installationUuid.hashCode();
        h$ *= 1000003;
        h$ ^= this.buildVersion.hashCode();
        h$ *= 1000003;
        h$ ^= this.displayVersion.hashCode();
        h$ *= 1000003;
        h$ ^= this.session == null ? 0 : this.session.hashCode();
        h$ *= 1000003;
        return h$ ^= this.ndkPayload == null ? 0 : this.ndkPayload.hashCode();
    }

    @Override
    protected CrashlyticsReport.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends CrashlyticsReport.Builder {
        private String sdkVersion;
        private String gmpAppId;
        private Integer platform;
        private String installationUuid;
        private String buildVersion;
        private String displayVersion;
        private CrashlyticsReport.Session session;
        private CrashlyticsReport.FilesPayload ndkPayload;

        Builder() {
        }

        private Builder(CrashlyticsReport source) {
            this.sdkVersion = source.getSdkVersion();
            this.gmpAppId = source.getGmpAppId();
            this.platform = source.getPlatform();
            this.installationUuid = source.getInstallationUuid();
            this.buildVersion = source.getBuildVersion();
            this.displayVersion = source.getDisplayVersion();
            this.session = source.getSession();
            this.ndkPayload = source.getNdkPayload();
        }

        @Override
        public CrashlyticsReport.Builder setSdkVersion(String sdkVersion) {
            if (sdkVersion == null) {
                throw new NullPointerException("Null sdkVersion");
            }
            this.sdkVersion = sdkVersion;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setGmpAppId(String gmpAppId) {
            if (gmpAppId == null) {
                throw new NullPointerException("Null gmpAppId");
            }
            this.gmpAppId = gmpAppId;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setPlatform(int platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setInstallationUuid(String installationUuid) {
            if (installationUuid == null) {
                throw new NullPointerException("Null installationUuid");
            }
            this.installationUuid = installationUuid;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setBuildVersion(String buildVersion) {
            if (buildVersion == null) {
                throw new NullPointerException("Null buildVersion");
            }
            this.buildVersion = buildVersion;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setDisplayVersion(String displayVersion) {
            if (displayVersion == null) {
                throw new NullPointerException("Null displayVersion");
            }
            this.displayVersion = displayVersion;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setSession(CrashlyticsReport.Session session) {
            this.session = session;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setNdkPayload(CrashlyticsReport.FilesPayload ndkPayload) {
            this.ndkPayload = ndkPayload;
            return this;
        }

        @Override
        public CrashlyticsReport build() {
            String missing = "";
            if (this.sdkVersion == null) {
                missing = missing + " sdkVersion";
            }
            if (this.gmpAppId == null) {
                missing = missing + " gmpAppId";
            }
            if (this.platform == null) {
                missing = missing + " platform";
            }
            if (this.installationUuid == null) {
                missing = missing + " installationUuid";
            }
            if (this.buildVersion == null) {
                missing = missing + " buildVersion";
            }
            if (this.displayVersion == null) {
                missing = missing + " displayVersion";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CrashlyticsReport(this.sdkVersion, this.gmpAppId, this.platform, this.installationUuid, this.buildVersion, this.displayVersion, this.session, this.ndkPayload);
        }
    }
}

