/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import androidx.annotation.NonNull;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.InternalHelpers;
import com.google.firebase.database.MutableData;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import com.google.firebase.database.ValueEventListener;
import com.google.firebase.database.annotations.NotNull;
import com.google.firebase.database.connection.HostInfo;
import com.google.firebase.database.connection.ListenHashProvider;
import com.google.firebase.database.connection.PersistentConnection;
import com.google.firebase.database.connection.RequestResultCallback;
import com.google.firebase.database.core.AuthTokenProvider;
import com.google.firebase.database.core.CompoundWrite;
import com.google.firebase.database.core.Constants;
import com.google.firebase.database.core.Context;
import com.google.firebase.database.core.EventRegistration;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.RepoInfo;
import com.google.firebase.database.core.ServerValues;
import com.google.firebase.database.core.SnapshotHolder;
import com.google.firebase.database.core.SparseSnapshotTree;
import com.google.firebase.database.core.SyncTree;
import com.google.firebase.database.core.Tag;
import com.google.firebase.database.core.UserWriteRecord;
import com.google.firebase.database.core.ValueEventRegistration;
import com.google.firebase.database.core.persistence.NoopPersistenceManager;
import com.google.firebase.database.core.persistence.PersistenceManager;
import com.google.firebase.database.core.utilities.DefaultClock;
import com.google.firebase.database.core.utilities.DefaultRunLoop;
import com.google.firebase.database.core.utilities.OffsetClock;
import com.google.firebase.database.core.utilities.Tree;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.core.view.Event;
import com.google.firebase.database.core.view.EventRaiser;
import com.google.firebase.database.core.view.QuerySpec;
import com.google.firebase.database.logging.LogWrapper;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.EmptyNode;
import com.google.firebase.database.snapshot.IndexedNode;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.NodeUtilities;
import com.google.firebase.database.snapshot.RangeMerge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Repo
implements PersistentConnection.Delegate {
    private static final String INTERRUPT_REASON = "repo_interrupt";
    private final RepoInfo repoInfo;
    private final OffsetClock serverClock = new OffsetClock(new DefaultClock(), 0L);
    private PersistentConnection connection;
    private SnapshotHolder infoData;
    private SparseSnapshotTree onDisconnect;
    private Tree<List<TransactionData>> transactionQueueTree;
    private boolean hijackHash = false;
    private final EventRaiser eventRaiser;
    private final Context ctx;
    private final LogWrapper operationLogger;
    private final LogWrapper transactionLogger;
    private final LogWrapper dataLogger;
    public long dataUpdateCount = 0L;
    private long nextWriteId = 1L;
    private SyncTree infoSyncTree;
    private SyncTree serverSyncTree;
    private FirebaseDatabase database;
    private boolean loggedTransactionPersistenceWarning = false;
    private static final int TRANSACTION_MAX_RETRIES = 25;
    private static final String TRANSACTION_TOO_MANY_RETRIES = "maxretries";
    private static final String TRANSACTION_OVERRIDE_BY_SET = "overriddenBySet";
    private long transactionOrder = 0L;

    Repo(RepoInfo repoInfo, Context ctx, FirebaseDatabase database) {
        this.repoInfo = repoInfo;
        this.ctx = ctx;
        this.database = database;
        this.operationLogger = this.ctx.getLogger("RepoOperation");
        this.transactionLogger = this.ctx.getLogger("Transaction");
        this.dataLogger = this.ctx.getLogger("DataOperation");
        this.eventRaiser = new EventRaiser(this.ctx);
        this.scheduleNow(new Runnable(){

            @Override
            public void run() {
                Repo.this.deferredInitialization();
            }
        });
    }

    private void deferredInitialization() {
        HostInfo hostInfo = new HostInfo(this.repoInfo.host, this.repoInfo.namespace, this.repoInfo.secure);
        this.connection = this.ctx.newPersistentConnection(hostInfo, this);
        this.ctx.getAuthTokenProvider().addTokenChangeListener(((DefaultRunLoop)this.ctx.getRunLoop()).getExecutorService(), new AuthTokenProvider.TokenChangeListener(){

            @Override
            public void onTokenChange() {
                Repo.this.operationLogger.debug("Auth token changed, triggering auth token refresh", new Object[0]);
                Repo.this.connection.refreshAuthToken();
            }

            @Override
            public void onTokenChange(String token) {
                Repo.this.operationLogger.debug("Auth token changed, triggering auth token refresh", new Object[0]);
                Repo.this.connection.refreshAuthToken(token);
            }
        });
        this.connection.initialize();
        PersistenceManager persistenceManager = this.ctx.getPersistenceManager(this.repoInfo.host);
        this.infoData = new SnapshotHolder();
        this.onDisconnect = new SparseSnapshotTree();
        this.transactionQueueTree = new Tree();
        this.infoSyncTree = new SyncTree(this.ctx, new NoopPersistenceManager(), new SyncTree.ListenProvider(){

            @Override
            public void startListening(final QuerySpec query, Tag tag, ListenHashProvider hash, final SyncTree.CompletionListener onComplete) {
                Repo.this.scheduleNow(new Runnable(){

                    @Override
                    public void run() {
                        Node node = Repo.this.infoData.getNode(query.getPath());
                        if (!node.isEmpty()) {
                            List<? extends Event> infoEvents = Repo.this.infoSyncTree.applyServerOverwrite(query.getPath(), node);
                            Repo.this.postEvents(infoEvents);
                            onComplete.onListenComplete(null);
                        }
                    }
                });
            }

            @Override
            public void stopListening(QuerySpec query, Tag tag) {
            }
        });
        this.serverSyncTree = new SyncTree(this.ctx, persistenceManager, new SyncTree.ListenProvider(){

            @Override
            public void startListening(QuerySpec query, Tag tag, ListenHashProvider hash, final SyncTree.CompletionListener onListenComplete) {
                Repo.this.connection.listen(query.getPath().asList(), query.getParams().getWireProtocolParams(), hash, tag != null ? Long.valueOf(tag.getTagNumber()) : null, new RequestResultCallback(){

                    @Override
                    public void onRequestResult(String optErrorCode, String optErrorMessage) {
                        DatabaseError error = Repo.fromErrorCode(optErrorCode, optErrorMessage);
                        List<? extends Event> events = onListenComplete.onListenComplete(error);
                        Repo.this.postEvents(events);
                    }
                });
            }

            @Override
            public void stopListening(QuerySpec query, Tag tag) {
                Repo.this.connection.unlisten(query.getPath().asList(), query.getParams().getWireProtocolParams());
            }
        });
        this.restoreWrites(persistenceManager);
        this.updateInfo(Constants.DOT_INFO_AUTHENTICATED, false);
        this.updateInfo(Constants.DOT_INFO_CONNECTED, false);
    }

    private void restoreWrites(PersistenceManager persistenceManager) {
        List<UserWriteRecord> writes = persistenceManager.loadUserWrites();
        Map<String, Object> serverValues = ServerValues.generateServerValues(this.serverClock);
        long lastWriteId = Long.MIN_VALUE;
        for (final UserWriteRecord write : writes) {
            Iterable<NamedNode> resolved;
            RequestResultCallback onComplete = new RequestResultCallback(){

                @Override
                public void onRequestResult(String optErrorCode, String optErrorMessage) {
                    DatabaseError error = Repo.fromErrorCode(optErrorCode, optErrorMessage);
                    Repo.this.warnIfWriteFailed("Persisted write", write.getPath(), error);
                    Repo.this.ackWriteAndRerunTransactions(write.getWriteId(), write.getPath(), error);
                }
            };
            if (lastWriteId >= write.getWriteId()) {
                throw new IllegalStateException("Write ids were not in order.");
            }
            lastWriteId = write.getWriteId();
            this.nextWriteId = write.getWriteId() + 1L;
            if (write.isOverwrite()) {
                if (this.operationLogger.logsDebug()) {
                    this.operationLogger.debug("Restoring overwrite with id " + write.getWriteId(), new Object[0]);
                }
                this.connection.put(write.getPath().asList(), write.getOverwrite().getValue(true), onComplete);
                resolved = ServerValues.resolveDeferredValueSnapshot(write.getOverwrite(), this.serverSyncTree, write.getPath(), serverValues);
                this.serverSyncTree.applyUserOverwrite(write.getPath(), write.getOverwrite(), (Node)resolved, write.getWriteId(), true, false);
                continue;
            }
            if (this.operationLogger.logsDebug()) {
                this.operationLogger.debug("Restoring merge with id " + write.getWriteId(), new Object[0]);
            }
            this.connection.merge(write.getPath().asList(), write.getMerge().getValue(true), onComplete);
            resolved = ServerValues.resolveDeferredValueMerge(write.getMerge(), this.serverSyncTree, write.getPath(), serverValues);
            this.serverSyncTree.applyUserMerge(write.getPath(), write.getMerge(), (CompoundWrite)resolved, write.getWriteId(), false);
        }
    }

    public FirebaseDatabase getDatabase() {
        return this.database;
    }

    public String toString() {
        return this.repoInfo.toString();
    }

    public RepoInfo getRepoInfo() {
        return this.repoInfo;
    }

    public void scheduleNow(Runnable r) {
        this.ctx.requireStarted();
        this.ctx.getRunLoop().scheduleNow(r);
    }

    public void postEvent(Runnable r) {
        this.ctx.requireStarted();
        this.ctx.getEventTarget().postEvent(r);
    }

    private void postEvents(List<? extends Event> events) {
        if (!events.isEmpty()) {
            this.eventRaiser.raiseEvents(events);
        }
    }

    public long getServerTime() {
        return this.serverClock.millis();
    }

    boolean hasListeners() {
        return !this.infoSyncTree.isEmpty() || !this.serverSyncTree.isEmpty();
    }

    @Override
    public void onDataUpdate(List<String> pathSegments, Object message, boolean isMerge, Long optTag) {
        Path path = new Path(pathSegments);
        if (this.operationLogger.logsDebug()) {
            this.operationLogger.debug("onDataUpdate: " + path, new Object[0]);
        }
        if (this.dataLogger.logsDebug()) {
            this.operationLogger.debug("onDataUpdate: " + path + " " + message, new Object[0]);
        }
        ++this.dataUpdateCount;
        try {
            List<? extends Event> events;
            if (optTag != null) {
                Tag tag = new Tag(optTag);
                if (isMerge) {
                    HashMap<Path, Node> taggedChildren = new HashMap<Path, Node>();
                    Map rawMergeData = (Map)message;
                    for (Map.Entry entry : rawMergeData.entrySet()) {
                        Node newChildNode = NodeUtilities.NodeFromJSON(entry.getValue());
                        taggedChildren.put(new Path((String)entry.getKey()), newChildNode);
                    }
                    events = this.serverSyncTree.applyTaggedQueryMerge(path, taggedChildren, tag);
                } else {
                    Node taggedSnap = NodeUtilities.NodeFromJSON(message);
                    events = this.serverSyncTree.applyTaggedQueryOverwrite(path, taggedSnap, tag);
                }
            } else if (isMerge) {
                HashMap<Path, Node> changedChildren = new HashMap<Path, Node>();
                Map rawMergeData = (Map)message;
                for (Map.Entry entry : rawMergeData.entrySet()) {
                    Node newChildNode = NodeUtilities.NodeFromJSON(entry.getValue());
                    changedChildren.put(new Path((String)entry.getKey()), newChildNode);
                }
                events = this.serverSyncTree.applyServerMerge(path, changedChildren);
            } else {
                Node snap = NodeUtilities.NodeFromJSON(message);
                events = this.serverSyncTree.applyServerOverwrite(path, snap);
            }
            if (events.size() > 0) {
                this.rerunTransactions(path);
            }
            this.postEvents(events);
        }
        catch (DatabaseException e) {
            this.operationLogger.error("FIREBASE INTERNAL ERROR", e);
        }
    }

    @Override
    public void onRangeMergeUpdate(List<String> pathSegments, List<com.google.firebase.database.connection.RangeMerge> merges, Long tagNumber) {
        Path path = new Path(pathSegments);
        if (this.operationLogger.logsDebug()) {
            this.operationLogger.debug("onRangeMergeUpdate: " + path, new Object[0]);
        }
        if (this.dataLogger.logsDebug()) {
            this.operationLogger.debug("onRangeMergeUpdate: " + path + " " + merges, new Object[0]);
        }
        ++this.dataUpdateCount;
        ArrayList<RangeMerge> parsedMerges = new ArrayList<RangeMerge>(merges.size());
        for (com.google.firebase.database.connection.RangeMerge merge : merges) {
            parsedMerges.add(new RangeMerge(merge));
        }
        List<? extends Event> events = tagNumber != null ? this.serverSyncTree.applyTaggedRangeMerges(path, parsedMerges, new Tag(tagNumber)) : this.serverSyncTree.applyServerRangeMerges(path, parsedMerges);
        if (events.size() > 0) {
            this.rerunTransactions(path);
        }
        this.postEvents(events);
    }

    void callOnComplete(final DatabaseReference.CompletionListener onComplete, final DatabaseError error, Path path) {
        if (onComplete != null) {
            ChildKey last = path.getBack();
            final DatabaseReference ref = last != null && last.isPriorityChildName() ? InternalHelpers.createReference(this, path.getParent()) : InternalHelpers.createReference(this, path);
            this.postEvent(new Runnable(){

                @Override
                public void run() {
                    onComplete.onComplete(error, ref);
                }
            });
        }
    }

    private void ackWriteAndRerunTransactions(long writeId, Path path, DatabaseError error) {
        if (error == null || error.getCode() != -25) {
            boolean success = error == null;
            List<? extends Event> clearEvents = this.serverSyncTree.ackUserWrite(writeId, !success, true, this.serverClock);
            if (clearEvents.size() > 0) {
                this.rerunTransactions(path);
            }
            this.postEvents(clearEvents);
        }
    }

    public void setValue(final Path path, Node newValueUnresolved, final DatabaseReference.CompletionListener onComplete) {
        if (this.operationLogger.logsDebug()) {
            this.operationLogger.debug("set: " + path, new Object[0]);
        }
        if (this.dataLogger.logsDebug()) {
            this.dataLogger.debug("set: " + path + " " + newValueUnresolved, new Object[0]);
        }
        Map<String, Object> serverValues = ServerValues.generateServerValues(this.serverClock);
        Node existing = this.serverSyncTree.calcCompleteEventCache(path, new ArrayList<Long>());
        Node newValue = ServerValues.resolveDeferredValueSnapshot(newValueUnresolved, existing, serverValues);
        final long writeId = this.getNextWriteId();
        List<? extends Event> events = this.serverSyncTree.applyUserOverwrite(path, newValueUnresolved, newValue, writeId, true, true);
        this.postEvents(events);
        this.connection.put(path.asList(), newValueUnresolved.getValue(true), new RequestResultCallback(){

            @Override
            public void onRequestResult(String optErrorCode, String optErrorMessage) {
                DatabaseError error = Repo.fromErrorCode(optErrorCode, optErrorMessage);
                Repo.this.warnIfWriteFailed("setValue", path, error);
                Repo.this.ackWriteAndRerunTransactions(writeId, path, error);
                Repo.this.callOnComplete(onComplete, error, path);
            }
        });
        Path affectedPath = this.abortTransactions(path, -9);
        this.rerunTransactions(affectedPath);
    }

    public Task<DataSnapshot> getValue(final Query query) {
        final TaskCompletionSource source = new TaskCompletionSource();
        this.scheduleNow(new Runnable(){

            @Override
            public void run() {
                Repo.this.serverSyncTree.setQueryActive(query.getSpec());
                Repo.this.connection.get(query.getPath().asList(), query.getSpec().getParams().getWireProtocolParams()).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Object>(){

                    public void onComplete(@NonNull Task<Object> task) {
                        if (!task.isSuccessful()) {
                            Repo.this.operationLogger.info("get for query " + query.getPath() + " falling back to cache after error: " + task.getException().getMessage());
                            Node cached = Repo.this.serverSyncTree.calcCompleteEventCache(query.getPath(), new ArrayList<Long>());
                            if (cached.isEmpty()) {
                                source.setException(task.getException());
                            } else {
                                source.setResult((Object)InternalHelpers.createDataSnapshot(query.getRef(), IndexedNode.from(cached, query.getSpec().getIndex())));
                            }
                        } else {
                            Node serverNode = NodeUtilities.NodeFromJSON(task.getResult());
                            Repo.this.postEvents(Repo.this.serverSyncTree.applyServerOverwrite(query.getPath(), serverNode));
                            source.setResult((Object)InternalHelpers.createDataSnapshot(query.getRef(), IndexedNode.from(serverNode, query.getSpec().getIndex())));
                        }
                    }
                });
            }
        });
        return source.getTask().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<DataSnapshot>(){

            public void onComplete(@NonNull Task<DataSnapshot> task) {
                Repo.this.serverSyncTree.setQueryInactive(query.getSpec());
            }
        });
    }

    public void updateChildren(final Path path, CompoundWrite updates, final DatabaseReference.CompletionListener onComplete, Map<String, Object> unParsedUpdates) {
        if (this.operationLogger.logsDebug()) {
            this.operationLogger.debug("update: " + path, new Object[0]);
        }
        if (this.dataLogger.logsDebug()) {
            this.dataLogger.debug("update: " + path + " " + unParsedUpdates, new Object[0]);
        }
        if (updates.isEmpty()) {
            if (this.operationLogger.logsDebug()) {
                this.operationLogger.debug("update called with no changes. No-op", new Object[0]);
            }
            this.callOnComplete(onComplete, null, path);
            return;
        }
        Map<String, Object> serverValues = ServerValues.generateServerValues(this.serverClock);
        CompoundWrite resolved = ServerValues.resolveDeferredValueMerge(updates, this.serverSyncTree, path, serverValues);
        final long writeId = this.getNextWriteId();
        List<? extends Event> events = this.serverSyncTree.applyUserMerge(path, updates, resolved, writeId, true);
        this.postEvents(events);
        this.connection.merge(path.asList(), unParsedUpdates, new RequestResultCallback(){

            @Override
            public void onRequestResult(String optErrorCode, String optErrorMessage) {
                DatabaseError error = Repo.fromErrorCode(optErrorCode, optErrorMessage);
                Repo.this.warnIfWriteFailed("updateChildren", path, error);
                Repo.this.ackWriteAndRerunTransactions(writeId, path, error);
                Repo.this.callOnComplete(onComplete, error, path);
            }
        });
        for (Map.Entry<Path, Node> update : updates) {
            Path pathFromRoot = path.child(update.getKey());
            Path affectedPath = this.abortTransactions(pathFromRoot, -9);
            this.rerunTransactions(affectedPath);
        }
    }

    public void purgeOutstandingWrites() {
        if (this.operationLogger.logsDebug()) {
            this.operationLogger.debug("Purging writes", new Object[0]);
        }
        List<? extends Event> events = this.serverSyncTree.removeAllWrites();
        this.postEvents(events);
        this.abortTransactions(Path.getEmptyPath(), -25);
        this.connection.purgeOutstandingWrites();
    }

    public void removeEventCallback(@NotNull EventRegistration eventRegistration) {
        List<Event> events = Constants.DOT_INFO.equals(eventRegistration.getQuerySpec().getPath().getFront()) ? this.infoSyncTree.removeEventRegistration(eventRegistration) : this.serverSyncTree.removeEventRegistration(eventRegistration);
        this.postEvents(events);
    }

    public void onDisconnectSetValue(final Path path, final Node newValue, final DatabaseReference.CompletionListener onComplete) {
        this.connection.onDisconnectPut(path.asList(), newValue.getValue(true), new RequestResultCallback(){

            @Override
            public void onRequestResult(String optErrorCode, String optErrorMessage) {
                DatabaseError error = Repo.fromErrorCode(optErrorCode, optErrorMessage);
                Repo.this.warnIfWriteFailed("onDisconnect().setValue", path, error);
                if (error == null) {
                    Repo.this.onDisconnect.remember(path, newValue);
                }
                Repo.this.callOnComplete(onComplete, error, path);
            }
        });
    }

    public void onDisconnectUpdate(final Path path, final Map<Path, Node> newChildren, final DatabaseReference.CompletionListener listener, Map<String, Object> unParsedUpdates) {
        this.connection.onDisconnectMerge(path.asList(), unParsedUpdates, new RequestResultCallback(){

            @Override
            public void onRequestResult(String optErrorCode, String optErrorMessage) {
                DatabaseError error = Repo.fromErrorCode(optErrorCode, optErrorMessage);
                Repo.this.warnIfWriteFailed("onDisconnect().updateChildren", path, error);
                if (error == null) {
                    for (Map.Entry entry : newChildren.entrySet()) {
                        Repo.this.onDisconnect.remember(path.child((Path)entry.getKey()), (Node)entry.getValue());
                    }
                }
                Repo.this.callOnComplete(listener, error, path);
            }
        });
    }

    public void onDisconnectCancel(final Path path, final DatabaseReference.CompletionListener onComplete) {
        this.connection.onDisconnectCancel(path.asList(), new RequestResultCallback(){

            @Override
            public void onRequestResult(String optErrorCode, String optErrorMessage) {
                DatabaseError error = Repo.fromErrorCode(optErrorCode, optErrorMessage);
                if (error == null) {
                    Repo.this.onDisconnect.forget(path);
                }
                Repo.this.callOnComplete(onComplete, error, path);
            }
        });
    }

    @Override
    public void onConnect() {
        this.onServerInfoUpdate(Constants.DOT_INFO_CONNECTED, true);
    }

    @Override
    public void onDisconnect() {
        this.onServerInfoUpdate(Constants.DOT_INFO_CONNECTED, false);
        this.runOnDisconnectEvents();
    }

    @Override
    public void onAuthStatus(boolean authOk) {
        this.onServerInfoUpdate(Constants.DOT_INFO_AUTHENTICATED, authOk);
    }

    public void onServerInfoUpdate(ChildKey key, Object value) {
        this.updateInfo(key, value);
    }

    @Override
    public void onServerInfoUpdate(Map<String, Object> updates) {
        for (Map.Entry<String, Object> entry : updates.entrySet()) {
            this.updateInfo(ChildKey.fromString(entry.getKey()), entry.getValue());
        }
    }

    void interrupt() {
        this.connection.interrupt(INTERRUPT_REASON);
    }

    void resume() {
        this.connection.resume(INTERRUPT_REASON);
    }

    public void addEventCallback(@NotNull EventRegistration eventRegistration) {
        ChildKey front = eventRegistration.getQuerySpec().getPath().getFront();
        List<? extends Event> events = front != null && front.equals(Constants.DOT_INFO) ? this.infoSyncTree.addEventRegistration(eventRegistration) : this.serverSyncTree.addEventRegistration(eventRegistration);
        this.postEvents(events);
    }

    public void keepSynced(QuerySpec query, boolean keep) {
        Utilities.hardAssert(query.getPath().isEmpty() || !query.getPath().getFront().equals(Constants.DOT_INFO));
        this.serverSyncTree.keepSynced(query, keep);
    }

    PersistentConnection getConnection() {
        return this.connection;
    }

    private void updateInfo(ChildKey childKey, Object value) {
        if (childKey.equals(Constants.DOT_INFO_SERVERTIME_OFFSET)) {
            this.serverClock.setOffset((Long)value);
        }
        Path path = new Path(Constants.DOT_INFO, childKey);
        try {
            Node node = NodeUtilities.NodeFromJSON(value);
            this.infoData.update(path, node);
            List<? extends Event> events = this.infoSyncTree.applyServerOverwrite(path, node);
            this.postEvents(events);
        }
        catch (DatabaseException e) {
            this.operationLogger.error("Failed to parse info update", e);
        }
    }

    private long getNextWriteId() {
        return this.nextWriteId++;
    }

    private void runOnDisconnectEvents() {
        final Map<String, Object> serverValues = ServerValues.generateServerValues(this.serverClock);
        final ArrayList events = new ArrayList();
        this.onDisconnect.forEachTree(Path.getEmptyPath(), new SparseSnapshotTree.SparseSnapshotTreeVisitor(){

            @Override
            public void visitTree(Path prefixPath, Node node) {
                Node existing = Repo.this.serverSyncTree.calcCompleteEventCache(prefixPath, new ArrayList<Long>());
                Node resolvedNode = ServerValues.resolveDeferredValueSnapshot(node, existing, (Map<String, Object>)serverValues);
                events.addAll(Repo.this.serverSyncTree.applyServerOverwrite(prefixPath, resolvedNode));
                Path affectedPath = Repo.this.abortTransactions(prefixPath, -9);
                Repo.this.rerunTransactions(affectedPath);
            }
        });
        this.onDisconnect = new SparseSnapshotTree();
        this.postEvents(events);
    }

    private void warnIfWriteFailed(String writeType, Path path, DatabaseError error) {
        if (error != null && error.getCode() != -1 && error.getCode() != -25) {
            this.operationLogger.warn(writeType + " at " + path.toString() + " failed: " + error.toString());
        }
    }

    public void startTransaction(Path path, final Transaction.Handler handler, boolean applyLocally) {
        Transaction.Result result;
        if (this.operationLogger.logsDebug()) {
            this.operationLogger.debug("transaction: " + path, new Object[0]);
        }
        if (this.dataLogger.logsDebug()) {
            this.operationLogger.debug("transaction: " + path, new Object[0]);
        }
        if (this.ctx.isPersistenceEnabled() && !this.loggedTransactionPersistenceWarning) {
            this.loggedTransactionPersistenceWarning = true;
            this.transactionLogger.info("runTransaction() usage detected while persistence is enabled. Please be aware that transactions *will not* be persisted across database restarts.  See https://www.firebase.com/docs/android/guide/offline-capabilities.html#section-handling-transactions-offline for more details.");
        }
        DatabaseReference watchRef = InternalHelpers.createReference(this, path);
        ValueEventListener listener = new ValueEventListener(){

            @Override
            public void onDataChange(DataSnapshot snapshot) {
            }

            @Override
            public void onCancelled(DatabaseError error) {
            }
        };
        this.addEventCallback(new ValueEventRegistration(this, listener, watchRef.getSpec()));
        TransactionData transaction = new TransactionData(path, handler, listener, TransactionStatus.INITIALIZING, applyLocally, this.nextTransactionOrder());
        Node currentState = this.getLatestState(path);
        transaction.currentInputSnapshot = currentState;
        MutableData mutableCurrent = InternalHelpers.createMutableData(currentState);
        DatabaseError error = null;
        try {
            result = handler.doTransaction(mutableCurrent);
            if (result == null) {
                throw new NullPointerException("Transaction returned null as result");
            }
        }
        catch (Throwable e) {
            this.operationLogger.error("Caught Throwable.", e);
            error = DatabaseError.fromException(e);
            result = Transaction.abort();
        }
        if (!result.isSuccess()) {
            transaction.currentOutputSnapshotRaw = null;
            transaction.currentOutputSnapshotResolved = null;
            final DatabaseError innerClassError = error;
            final DataSnapshot snap = InternalHelpers.createDataSnapshot(watchRef, IndexedNode.from(transaction.currentInputSnapshot));
            this.postEvent(new Runnable(){

                @Override
                public void run() {
                    handler.onComplete(innerClassError, false, snap);
                }
            });
        } else {
            transaction.status = TransactionStatus.RUN;
            Tree<List<TransactionData>> queueNode = this.transactionQueueTree.subTree(path);
            List<TransactionData> nodeQueue = queueNode.getValue();
            if (nodeQueue == null) {
                nodeQueue = new ArrayList<TransactionData>();
            }
            nodeQueue.add(transaction);
            queueNode.setValue(nodeQueue);
            Map<String, Object> serverValues = ServerValues.generateServerValues(this.serverClock);
            Node newNodeUnresolved = result.getNode();
            Node newNode = ServerValues.resolveDeferredValueSnapshot(newNodeUnresolved, transaction.currentInputSnapshot, serverValues);
            transaction.currentOutputSnapshotRaw = newNodeUnresolved;
            transaction.currentOutputSnapshotResolved = newNode;
            transaction.currentWriteId = this.getNextWriteId();
            List<? extends Event> events = this.serverSyncTree.applyUserOverwrite(path, newNodeUnresolved, newNode, transaction.currentWriteId, applyLocally, false);
            this.postEvents(events);
            this.sendAllReadyTransactions();
        }
    }

    private Node getLatestState(Path path) {
        return this.getLatestState(path, new ArrayList<Long>());
    }

    private Node getLatestState(Path path, List<Long> excudeSets) {
        Node state = this.serverSyncTree.calcCompleteEventCache(path, excudeSets);
        if (state == null) {
            state = EmptyNode.Empty();
        }
        return state;
    }

    public void setHijackHash(boolean hijackHash) {
        this.hijackHash = hijackHash;
    }

    private void sendAllReadyTransactions() {
        Tree<List<TransactionData>> node = this.transactionQueueTree;
        this.pruneCompletedTransactions(node);
        this.sendReadyTransactions(node);
    }

    private void sendReadyTransactions(Tree<List<TransactionData>> node) {
        List<TransactionData> queue = node.getValue();
        if (queue != null) {
            queue = this.buildTransactionQueue(node);
            Utilities.hardAssert(queue.size() > 0);
            Boolean allRun = true;
            for (TransactionData transaction : queue) {
                if (transaction.status == TransactionStatus.RUN) continue;
                allRun = false;
                break;
            }
            if (allRun.booleanValue()) {
                this.sendTransactionQueue(queue, node.getPath());
            }
        } else if (node.hasChildren()) {
            node.forEachChild(new Tree.TreeVisitor<List<TransactionData>>(){

                @Override
                public void visitTree(Tree<List<TransactionData>> tree) {
                    Repo.this.sendReadyTransactions(tree);
                }
            });
        }
    }

    private void sendTransactionQueue(final List<TransactionData> queue, final Path path) {
        Node latestState;
        ArrayList<Long> setsToIgnore = new ArrayList<Long>();
        for (TransactionData txn : queue) {
            setsToIgnore.add(txn.currentWriteId);
        }
        Node snapToSend = latestState = this.getLatestState(path, setsToIgnore);
        String latestHash = "badhash";
        if (!this.hijackHash) {
            latestHash = latestState.getHash();
        }
        for (TransactionData txn : queue) {
            Utilities.hardAssert(txn.status == TransactionStatus.RUN);
            txn.status = TransactionStatus.SENT;
            txn.retryCount++;
            Path relativePath = Path.getRelative(path, txn.path);
            snapToSend = snapToSend.updateChild(relativePath, txn.currentOutputSnapshotRaw);
        }
        Object dataToSend = snapToSend.getValue(true);
        final Repo repo = this;
        this.connection.compareAndPut(path.asList(), dataToSend, latestHash, new RequestResultCallback(){

            @Override
            public void onRequestResult(String optErrorCode, String optErrorMessage) {
                DatabaseError error = Repo.fromErrorCode(optErrorCode, optErrorMessage);
                Repo.this.warnIfWriteFailed("Transaction", path, error);
                ArrayList<? extends Event> events = new ArrayList<Event>();
                if (error == null) {
                    ArrayList<1> callbacks = new ArrayList<1>();
                    for (final TransactionData txn : queue) {
                        txn.status = TransactionStatus.COMPLETED;
                        events.addAll(Repo.this.serverSyncTree.ackUserWrite(txn.currentWriteId, false, false, Repo.this.serverClock));
                        Node node = txn.currentOutputSnapshotResolved;
                        final DataSnapshot snap = InternalHelpers.createDataSnapshot(InternalHelpers.createReference(repo, txn.path), IndexedNode.from(node));
                        callbacks.add(new Runnable(){

                            @Override
                            public void run() {
                                txn.handler.onComplete(null, true, snap);
                            }
                        });
                        Repo.this.removeEventCallback(new ValueEventRegistration(Repo.this, txn.outstandingListener, QuerySpec.defaultQueryAtPath(txn.path)));
                    }
                    Repo.this.pruneCompletedTransactions(Repo.this.transactionQueueTree.subTree(path));
                    Repo.this.sendAllReadyTransactions();
                    repo.postEvents(events);
                    for (int i = 0; i < callbacks.size(); ++i) {
                        Repo.this.postEvent((Runnable)callbacks.get(i));
                    }
                } else {
                    if (error.getCode() == -1) {
                        for (TransactionData transaction : queue) {
                            if (transaction.status == TransactionStatus.SENT_NEEDS_ABORT) {
                                transaction.status = TransactionStatus.NEEDS_ABORT;
                                continue;
                            }
                            transaction.status = TransactionStatus.RUN;
                        }
                    } else {
                        for (TransactionData transaction : queue) {
                            transaction.status = TransactionStatus.NEEDS_ABORT;
                            transaction.abortReason = error;
                        }
                    }
                    Repo.this.rerunTransactions(path);
                }
            }
        });
    }

    private void pruneCompletedTransactions(Tree<List<TransactionData>> node) {
        List<TransactionData> queue = node.getValue();
        if (queue != null) {
            int i = 0;
            while (i < queue.size()) {
                TransactionData transaction = queue.get(i);
                if (transaction.status == TransactionStatus.COMPLETED) {
                    queue.remove(i);
                    continue;
                }
                ++i;
            }
            if (queue.size() > 0) {
                node.setValue(queue);
            } else {
                node.setValue(null);
            }
        }
        node.forEachChild(new Tree.TreeVisitor<List<TransactionData>>(){

            @Override
            public void visitTree(Tree<List<TransactionData>> tree) {
                Repo.this.pruneCompletedTransactions(tree);
            }
        });
    }

    private long nextTransactionOrder() {
        return this.transactionOrder++;
    }

    private Path rerunTransactions(Path changedPath) {
        Tree<List<TransactionData>> rootMostTransactionNode = this.getAncestorTransactionNode(changedPath);
        Path path = rootMostTransactionNode.getPath();
        List<TransactionData> queue = this.buildTransactionQueue(rootMostTransactionNode);
        this.rerunTransactionQueue(queue, path);
        return path;
    }

    private void rerunTransactionQueue(List<TransactionData> queue, Path path) {
        if (queue.isEmpty()) {
            return;
        }
        ArrayList<21> callbacks = new ArrayList<21>();
        ArrayList<Long> setsToIgnore = new ArrayList<Long>();
        for (final TransactionData transaction : queue) {
            setsToIgnore.add(transaction.currentWriteId);
        }
        for (final TransactionData transaction : queue) {
            Path relativePath = Path.getRelative(path, transaction.path);
            boolean abortTransaction = false;
            DatabaseError abortReason = null;
            ArrayList<? extends Event> events = new ArrayList<Event>();
            Utilities.hardAssert(relativePath != null);
            if (transaction.status == TransactionStatus.NEEDS_ABORT) {
                abortTransaction = true;
                abortReason = transaction.abortReason;
                if (abortReason.getCode() != -25) {
                    events.addAll(this.serverSyncTree.ackUserWrite(transaction.currentWriteId, true, false, this.serverClock));
                }
            } else if (transaction.status == TransactionStatus.RUN) {
                if (transaction.retryCount >= 25) {
                    abortTransaction = true;
                    abortReason = DatabaseError.fromStatus(TRANSACTION_TOO_MANY_RETRIES);
                    events.addAll(this.serverSyncTree.ackUserWrite(transaction.currentWriteId, true, false, this.serverClock));
                } else {
                    Transaction.Result result;
                    Node currentNode = this.getLatestState(transaction.path, setsToIgnore);
                    transaction.currentInputSnapshot = currentNode;
                    MutableData mutableCurrent = InternalHelpers.createMutableData(currentNode);
                    DatabaseError error = null;
                    try {
                        result = transaction.handler.doTransaction(mutableCurrent);
                    }
                    catch (Throwable e) {
                        this.operationLogger.error("Caught Throwable.", e);
                        error = DatabaseError.fromException(e);
                        result = Transaction.abort();
                    }
                    if (result.isSuccess()) {
                        Long oldWriteId = transaction.currentWriteId;
                        Map<String, Object> serverValues = ServerValues.generateServerValues(this.serverClock);
                        Node newDataNode = result.getNode();
                        Node newNodeResolved = ServerValues.resolveDeferredValueSnapshot(newDataNode, currentNode, serverValues);
                        transaction.currentOutputSnapshotRaw = newDataNode;
                        transaction.currentOutputSnapshotResolved = newNodeResolved;
                        transaction.currentWriteId = this.getNextWriteId();
                        setsToIgnore.remove(oldWriteId);
                        events.addAll(this.serverSyncTree.applyUserOverwrite(transaction.path, newDataNode, newNodeResolved, transaction.currentWriteId, transaction.applyLocally, false));
                        events.addAll(this.serverSyncTree.ackUserWrite(oldWriteId, true, false, this.serverClock));
                    } else {
                        abortTransaction = true;
                        abortReason = error;
                        events.addAll(this.serverSyncTree.ackUserWrite(transaction.currentWriteId, true, false, this.serverClock));
                    }
                }
            }
            this.postEvents(events);
            if (!abortTransaction) continue;
            transaction.status = TransactionStatus.COMPLETED;
            DatabaseReference ref = InternalHelpers.createReference(this, transaction.path);
            Node lastInput = transaction.currentInputSnapshot;
            final DataSnapshot snapshot = InternalHelpers.createDataSnapshot(ref, IndexedNode.from(lastInput));
            this.scheduleNow(new Runnable(){

                @Override
                public void run() {
                    Repo.this.removeEventCallback(new ValueEventRegistration(Repo.this, transaction.outstandingListener, QuerySpec.defaultQueryAtPath(transaction.path)));
                }
            });
            final DatabaseError callbackError = abortReason;
            callbacks.add(new Runnable(){

                @Override
                public void run() {
                    transaction.handler.onComplete(callbackError, false, snapshot);
                }
            });
        }
        this.pruneCompletedTransactions(this.transactionQueueTree);
        for (int i = 0; i < callbacks.size(); ++i) {
            this.postEvent((Runnable)callbacks.get(i));
        }
        this.sendAllReadyTransactions();
    }

    private Tree<List<TransactionData>> getAncestorTransactionNode(Path path) {
        Tree<List<TransactionData>> transactionNode = this.transactionQueueTree;
        while (!path.isEmpty() && transactionNode.getValue() == null) {
            transactionNode = transactionNode.subTree(new Path(path.getFront()));
            path = path.popFront();
        }
        return transactionNode;
    }

    private List<TransactionData> buildTransactionQueue(Tree<List<TransactionData>> transactionNode) {
        ArrayList<TransactionData> queue = new ArrayList<TransactionData>();
        this.aggregateTransactionQueues(queue, transactionNode);
        Collections.sort(queue);
        return queue;
    }

    private void aggregateTransactionQueues(final List<TransactionData> queue, Tree<List<TransactionData>> node) {
        List<TransactionData> childQueue = node.getValue();
        if (childQueue != null) {
            queue.addAll(childQueue);
        }
        node.forEachChild(new Tree.TreeVisitor<List<TransactionData>>(){

            @Override
            public void visitTree(Tree<List<TransactionData>> tree) {
                Repo.this.aggregateTransactionQueues(queue, tree);
            }
        });
    }

    private Path abortTransactions(Path path, final int reason) {
        Path affectedPath = this.getAncestorTransactionNode(path).getPath();
        if (this.transactionLogger.logsDebug()) {
            this.operationLogger.debug("Aborting transactions for path: " + path + ". Affected: " + affectedPath, new Object[0]);
        }
        Tree<List<TransactionData>> transactionNode = this.transactionQueueTree.subTree(path);
        transactionNode.forEachAncestor(new Tree.TreeFilter<List<TransactionData>>(){

            @Override
            public boolean filterTreeNode(Tree<List<TransactionData>> tree) {
                Repo.this.abortTransactionsAtNode(tree, reason);
                return false;
            }
        });
        this.abortTransactionsAtNode(transactionNode, reason);
        transactionNode.forEachDescendant(new Tree.TreeVisitor<List<TransactionData>>(){

            @Override
            public void visitTree(Tree<List<TransactionData>> tree) {
                Repo.this.abortTransactionsAtNode(tree, reason);
            }
        });
        return affectedPath;
    }

    private void abortTransactionsAtNode(Tree<List<TransactionData>> node, int reason) {
        List<TransactionData> queue = node.getValue();
        ArrayList<? extends Event> events = new ArrayList<Event>();
        if (queue != null) {
            DatabaseError abortError;
            ArrayList<25> callbacks = new ArrayList<25>();
            if (reason == -9) {
                abortError = DatabaseError.fromStatus(TRANSACTION_OVERRIDE_BY_SET);
            } else {
                Utilities.hardAssert(reason == -25, "Unknown transaction abort reason: " + reason);
                abortError = DatabaseError.fromCode(-25);
            }
            int lastSent = -1;
            for (int i = 0; i < queue.size(); ++i) {
                final TransactionData transactionData = queue.get(i);
                if (transactionData.status == TransactionStatus.SENT_NEEDS_ABORT) continue;
                if (transactionData.status == TransactionStatus.SENT) {
                    Utilities.hardAssert(lastSent == i - 1);
                    lastSent = i;
                    transactionData.status = TransactionStatus.SENT_NEEDS_ABORT;
                    transactionData.abortReason = abortError;
                    continue;
                }
                Utilities.hardAssert(transactionData.status == TransactionStatus.RUN);
                this.removeEventCallback(new ValueEventRegistration(this, transactionData.outstandingListener, QuerySpec.defaultQueryAtPath(transactionData.path)));
                if (reason == -9) {
                    events.addAll(this.serverSyncTree.ackUserWrite(transactionData.currentWriteId, true, false, this.serverClock));
                } else {
                    Utilities.hardAssert(reason == -25, "Unknown transaction abort reason: " + reason);
                }
                callbacks.add(new Runnable(){

                    @Override
                    public void run() {
                        transactionData.handler.onComplete(abortError, false, null);
                    }
                });
            }
            if (lastSent == -1) {
                node.setValue(null);
            } else {
                node.setValue(queue.subList(0, lastSent + 1));
            }
            this.postEvents(events);
            for (Runnable runnable : callbacks) {
                this.postEvent(runnable);
            }
        }
    }

    SyncTree getServerSyncTree() {
        return this.serverSyncTree;
    }

    SyncTree getInfoSyncTree() {
        return this.infoSyncTree;
    }

    private static DatabaseError fromErrorCode(String optErrorCode, String optErrorReason) {
        if (optErrorCode != null) {
            return DatabaseError.fromStatus(optErrorCode, optErrorReason);
        }
        return null;
    }

    private static class TransactionData
    implements Comparable<TransactionData> {
        private Path path;
        private Transaction.Handler handler;
        private ValueEventListener outstandingListener;
        private TransactionStatus status;
        private long order;
        private boolean applyLocally;
        private int retryCount;
        private DatabaseError abortReason;
        private long currentWriteId;
        private Node currentInputSnapshot;
        private Node currentOutputSnapshotRaw;
        private Node currentOutputSnapshotResolved;

        private TransactionData(Path path, Transaction.Handler handler, ValueEventListener outstandingListener, TransactionStatus status, boolean applyLocally, long order) {
            this.path = path;
            this.handler = handler;
            this.outstandingListener = outstandingListener;
            this.status = status;
            this.retryCount = 0;
            this.applyLocally = applyLocally;
            this.order = order;
            this.abortReason = null;
            this.currentInputSnapshot = null;
            this.currentOutputSnapshotRaw = null;
            this.currentOutputSnapshotResolved = null;
        }

        @Override
        public int compareTo(TransactionData o) {
            if (this.order < o.order) {
                return -1;
            }
            if (this.order == o.order) {
                return 0;
            }
            return 1;
        }
    }

    private static enum TransactionStatus {
        INITIALIZING,
        RUN,
        SENT,
        COMPLETED,
        SENT_NEEDS_ABORT,
        NEEDS_ABORT;

    }
}

