/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdft;
import com.google.android.gms.internal.zzdfx;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.math.RoundingMode;
import java.util.Arrays;

final class zzdfq
extends CharMatcher {
    private final String name;
    private final char[] zzkzh;
    final int mask;
    final int zzkzi;
    final int zzkzj;
    final int zzkzk;
    private final byte[] zzkzl;
    private final boolean[] zzkzm;

    zzdfq(String string, char[] cArray) {
        int n;
        this.name = (String)Preconditions.checkNotNull((Object)string);
        this.zzkzh = (char[])Preconditions.checkNotNull((Object)cArray);
        try {
            this.zzkzi = zzdfx.zza(cArray.length, RoundingMode.UNNECESSARY);
        }
        catch (ArithmeticException arithmeticException) {
            int n2 = cArray.length;
            throw new IllegalArgumentException(new StringBuilder(35).append("Illegal alphabet length ").append(n2).toString(), arithmeticException);
        }
        int n3 = Math.min(8, Integer.lowestOneBit(this.zzkzi));
        try {
            this.zzkzj = 8 / n3;
            this.zzkzk = this.zzkzi / n3;
        }
        catch (ArithmeticException arithmeticException) {
            String string2 = String.valueOf(new String(cArray));
            throw new IllegalArgumentException(string2.length() != 0 ? "Illegal alphabet ".concat(string2) : new String("Illegal alphabet "), arithmeticException);
        }
        this.mask = cArray.length - 1;
        byte[] byArray = new byte[128];
        Arrays.fill(byArray, (byte)-1);
        for (int i = 0; i < cArray.length; ++i) {
            n = cArray[i];
            Preconditions.checkArgument((boolean)CharMatcher.ascii().matches((char)n), (String)"Non-ASCII character: %s", (char)n);
            Preconditions.checkArgument((byArray[n] == -1 ? 1 : 0) != 0, (String)"Duplicate character: %s", (char)n);
            byArray[n] = (byte)i;
        }
        this.zzkzl = byArray;
        boolean[] blArray = new boolean[this.zzkzj];
        for (n = 0; n < this.zzkzk; ++n) {
            blArray[zzdfx.zza((int)(n << 3), (int)this.zzkzi, (RoundingMode)RoundingMode.CEILING)] = true;
        }
        this.zzkzm = blArray;
    }

    final char zzfb(int n) {
        return this.zzkzh[n];
    }

    final boolean zzfc(int n) {
        return this.zzkzm[n % this.zzkzj];
    }

    final int zza(char c) throws zzdft {
        if (c > '\u007f' || this.zzkzl[c] == -1) {
            Object object;
            if (CharMatcher.invisible().matches(c)) {
                String string = String.valueOf(Integer.toHexString(c));
                object = string.length() != 0 ? "0x".concat(string) : new String("0x");
            } else {
                object = Character.valueOf(c);
            }
            String string = String.valueOf(object);
            throw new zzdft(new StringBuilder(24 + String.valueOf(string).length()).append("Unrecognized character: ").append(string).toString());
        }
        return this.zzkzl[c];
    }

    final zzdfq zzbjr() {
        boolean bl;
        block5: {
            boolean bl2;
            int n;
            int n2;
            char[] cArray;
            block4: {
                cArray = this.zzkzh;
                n2 = this.zzkzh.length;
                for (n = 0; n < n2; ++n) {
                    if (!Ascii.isUpperCase((char)cArray[n])) continue;
                    bl2 = true;
                    break block4;
                }
                bl2 = false;
            }
            if (!bl2) {
                return this;
            }
            cArray = this.zzkzh;
            n2 = this.zzkzh.length;
            for (n = 0; n < n2; ++n) {
                if (!Ascii.isLowerCase((char)cArray[n])) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        Preconditions.checkState((!bl ? 1 : 0) != 0, (Object)"Cannot call lowerCase() on a mixed-case alphabet");
        char[] cArray = new char[this.zzkzh.length];
        for (int i = 0; i < this.zzkzh.length; ++i) {
            cArray[i] = Ascii.toLowerCase((char)this.zzkzh[i]);
        }
        return new zzdfq(String.valueOf(this.name).concat(".lowerCase()"), cArray);
    }

    public final boolean zzb(char c) {
        return CharMatcher.ascii().matches(c) && this.zzkzl[c] != -1;
    }

    public final String toString() {
        return this.name;
    }

    public final boolean equals(Object object) {
        if (object instanceof zzdfq) {
            zzdfq zzdfq2 = (zzdfq)((Object)object);
            return Arrays.equals(this.zzkzh, zzdfq2.zzkzh);
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.zzkzh);
    }

    static /* synthetic */ char[] zza(zzdfq zzdfq2) {
        return zzdfq2.zzkzh;
    }
}

