/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdfp;
import com.google.android.gms.internal.zzdfq;
import com.google.android.gms.internal.zzdft;
import com.google.android.gms.internal.zzdfx;
import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.math.RoundingMode;

class zzdfu
extends zzdfp {
    final zzdfq zzkzo;
    private Character zzkzp;
    private transient zzdfp zzkzq;

    zzdfu(String string, String string2, Character c) {
        this(new zzdfq(string, string2.toCharArray()), c);
    }

    zzdfu(zzdfq zzdfq2, Character c) {
        this.zzkzo = (zzdfq)((Object)Preconditions.checkNotNull((Object)((Object)zzdfq2)));
        Preconditions.checkArgument((c == null || !zzdfq2.zzb(c.charValue()) ? 1 : 0) != 0, (String)"Padding character %s was already in alphabet", (Object)c);
        this.zzkzp = c;
    }

    @Override
    final CharMatcher zzbjn() {
        if (this.zzkzp == null) {
            return CharMatcher.none();
        }
        return CharMatcher.is((char)this.zzkzp.charValue());
    }

    @Override
    final int zzez(int n) {
        return this.zzkzo.zzkzj * zzdfx.zza(n, this.zzkzo.zzkzk, RoundingMode.CEILING);
    }

    @Override
    void zza(Appendable appendable, byte[] byArray, int n, int n2) throws IOException {
        Preconditions.checkNotNull((Object)appendable);
        Preconditions.checkPositionIndexes((int)0, (int)(n2 + 0), (int)byArray.length);
        for (int i = 0; i < n2; i += this.zzkzo.zzkzk) {
            this.zzb(appendable, byArray, i + 0, Math.min(this.zzkzo.zzkzk, n2 - i));
        }
    }

    final void zzb(Appendable appendable, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        Preconditions.checkNotNull((Object)appendable);
        Preconditions.checkPositionIndexes((int)n, (int)(n + n2), (int)byArray.length);
        Preconditions.checkArgument((n2 <= this.zzkzo.zzkzk ? 1 : 0) != 0);
        long l = 0L;
        for (n4 = 0; n4 < n2; ++n4) {
            l = (l | (long)(byArray[n + n4] & 0xFF)) << 8;
        }
        n4 = (n2 + 1 << 3) - this.zzkzo.zzkzi;
        for (n3 = 0; n3 < n2 << 3; n3 += this.zzkzo.zzkzi) {
            int n5 = (int)(l >>> n4 - n3) & this.zzkzo.mask;
            appendable.append(this.zzkzo.zzfb(n5));
        }
        if (this.zzkzp != null) {
            while (n3 < this.zzkzo.zzkzk << 3) {
                appendable.append(this.zzkzp.charValue());
                n3 += this.zzkzo.zzkzi;
            }
        }
    }

    @Override
    final int zzfa(int n) {
        return (int)(((long)this.zzkzo.zzkzi * (long)n + 7L) / 8L);
    }

    @Override
    int zza(byte[] byArray, CharSequence charSequence) throws zzdft {
        Preconditions.checkNotNull((Object)byArray);
        charSequence = ((zzdfp)this).zzbjn().trimTrailingFrom(charSequence);
        if (!this.zzkzo.zzfc(charSequence.length())) {
            int n = charSequence.length();
            throw new zzdft(new StringBuilder(32).append("Invalid input length ").append(n).toString());
        }
        int n = 0;
        for (int i = 0; i < charSequence.length(); i += this.zzkzo.zzkzj) {
            int n2;
            long l = 0L;
            int n3 = 0;
            for (n2 = 0; n2 < this.zzkzo.zzkzj; ++n2) {
                l <<= this.zzkzo.zzkzi;
                if (i + n2 >= charSequence.length()) continue;
                l |= (long)this.zzkzo.zza(charSequence.charAt(i + n3++));
            }
            n2 = (this.zzkzo.zzkzk << 3) - n3 * this.zzkzo.zzkzi;
            for (int j = this.zzkzo.zzkzk - 1 << 3; j >= n2; j -= 8) {
                byArray[n++] = (byte)(l >>> j & 0xFFL);
            }
        }
        return n;
    }

    @Override
    public final zzdfp zzbjo() {
        zzdfp zzdfp2 = this.zzkzq;
        if (zzdfp2 == null) {
            zzdfq zzdfq2 = this.zzkzo.zzbjr();
            this.zzkzq = zzdfq2 == this.zzkzo ? this : this.zza(zzdfq2, this.zzkzp);
            zzdfp2 = this.zzkzq;
        }
        return zzdfp2;
    }

    zzdfp zza(zzdfq zzdfq2, Character c) {
        return new zzdfu(zzdfq2, c);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("BaseEncoding.");
        stringBuilder.append(this.zzkzo.toString());
        if (8 % this.zzkzo.zzkzi != 0) {
            if (this.zzkzp == null) {
                stringBuilder.append(".omitPadding()");
            } else {
                stringBuilder.append(".withPadChar('").append(this.zzkzp).append("')");
            }
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof zzdfu) {
            zzdfu zzdfu2 = (zzdfu)object;
            return this.zzkzo.equals((Object)zzdfu2.zzkzo) && Objects.equal((Object)this.zzkzp, (Object)zzdfu2.zzkzp);
        }
        return false;
    }

    public int hashCode() {
        return this.zzkzo.hashCode() ^ Objects.hashCode((Object[])new Object[]{this.zzkzp});
    }
}

