/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.NonNull;
import com.google.android.gms.internal.zzebm;
import com.google.android.gms.internal.zzebo;
import com.google.android.gms.internal.zzebp;
import com.google.android.gms.internal.zzebq;
import com.google.android.gms.internal.zzekj;
import com.google.android.gms.internal.zzekl;
import com.google.android.gms.internal.zzekv;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.firestore.FirebaseFirestoreException;

public final class zzebn
extends zzebm {
    private static final String TAG = zzebn.class.getSimpleName();
    private final FirebaseApp zzlqm;
    private final FirebaseApp.zzb zzmpk;
    private zzekj<zzebq> zzmpl;
    private zzebq zzmpm;
    private int zzmpn;

    public zzebn(FirebaseApp firebaseApp) {
        this.zzlqm = firebaseApp;
        this.zzmpm = zzebq.zzmpr;
        this.zzmpk = new zzebo(this, firebaseApp);
        this.zzmpm = zzebn.zze(firebaseApp);
        this.zzmpn = 0;
        firebaseApp.zza(this.zzmpk);
    }

    @Override
    public final synchronized Task<String> getToken(boolean bl) {
        Task task = this.zzlqm.getToken(false);
        int n = this.zzmpn;
        return task.continueWith((Continuation)new zzebp(this, n));
    }

    @Override
    public final synchronized void zza(@NonNull zzekj<zzebq> zzekj2) {
        this.zzmpl = zzekj2;
        zzekj2.zzbx(this.zzmpm);
    }

    private static zzebq zze(FirebaseApp firebaseApp) {
        try {
            String string = firebaseApp.getUid();
            if (string != null) {
                return new zzebq(string);
            }
            return zzebq.zzmpr;
        }
        catch (FirebaseApiNotAvailableException firebaseApiNotAvailableException) {
            zzekl.zzc(TAG, "Firebase Auth not available, falling back to unauthenticated usage.", new Object[0]);
            return zzebq.zzmpr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ String zza(int n, Task task) throws Exception {
        zzebn zzebn2 = this;
        synchronized (zzebn2) {
            if (n != this.zzmpn) {
                throw new FirebaseFirestoreException("getToken aborted due to user change", FirebaseFirestoreException.Code.ABORTED);
            }
            if (!task.isSuccessful()) {
                Exception exception = task.getException();
                if (exception instanceof FirebaseApiNotAvailableException) {
                    zzekl.zzc(TAG, "Firebase Auth is not available, getToken is returning no token.", new Object[0]);
                    return null;
                }
                throw exception;
            }
            return ((GetTokenResult)task.getResult()).getToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void zza(FirebaseApp firebaseApp, zzekv zzekv2) {
        zzebn zzebn2 = this;
        synchronized (zzebn2) {
            zzebq zzebq2 = zzebn.zze(firebaseApp);
            if (!this.zzmpm.equals(zzebq2)) {
                this.zzmpm = zzebq2;
                ++this.zzmpn;
                if (this.zzmpl != null) {
                    this.zzmpl.zzbx(this.zzmpm);
                }
            }
            return;
        }
    }
}

