/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzejo;
import java.util.Date;

public final class zzego
implements Comparable<zzego> {
    private final long zzmxm;
    private final int zzmxn;

    public zzego(long l, int n) {
        zzego.zze(l, n);
        this.zzmxm = l;
        this.zzmxn = n;
    }

    public zzego(Date date) {
        long l = date.getTime();
        long l2 = l / 1000L;
        int n = (int)(l % 1000L) * 1000000;
        if (n < 0) {
            --l2;
            n += 1000000000;
        }
        zzego.zze(l2, n);
        this.zzmxm = l2;
        this.zzmxn = n;
    }

    private static void zze(long l, int n) {
        zzejo.zzc(n >= 0, "timestamp nanoseconds out of range: %d", n);
        zzejo.zzc((double)n < 1.0E9, "timestamp nanoseconds out of range: %d", n);
        zzejo.zzc(l >= -62135596800L, "timestamp seconds out of range: %d", l);
        zzejo.zzc(l < 253402300800L, "timestamp seconds out of range: %d", l);
    }

    public final long zzcca() {
        return this.zzmxm;
    }

    public final int getNanos() {
        return this.zzmxn;
    }

    public final Date zzccb() {
        return new Date(this.zzmxm * 1000L + (long)(this.zzmxn / 1000000));
    }

    public final int zza(zzego zzego2) {
        if (this.zzmxm == zzego2.zzmxm) {
            return Integer.signum(this.zzmxn - zzego2.zzmxn);
        }
        return Long.signum(this.zzmxm - zzego2.zzmxm);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof zzego)) {
            return false;
        }
        return this.zza((zzego)object) == 0;
    }

    public final int hashCode() {
        int n = 37 * (int)this.zzmxm;
        n = n * 37 + (int)(this.zzmxm >> 32);
        return n * 37 + this.zzmxn;
    }

    public final String toString() {
        long l = this.zzmxm;
        int n = this.zzmxn;
        return new StringBuilder(58).append("Timestamp(seconds=").append(l).append(", nanos=").append(n).append(")").toString();
    }

    @Override
    public final /* synthetic */ int compareTo(Object object) {
        return this.zza((zzego)object);
    }
}

