/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.internal.zzejo;
import com.google.android.gms.internal.zzejq;
import com.google.android.gms.internal.zzejr;
import com.google.android.gms.internal.zzejs;
import com.google.android.gms.internal.zzejt;
import com.google.android.gms.internal.zzeju;
import com.google.android.gms.internal.zzekl;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class zzejp {
    private final Thread thread;
    private final ScheduledThreadPoolExecutor zzmlk;

    public static <TResult> Task<TResult> zza(Executor executor, Callable<Task<TResult>> callable) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        executor.execute(new zzejq(callable, executor, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    public zzejp() {
        zza zza2 = new zza(this, null);
        this.thread = Executors.defaultThreadFactory().newThread(zza2);
        this.thread.setName("FirestoreWorker");
        this.thread.setDaemon(true);
        this.thread.setUncaughtExceptionHandler(new zzejr(this));
        this.zzmlk = new zzeju(this, 1, zza2);
        this.zzmlk.setKeepAliveTime(3L, TimeUnit.SECONDS);
    }

    public final Executor zzcfp() {
        return this.zzmlk;
    }

    public final void zzcfq() {
        Thread thread = Thread.currentThread();
        if (this.thread != thread) {
            zzejo.zzk("We are running on the wrong thread. Expected to be on the AsyncQueue thread %s/%d but was %s/%d", this.thread.getName(), this.thread.getId(), thread.getName(), thread.getId());
        }
    }

    public final void enqueue(Runnable runnable) {
        try {
            this.zzmlk.execute(runnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            zzekl.zzb(zzejp.class.getSimpleName(), "Refused to enqueue task after panic", new Object[0]);
            return;
        }
    }

    public final void zzi(Throwable throwable) {
        this.zzmlk.shutdownNow();
        new Handler(Looper.getMainLooper()).post((Runnable)new zzejs(throwable));
    }

    public final ScheduledFuture<?> zza(Runnable runnable, long l) {
        return this.zzmlk.schedule(runnable, l, TimeUnit.MILLISECONDS);
    }

    final /* synthetic */ void zzb(Thread thread, Throwable throwable) {
        this.zzi(throwable);
    }

    final class zza
    implements Runnable,
    ThreadFactory {
        private final CountDownLatch zzndg = new CountDownLatch(1);
        private Runnable zzndh;
        private /* synthetic */ zzejp zzndf;

        private zza(zzejp zzejp2) {
            this.zzndf = zzejp2;
        }

        @Override
        public final void run() {
            try {
                this.zzndg.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            this.zzndh.run();
        }

        @Override
        public final Thread newThread(@NonNull Runnable runnable) {
            zzejo.zzc(this.zzndh == null, "Only one thread may be created in an AsyncQueue.", new Object[0]);
            this.zzndh = runnable;
            this.zzndg.countDown();
            return this.zzndf.thread;
        }

        /* synthetic */ zza(zzejp zzejp2, zzejt zzejt2) {
            this(zzejp2);
        }
    }
}

