/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzezw;
import com.google.android.gms.internal.zzezy;
import com.google.android.gms.internal.zzfaa;
import com.google.android.gms.internal.zzfba;
import io.grpc.internal.GrpcUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;

public class zzezx {
    public static final Logger logger = Logger.getLogger(zzezx.class.getName());
    private static final String[] zzplm = new String[]{"com.google.android.gms.org.conscrypt.OpenSSLProvider", "com.android.org.conscrypt.OpenSSLProvider", "org.conscrypt.OpenSSLProvider", "org.apache.harmony.xnet.provider.jsse.OpenSSLProvider"};
    private static final zzezx zzpln = zzezx.zzdah();
    private final Provider zzplo;

    public static zzezx zzdag() {
        return zzpln;
    }

    public zzezx(Provider provider) {
        this.zzplo = provider;
    }

    public final Provider getProvider() {
        return this.zzplo;
    }

    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List<zzezy> list) {
    }

    public void afterHandshake(SSLSocket sSLSocket) {
    }

    public String getSelectedProtocol(SSLSocket sSLSocket) {
        return null;
    }

    private static zzezx zzdah() {
        Provider provider;
        Provider provider2;
        block13: {
            if (GrpcUtil.IS_RESTRICTED_APPENGINE) {
                provider2 = zzezx.zzdai();
            } else {
                String[] stringArray = zzplm;
                int n = zzplm.length;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    for (Provider provider3 : Security.getProviders()) {
                        if (!string.equals(provider3.getClass().getName())) continue;
                        logger.logp(Level.FINE, "io.grpc.okhttp.internal.Platform", "getAndroidSecurityProvider", "Found registered provider {0}", string);
                        provider2 = provider3;
                        break block13;
                    }
                }
                logger.logp(Level.WARNING, "io.grpc.okhttp.internal.Platform", "getAndroidSecurityProvider", "Unable to find Conscrypt");
                provider2 = provider = null;
            }
        }
        if (provider2 != null) {
            zzezw<Socket> zzezw2 = new zzezw<Socket>(null, "setUseSessionTickets", Boolean.TYPE);
            zzezw<Socket> zzezw3 = new zzezw<Socket>(null, "setHostname", String.class);
            Method method = null;
            Method method2 = null;
            zzezw<Socket> zzezw4 = new zzezw<Socket>(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
            zzezw<Socket> zzezw5 = new zzezw<Socket>(null, "setAlpnProtocols", byte[].class);
            try {
                Class<?> clazz = Class.forName("android.net.TrafficStats");
                method = clazz.getMethod("tagSocket", Socket.class);
                method2 = clazz.getMethod("untagSocket", Socket.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            return new zza(zzezw2, zzezw3, method, method2, zzezw4, zzezw5, provider);
        }
        try {
            provider = SSLContext.getDefault().getProvider();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        try {
            String string = "org.eclipse.jetty.alpn.ALPN";
            Class<?> clazz = Class.forName("org.eclipse.jetty.alpn.ALPN");
            Class<?> clazz2 = Class.forName(String.valueOf(string).concat("$Provider"));
            Class<?> clazz3 = Class.forName(String.valueOf(string).concat("$ClientProvider"));
            Class<?> clazz4 = Class.forName(String.valueOf(string).concat("$ServerProvider"));
            Method method = clazz.getMethod("put", SSLSocket.class, clazz2);
            Method method3 = clazz.getMethod("get", SSLSocket.class);
            Method method4 = clazz.getMethod("remove", SSLSocket.class);
            return new zzb(method, method3, method4, clazz3, clazz4, provider);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return new zzezx(provider);
    }

    private static Provider zzdai() {
        try {
            return (Provider)Class.forName("org.conscrypt.OpenSSLProvider").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to load conscrypt security provider", throwable);
        }
    }

    public static byte[] concatLengthPrefixed(List<zzezy> list) {
        zzfba zzfba2 = new zzfba();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            zzezy zzezy2 = list.get(i);
            if (zzezy2 == zzezy.zzpma) continue;
            zzfba2.zzmb(zzezy2.toString().length());
            zzfba2.zzud(zzezy2.toString());
        }
        return zzfba2.zzdba();
    }

    static final class zzc
    implements InvocationHandler {
        private final List<String> protocols;
        private boolean unsupported;
        private String selected;

        public zzc(List<String> list) {
            this.protocols = list;
        }

        @Override
        public final Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            Class<?> clazz = method.getReturnType();
            if (objectArray == null) {
                objectArray = zzfaa.EMPTY_STRING_ARRAY;
            }
            if (string.equals("supports") && Boolean.TYPE == clazz) {
                return true;
            }
            if (string.equals("unsupported") && Void.TYPE == clazz) {
                this.unsupported = true;
                return null;
            }
            if (string.equals("protocols") && objectArray.length == 0) {
                return this.protocols;
            }
            if ((string.equals("selectProtocol") || string.equals("select")) && String.class == clazz && objectArray.length == 1 && objectArray[0] instanceof List) {
                List list = (List)objectArray[0];
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    if (!this.protocols.contains(list.get(i))) continue;
                    this.selected = (String)list.get(i);
                    return this.selected;
                }
                this.selected = this.protocols.get(0);
                return this.selected;
            }
            if ((string.equals("protocolSelected") || string.equals("selected")) && objectArray.length == 1) {
                this.selected = (String)objectArray[0];
                return null;
            }
            return method.invoke((Object)this, objectArray);
        }
    }

    static final class zzb
    extends zzezx {
        private final Method zzplv;
        private final Method zzplw;
        private final Method zzplx;
        private final Class<?> zzply;
        private final Class<?> zzplz;

        public zzb(Method method, Method method2, Method method3, Class<?> clazz, Class<?> clazz2, Provider provider) {
            super(provider);
            this.zzplv = method;
            this.zzplw = method2;
            this.zzplx = method3;
            this.zzply = clazz;
            this.zzplz = clazz2;
        }

        @Override
        public final void configureTlsExtensions(SSLSocket sSLSocket, String string, List<zzezy> list) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                zzezy zzezy2 = list.get(i);
                if (zzezy2 == zzezy.zzpma) continue;
                arrayList.add(zzezy2.toString());
            }
            try {
                Object object = Proxy.newProxyInstance(zzezx.class.getClassLoader(), new Class[]{this.zzply, this.zzplz}, (InvocationHandler)new zzc(arrayList));
                this.zzplv.invoke(null, sSLSocket, object);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AssertionError((Object)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        @Override
        public final void afterHandshake(SSLSocket sSLSocket) {
            try {
                this.zzplx.invoke(null, sSLSocket);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            catch (InvocationTargetException invocationTargetException) {
                return;
            }
        }

        @Override
        public final String getSelectedProtocol(SSLSocket sSLSocket) {
            try {
                zzc zzc2 = (zzc)Proxy.getInvocationHandler(this.zzplw.invoke(null, sSLSocket));
                if (!zzc2.unsupported && zzc2.selected == null) {
                    logger.logp(Level.INFO, "io.grpc.okhttp.internal.Platform$JdkWithJettyBootPlatform", "getSelectedProtocol", "ALPN callback dropped: SPDY and HTTP/2 are disabled. Is alpn-boot on the boot class path?");
                    return null;
                }
                if (zzc2.unsupported) {
                    return null;
                }
                return zzc2.selected;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AssertionError();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
        }
    }

    static final class zza
    extends zzezx {
        private final zzezw<Socket> zzplp;
        private final zzezw<Socket> zzplq;
        private final Method zzplr;
        private final Method zzpls;
        private final zzezw<Socket> zzplt;
        private final zzezw<Socket> zzplu;

        public zza(zzezw<Socket> zzezw2, zzezw<Socket> zzezw3, Method method, Method method2, zzezw<Socket> zzezw4, zzezw<Socket> zzezw5, Provider provider) {
            super(provider);
            this.zzplp = zzezw2;
            this.zzplq = zzezw3;
            this.zzplr = method;
            this.zzpls = method2;
            this.zzplt = zzezw4;
            this.zzplu = zzezw5;
        }

        @Override
        public final void configureTlsExtensions(SSLSocket sSLSocket, String string, List<zzezy> list) {
            if (string != null) {
                this.zzplp.invokeOptionalWithoutCheckedException(sSLSocket, true);
                this.zzplq.invokeOptionalWithoutCheckedException(sSLSocket, string);
            }
            if (this.zzplu.isSupported(sSLSocket)) {
                Object[] objectArray = new Object[]{zza.concatLengthPrefixed(list)};
                this.zzplu.invokeWithoutCheckedException(sSLSocket, objectArray);
            }
        }

        @Override
        public final String getSelectedProtocol(SSLSocket sSLSocket) {
            if (!this.zzplt.isSupported(sSLSocket)) {
                return null;
            }
            byte[] byArray = (byte[])this.zzplt.invokeWithoutCheckedException(sSLSocket, new Object[0]);
            if (byArray != null) {
                return new String(byArray, zzfaa.UTF_8);
            }
            return null;
        }
    }
}

