/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfaf;
import com.google.android.gms.internal.zzfah;
import com.google.android.gms.internal.zzfao;
import com.google.android.gms.internal.zzfbc;
import com.google.android.gms.internal.zzfbd;
import com.google.android.gms.internal.zzfbg;
import com.google.android.gms.internal.zzfbq;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class zzfai {
    private final List<zzfaf> zzpno = new ArrayList<zzfaf>();
    private final zzfbc source;
    private int headerTableSizeSetting = 4096;
    private int maxDynamicTableByteCount = 4096;
    private zzfaf[] zzpnp = new zzfaf[8];
    private int nextHeaderIndex = this.zzpnp.length - 1;
    private int headerCount = 0;
    private int dynamicTableByteCount = 0;

    zzfai(int n, zzfbq zzfbq2) {
        this.source = zzfbg.zzb(zzfbq2);
    }

    final void zzlt(int n) {
        this.headerTableSizeSetting = n;
        this.maxDynamicTableByteCount = n;
        this.zzdak();
    }

    private final void zzdak() {
        if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
            if (this.maxDynamicTableByteCount == 0) {
                this.zzdal();
                return;
            }
            this.zzlu(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
        }
    }

    private final void zzdal() {
        this.zzpno.clear();
        Arrays.fill(this.zzpnp, null);
        this.nextHeaderIndex = this.zzpnp.length - 1;
        this.headerCount = 0;
        this.dynamicTableByteCount = 0;
    }

    private final int zzlu(int n) {
        int n2 = 0;
        if (n > 0) {
            for (int i = this.zzpnp.length - 1; i >= this.nextHeaderIndex && n > 0; --i) {
                n -= this.zzpnp[i].hpackSize;
                this.dynamicTableByteCount -= this.zzpnp[i].hpackSize;
                --this.headerCount;
                ++n2;
            }
            System.arraycopy(this.zzpnp, this.nextHeaderIndex + 1, this.zzpnp, this.nextHeaderIndex + 1 + n2, this.headerCount);
            this.nextHeaderIndex += n2;
        }
        return n2;
    }

    final void readHeaders() throws IOException {
        while (!this.source.zzday()) {
            zzfbd zzfbd2;
            Object object;
            zzfai zzfai2;
            int n;
            int n2 = this.source.readByte() & 0xFF;
            if (n2 == 128) {
                throw new IOException("index == 0");
            }
            if ((n2 & 0x80) == 128) {
                n = this.readInt(n2, 127);
                int n3 = n - 1;
                zzfai2 = this;
                if (zzfai.zzlx(n3)) {
                    object = zzfah.zzdaj()[n3];
                    zzfai2.zzpno.add((zzfaf)object);
                    continue;
                }
                int n4 = zzfai2.zzlv(n3 - zzfah.zzdaj().length);
                if (n4 < 0 || n4 > zzfai2.zzpnp.length - 1) {
                    int n5 = n3 + 1;
                    throw new IOException(new StringBuilder(34).append("Header index too large ").append(n5).toString());
                }
                zzfai2.zzpno.add(zzfai2.zzpnp[n4]);
                continue;
            }
            if (n2 == 64) {
                zzfai2 = this;
                zzfbd zzfbd3 = zzfah.zza(zzfai2.readByteString());
                object = zzfai2.readByteString();
                zzfai2.zza(-1, new zzfaf(zzfbd3, (zzfbd)object));
                continue;
            }
            if ((n2 & 0x40) == 64) {
                n = this.readInt(n2, 63);
                int n6 = n - 1;
                zzfai2 = this;
                object = zzfai2.zzlw(n6);
                zzfbd2 = zzfai2.readByteString();
                zzfai2.zza(-1, new zzfaf((zzfbd)object, zzfbd2));
                continue;
            }
            if ((n2 & 0x20) == 32) {
                this.maxDynamicTableByteCount = this.readInt(n2, 31);
                if (this.maxDynamicTableByteCount < 0 || this.maxDynamicTableByteCount > this.headerTableSizeSetting) {
                    n = this.maxDynamicTableByteCount;
                    throw new IOException(new StringBuilder(45).append("Invalid dynamic table size update ").append(n).toString());
                }
                this.zzdak();
                continue;
            }
            if (n2 == 16 || n2 == 0) {
                zzfai2 = this;
                zzfbd zzfbd4 = zzfah.zza(zzfai2.readByteString());
                object = zzfai2.readByteString();
                zzfai2.zzpno.add(new zzfaf(zzfbd4, (zzfbd)object));
                continue;
            }
            n = this.readInt(n2, 15);
            int n7 = n - 1;
            zzfai2 = this;
            object = zzfai2.zzlw(n7);
            zzfbd2 = zzfai2.readByteString();
            zzfai2.zzpno.add(new zzfaf((zzfbd)object, zzfbd2));
        }
    }

    public final List<zzfaf> getAndResetHeaderList() {
        ArrayList<zzfaf> arrayList = new ArrayList<zzfaf>(this.zzpno);
        this.zzpno.clear();
        return arrayList;
    }

    private final int zzlv(int n) {
        return this.nextHeaderIndex + 1 + n;
    }

    private final zzfbd zzlw(int n) {
        if (zzfai.zzlx(n)) {
            return zzfah.zzdaj()[n].name;
        }
        return this.zzpnp[this.zzlv((int)(n - zzfah.zzdaj().length))].name;
    }

    private static boolean zzlx(int n) {
        return n >= 0 && n <= zzfah.zzdaj().length - 1;
    }

    private final void zza(int n, zzfaf zzfaf2) {
        this.zzpno.add(zzfaf2);
        int n2 = zzfaf2.hpackSize;
        if (n2 > this.maxDynamicTableByteCount) {
            this.zzdal();
            return;
        }
        int n3 = this.dynamicTableByteCount + n2 - this.maxDynamicTableByteCount;
        this.zzlu(n3);
        if (this.headerCount + 1 > this.zzpnp.length) {
            zzfaf[] zzfafArray = new zzfaf[this.zzpnp.length << 1];
            System.arraycopy(this.zzpnp, 0, zzfafArray, this.zzpnp.length, this.zzpnp.length);
            this.nextHeaderIndex = this.zzpnp.length - 1;
            this.zzpnp = zzfafArray;
        }
        n = this.nextHeaderIndex--;
        this.zzpnp[n] = zzfaf2;
        ++this.headerCount;
        this.dynamicTableByteCount += n2;
    }

    private final int zzdam() throws IOException {
        return this.source.readByte() & 0xFF;
    }

    private final int readInt(int n, int n2) throws IOException {
        int n3;
        int n4 = n & n2;
        if (n4 < n2) {
            return n4;
        }
        int n5 = n2;
        int n6 = 0;
        while (((n3 = this.zzdam()) & 0x80) != 0) {
            n5 += (n3 & 0x7F) << n6;
            n6 += 7;
        }
        return n5 += n3 << n6;
    }

    private final zzfbd readByteString() throws IOException {
        int n = this.zzdam();
        boolean bl = (n & 0x80) == 128;
        int n2 = this.readInt(n, 127);
        if (bl) {
            return zzfbd.zzbn(zzfao.zzdap().decode(this.source.zzdo(n2)));
        }
        return this.source.zzdk(n2);
    }
}

