/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfac;
import com.google.android.gms.internal.zzfae;
import com.google.android.gms.internal.zzfam;
import com.google.android.gms.internal.zzfan;
import com.google.android.gms.internal.zzfar;
import com.google.android.gms.internal.zzfbb;
import com.google.android.gms.internal.zzfbc;
import com.google.android.gms.internal.zzfbd;
import java.io.IOException;
import java.util.logging.Logger;

public final class zzfak
implements zzfar {
    private static final Logger logger = Logger.getLogger(zza.class.getName());
    private static final zzfbd CONNECTION_PREFACE = zzfbd.zzue("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");

    @Override
    public final zzfac zza(zzfbc zzfbc2, boolean bl) {
        return new zzfam(zzfbc2, 4096, true);
    }

    @Override
    public final zzfae zza(zzfbb zzfbb2, boolean bl) {
        return new zzfan(zzfbb2, true);
    }

    private static IllegalArgumentException illegalArgument(String string, Object ... objectArray) {
        throw new IllegalArgumentException(String.format(string, objectArray));
    }

    private static IOException ioException(String string, Object ... objectArray) throws IOException {
        throw new IOException(String.format(string, objectArray));
    }

    private static int lengthWithoutPadding(int n, byte by, short s) throws IOException {
        if ((by & 8) != 0) {
            --n;
        }
        if (s > n) {
            throw zzfak.ioException("PROTOCOL_ERROR padding %s > remaining length %s", s, n);
        }
        return (short)(n - s);
    }

    private static int readMedium(zzfbc zzfbc2) throws IOException {
        return (zzfbc2.readByte() & 0xFF) << 16 | (zzfbc2.readByte() & 0xFF) << 8 | zzfbc2.readByte() & 0xFF;
    }

    private static void zza(zzfbb zzfbb2, int n) throws IOException {
        zzfbb2.zzmb(n >>> 16 & 0xFF);
        zzfbb2.zzmb(n >>> 8 & 0xFF);
        zzfbb2.zzmb(n & 0xFF);
    }

    static /* synthetic */ zzfbd zzdan() {
        return CONNECTION_PREFACE;
    }

    static /* synthetic */ Logger zzdao() {
        return logger;
    }

    static /* synthetic */ IOException zzl(String string, Object[] objectArray) throws IOException {
        return zzfak.ioException(string, objectArray);
    }

    static /* synthetic */ int zza(zzfbc zzfbc2) throws IOException {
        return zzfak.readMedium(zzfbc2);
    }

    static /* synthetic */ int zza(int n, byte by, short s) throws IOException {
        return zzfak.lengthWithoutPadding(n, by, s);
    }

    static /* synthetic */ IllegalArgumentException zzm(String string, Object[] objectArray) {
        return zzfak.illegalArgument(string, objectArray);
    }

    static /* synthetic */ void zzb(zzfbb zzfbb2, int n) throws IOException {
        zzfak.zza(zzfbb2, n);
    }

    static final class zza {
        private static final String[] TYPES;
        private static final String[] FLAGS;
        private static final String[] BINARY;

        zza() {
        }

        static String zza(boolean bl, int n, int n2, byte by, byte by2) {
            String string;
            String string2 = by < TYPES.length ? TYPES[by] : String.format("0x%02x", by);
            byte by3 = by2;
            byte by4 = by;
            if (by3 == 0) {
                string = "";
            } else {
                switch (by4) {
                    case 4: 
                    case 6: {
                        if (by3 == 1) {
                            string = "ACK";
                            break;
                        }
                        string = BINARY[by3];
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 7: 
                    case 8: {
                        string = BINARY[by3];
                        break;
                    }
                    default: {
                        String string3;
                        String string4 = string3 = by3 < FLAGS.length ? FLAGS[by3] : BINARY[by3];
                        string = by4 == 5 && (by3 & 4) != 0 ? string3.replace("HEADERS", "PUSH_PROMISE") : (by4 == 0 && (by3 & 0x20) != 0 ? string3.replace("PRIORITY", "COMPRESSED") : string3);
                    }
                }
            }
            String string5 = string;
            return String.format("%s 0x%08x %5d %-13s %s", bl ? "<<" : ">>", n, n2, string2, string5);
        }

        static {
            int n;
            TYPES = new String[]{"DATA", "HEADERS", "PRIORITY", "RST_STREAM", "SETTINGS", "PUSH_PROMISE", "PING", "GOAWAY", "WINDOW_UPDATE", "CONTINUATION"};
            FLAGS = new String[64];
            BINARY = new String[256];
            for (int i = 0; i < BINARY.length; ++i) {
                zza.BINARY[i] = String.format("%8s", Integer.toBinaryString(i)).replace(' ', '0');
            }
            zza.FLAGS[0] = "";
            zza.FLAGS[1] = "END_STREAM";
            int[] nArray = new int[]{1};
            zza.FLAGS[8] = "PADDED";
            int[] nArray2 = nArray;
            for (int i = 0; i <= 0; ++i) {
                n = nArray2[i];
                zza.FLAGS[n | 8] = String.valueOf(FLAGS[n]).concat("|PADDED");
            }
            zza.FLAGS[4] = "END_HEADERS";
            zza.FLAGS[32] = "PRIORITY";
            zza.FLAGS[36] = "END_HEADERS|PRIORITY";
            int[] nArray3 = new int[]{4, 32, 36};
            for (n = 0; n < 3; ++n) {
                int n2 = nArray3[n];
                int[] nArray4 = nArray;
                for (int i = 0; i <= 0; ++i) {
                    int n3 = nArray4[i];
                    String string = FLAGS[n3];
                    String string2 = FLAGS[n2];
                    zza.FLAGS[n3 | n2] = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("|").append(string2).toString();
                    string = FLAGS[n3];
                    string2 = FLAGS[n2];
                    zza.FLAGS[n3 | n2 | 8] = new StringBuilder(8 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("|").append(string2).append("|PADDED").toString();
                }
            }
            for (int i = 0; i < FLAGS.length; ++i) {
                if (FLAGS[i] != null) continue;
                zza.FLAGS[i] = BINARY[i];
            }
        }
    }
}

