/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfab;
import com.google.android.gms.internal.zzfae;
import com.google.android.gms.internal.zzfaf;
import com.google.android.gms.internal.zzfaj;
import com.google.android.gms.internal.zzfak;
import com.google.android.gms.internal.zzfaq;
import com.google.android.gms.internal.zzfba;
import com.google.android.gms.internal.zzfbb;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;

final class zzfan
implements zzfae {
    private final zzfbb sink;
    private final boolean client;
    private final zzfba zzpnt;
    private final zzfaj zzpnu;
    private int zzpnv;
    private boolean closed;

    zzfan(zzfbb zzfbb2, boolean bl) {
        this.sink = zzfbb2;
        this.client = true;
        this.zzpnt = new zzfba();
        this.zzpnu = new zzfaj(this.zzpnt);
        this.zzpnv = 16384;
    }

    @Override
    public final synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.sink.flush();
    }

    @Override
    public final synchronized void zza(zzfaq zzfaq2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.zzpnv = zzfaq2.getMaxFrameSize(this.zzpnv);
        this.frameHeader(0, 0, (byte)4, (byte)1);
        this.sink.flush();
    }

    @Override
    public final synchronized void connectionPreface() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (!this.client) {
            return;
        }
        if (zzfak.zzdao().isLoggable(Level.FINE)) {
            zzfak.zzdao().logp(Level.FINE, "io.grpc.okhttp.internal.framed.Http2$Writer", "connectionPreface", String.format(">> CONNECTION %s", zzfak.zzdan().zzdbc()));
        }
        this.sink.zzbm(zzfak.zzdan().toByteArray());
        this.sink.flush();
    }

    @Override
    public final synchronized void zza(boolean bl, boolean bl2, int n, int n2, List<zzfaf> list) throws IOException {
        byte by;
        if (bl2) {
            throw new UnsupportedOperationException();
        }
        if (this.closed) {
            throw new IOException("closed");
        }
        List<zzfaf> list2 = list;
        int n3 = n;
        boolean bl3 = bl;
        zzfan zzfan2 = this;
        if (zzfan2.closed) {
            throw new IOException("closed");
        }
        zzfan2.zzpnu.writeHeaders(list2);
        long l = zzfan2.zzpnt.size();
        int n4 = (int)Math.min((long)zzfan2.zzpnv, l);
        byte by2 = by = l == (long)n4 ? (byte)4 : 0;
        if (bl3) {
            by = (byte)(by | 1);
        }
        zzfan2.frameHeader(n3, n4, (byte)1, by);
        zzfan2.sink.write(zzfan2.zzpnt, n4);
        if (l > (long)n4) {
            zzfan2.zzi(n3, l - (long)n4);
        }
    }

    private final void zzi(int n, long l) throws IOException {
        while (l > 0L) {
            int n2;
            this.frameHeader(n, n2, (byte)9, (l -= (long)(n2 = (int)Math.min((long)this.zzpnv, l))) == 0L ? (byte)4 : 0);
            this.sink.write(this.zzpnt, n2);
        }
    }

    @Override
    public final synchronized void zza(int n, zzfab zzfab2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (zzfab2.httpCode == -1) {
            throw new IllegalArgumentException();
        }
        this.frameHeader(n, 4, (byte)3, (byte)0);
        this.sink.zzlz(zzfab2.httpCode);
        this.sink.flush();
    }

    @Override
    public final int maxDataLength() {
        return this.zzpnv;
    }

    @Override
    public final synchronized void data(boolean bl, int n, zzfba zzfba2, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        byte by = 0;
        if (bl) {
            by = 1;
        }
        int n3 = n2;
        zzfba zzfba3 = zzfba2;
        byte by2 = by;
        int n4 = n;
        zzfan zzfan2 = this;
        zzfan2.frameHeader(n4, n3, (byte)0, by2);
        if (n3 > 0) {
            zzfan2.sink.write(zzfba3, n3);
        }
    }

    @Override
    public final synchronized void zzb(zzfaq zzfaq2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        int n = zzfaq2.size() * 6;
        this.frameHeader(0, n, (byte)4, (byte)0);
        for (int i = 0; i < 10; ++i) {
            if (!zzfaq2.isSet(i)) continue;
            int n2 = i;
            if (n2 == 4) {
                n2 = 3;
            } else if (n2 == 7) {
                n2 = 4;
            }
            this.sink.zzma(n2);
            this.sink.zzlz(zzfaq2.get(i));
        }
        this.sink.flush();
    }

    @Override
    public final synchronized void ping(boolean bl, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        byte by = bl ? (byte)1 : 0;
        this.frameHeader(0, 8, (byte)6, by);
        this.sink.zzlz(n);
        this.sink.zzlz(n2);
        this.sink.flush();
    }

    @Override
    public final synchronized void zza(int n, zzfab zzfab2, byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (zzfab2.httpCode == -1) {
            throw zzfak.zzm("errorCode.httpCode == -1", new Object[0]);
        }
        int n2 = 8 + byArray.length;
        this.frameHeader(0, n2, (byte)7, (byte)0);
        this.sink.zzlz(n);
        this.sink.zzlz(zzfab2.httpCode);
        if (byArray.length > 0) {
            this.sink.zzbm(byArray);
        }
        this.sink.flush();
    }

    @Override
    public final synchronized void windowUpdate(int n, long l) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (l == 0L || l > Integer.MAX_VALUE) {
            throw zzfak.zzm("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: %s", new Object[]{l});
        }
        this.frameHeader(n, 4, (byte)8, (byte)0);
        this.sink.zzlz((int)l);
        this.sink.flush();
    }

    @Override
    public final synchronized void close() throws IOException {
        this.closed = true;
        this.sink.close();
    }

    private final void frameHeader(int n, int n2, byte by, byte by2) throws IOException {
        if (zzfak.zzdao().isLoggable(Level.FINE)) {
            zzfak.zzdao().logp(Level.FINE, "io.grpc.okhttp.internal.framed.Http2$Writer", "frameHeader", zzfak.zza.zza(false, n, n2, by, by2));
        }
        if (n2 > this.zzpnv) {
            throw zzfak.zzm("FRAME_SIZE_ERROR length > %d: %d", new Object[]{this.zzpnv, n2});
        }
        if ((n & Integer.MIN_VALUE) != 0) {
            throw zzfak.zzm("reserved bit set: %s", new Object[]{n});
        }
        zzfak.zzb(this.sink, n2);
        this.sink.zzmb(by & 0xFF);
        this.sink.zzmb(by2 & 0xFF);
        this.sink.zzlz(n & Integer.MAX_VALUE);
    }
}

