/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfbb;
import com.google.android.gms.internal.zzfbc;
import com.google.android.gms.internal.zzfbd;
import com.google.android.gms.internal.zzfbm;
import com.google.android.gms.internal.zzfbn;
import com.google.android.gms.internal.zzfbo;
import com.google.android.gms.internal.zzfbt;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public final class zzfba
implements zzfbb,
zzfbc,
Cloneable {
    private static final byte[] zzpov = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    zzfbm zzpow;
    long zzbz;

    public final long size() {
        return this.zzbz;
    }

    @Override
    public final zzfba zzczs() {
        return this;
    }

    @Override
    public final boolean zzday() {
        return this.zzbz == 0L;
    }

    @Override
    public final void zzdi(long l) throws EOFException {
        if (this.zzbz < l) {
            throw new EOFException();
        }
    }

    private final zzfba zza(zzfba zzfba2, long l, long l2) {
        zzfbt.checkOffsetAndCount(this.zzbz, 0L, l2);
        if (l2 == 0L) {
            return this;
        }
        zzfba2.zzbz += l2;
        zzfbm zzfbm2 = this.zzpow;
        while (l >= (long)(zzfbm2.limit - zzfbm2.pos)) {
            l -= (long)(zzfbm2.limit - zzfbm2.pos);
            zzfbm2 = zzfbm2.zzppi;
        }
        while (l2 > 0L) {
            zzfbm zzfbm3 = new zzfbm(zzfbm2);
            zzfbm3.pos = (int)((long)zzfbm3.pos + l);
            zzfbm3.limit = Math.min(zzfbm3.pos + (int)l2, zzfbm3.limit);
            if (zzfba2.zzpow == null) {
                zzfbm3.zzppi = zzfbm3.zzppj = zzfbm3;
                zzfba2.zzpow = zzfbm3.zzppj;
            } else {
                zzfba2.zzpow.zzppj.zza(zzfbm3);
            }
            l2 -= (long)(zzfbm3.limit - zzfbm3.pos);
            l = 0L;
            zzfbm2 = zzfbm2.zzppi;
        }
        return this;
    }

    public final zzfba zzb(OutputStream outputStream, long l) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        zzfbt.checkOffsetAndCount(this.zzbz, 0L, l);
        zzfbm zzfbm2 = this.zzpow;
        while (l > 0L) {
            int n = (int)Math.min(l, (long)(zzfbm2.limit - zzfbm2.pos));
            outputStream.write(zzfbm2.data, zzfbm2.pos, n);
            zzfbm2.pos += n;
            this.zzbz -= (long)n;
            l -= (long)n;
            if (zzfbm2.pos != zzfbm2.limit) continue;
            zzfbm zzfbm3 = zzfbm2;
            this.zzpow = zzfbm2 = zzfbm3.zzdbf();
            zzfbn.zzb(zzfbm3);
        }
        return this;
    }

    @Override
    public final byte readByte() {
        if (this.zzbz == 0L) {
            throw new IllegalStateException("size == 0");
        }
        zzfbm zzfbm2 = this.zzpow;
        int n = zzfbm2.pos;
        int n2 = zzfbm2.limit;
        byte by = zzfbm2.data[n++];
        --this.zzbz;
        if (n == n2) {
            this.zzpow = zzfbm2.zzdbf();
            zzfbn.zzb(zzfbm2);
        } else {
            zzfbm2.pos = n;
        }
        return by;
    }

    public final byte zzdj(long l) {
        zzfbt.checkOffsetAndCount(this.zzbz, l, 1L);
        zzfbm zzfbm2 = this.zzpow;
        int n;
        while (l >= (long)(n = zzfbm2.limit - zzfbm2.pos)) {
            l -= (long)n;
            zzfbm2 = zzfbm2.zzppi;
        }
        return zzfbm2.data[zzfbm2.pos + (int)l];
    }

    @Override
    public final short readShort() {
        if (this.zzbz < 2L) {
            throw new IllegalStateException("size < 2: " + this.zzbz);
        }
        zzfbm zzfbm2 = this.zzpow;
        int n = zzfbm2.limit;
        int n2 = zzfbm2.pos;
        if (n - n2 < 2) {
            return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
        }
        byte[] byArray = zzfbm2.data;
        int n3 = (zzfbm2.data[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        this.zzbz -= 2L;
        if (n2 == n) {
            this.zzpow = zzfbm2.zzdbf();
            zzfbn.zzb(zzfbm2);
        } else {
            zzfbm2.pos = n2;
        }
        return (short)n3;
    }

    @Override
    public final int readInt() {
        if (this.zzbz < 4L) {
            throw new IllegalStateException("size < 4: " + this.zzbz);
        }
        zzfbm zzfbm2 = this.zzpow;
        int n = zzfbm2.limit;
        int n2 = zzfbm2.pos;
        if (n - n2 < 4) {
            return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
        }
        byte[] byArray = zzfbm2.data;
        int n3 = (zzfbm2.data[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        this.zzbz -= 4L;
        if (n2 == n) {
            this.zzpow = zzfbm2.zzdbf();
            zzfbn.zzb(zzfbm2);
        } else {
            zzfbm2.pos = n2;
        }
        return n3;
    }

    public final zzfbd readByteString() {
        return new zzfbd(this.zzdba());
    }

    @Override
    public final zzfbd zzdk(long l) throws EOFException {
        return new zzfbd(this.zzdo(l));
    }

    public final String zzdaz() {
        try {
            return this.zza(this.zzbz, zzfbt.UTF_8);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    private final String zzdl(long l) throws EOFException {
        return this.zza(l, zzfbt.UTF_8);
    }

    private final String zza(long l, Charset charset) throws EOFException {
        zzfbt.checkOffsetAndCount(this.zzbz, 0L, l);
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l);
        }
        if (l == 0L) {
            return "";
        }
        zzfbm zzfbm2 = this.zzpow;
        if ((long)zzfbm2.pos + l > (long)zzfbm2.limit) {
            return new String(this.zzdo(l), charset);
        }
        String string = new String(zzfbm2.data, zzfbm2.pos, (int)l, charset);
        zzfbm2.pos = (int)((long)zzfbm2.pos + l);
        this.zzbz -= l;
        if (zzfbm2.pos == zzfbm2.limit) {
            this.zzpow = zzfbm2.zzdbf();
            zzfbn.zzb(zzfbm2);
        }
        return string;
    }

    public final String zzdm(long l) throws EOFException {
        if (Long.MAX_VALUE < 0L) {
            throw new IllegalArgumentException("limit < 0: " + Long.MAX_VALUE);
        }
        long l2 = Long.MAX_VALUE == Long.MAX_VALUE ? Long.MAX_VALUE : Long.MIN_VALUE;
        long l3 = this.zza((byte)10, 0L, l2);
        if (l3 != -1L) {
            return this.zzdn(l3);
        }
        if (l2 < this.zzbz && this.zzdj(l2 - 1L) == 13 && this.zzdj(l2) == 10) {
            return this.zzdn(l2);
        }
        zzfba zzfba2 = new zzfba();
        this.zza(zzfba2, 0L, Math.min(32L, this.zzbz));
        throw new EOFException("\\n not found: limit=" + Math.min(this.zzbz, Long.MAX_VALUE) + " content=" + zzfba2.readByteString().zzdbc() + '\u2026');
    }

    private final String zzdn(long l) throws EOFException {
        if (l > 0L && this.zzdj(l - 1L) == 13) {
            String string = this.zzdl(l - 1L);
            this.zzdp(2L);
            return string;
        }
        String string = this.zzdl(l);
        this.zzdp(1L);
        return string;
    }

    public final byte[] zzdba() {
        try {
            return this.zzdo(this.zzbz);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public final byte[] zzdo(long l) throws EOFException {
        zzfbt.checkOffsetAndCount(this.zzbz, 0L, l);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l);
        }
        byte[] byArray = new byte[(int)l];
        this.readFully(byArray);
        return byArray;
    }

    private final void readFully(byte[] byArray) throws EOFException {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            n = this.read(byArray, i, byArray.length - i);
            if (n != -1) continue;
            throw new EOFException();
        }
    }

    public final int read(byte[] byArray, int n, int n2) {
        zzfbt.checkOffsetAndCount(byArray.length, n, n2);
        zzfbm zzfbm2 = this.zzpow;
        if (zzfbm2 == null) {
            return -1;
        }
        int n3 = Math.min(n2, zzfbm2.limit - zzfbm2.pos);
        System.arraycopy(zzfbm2.data, zzfbm2.pos, byArray, n, n3);
        zzfbm2.pos += n3;
        this.zzbz -= (long)n3;
        if (zzfbm2.pos == zzfbm2.limit) {
            this.zzpow = zzfbm2.zzdbf();
            zzfbn.zzb(zzfbm2);
        }
        return n3;
    }

    public final void clear() {
        try {
            this.zzdp(this.zzbz);
            return;
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public final void zzdp(long l) throws EOFException {
        while (l > 0L) {
            if (this.zzpow == null) {
                throw new EOFException();
            }
            int n = (int)Math.min(l, (long)(this.zzpow.limit - this.zzpow.pos));
            this.zzbz -= (long)n;
            l -= (long)n;
            this.zzpow.pos += n;
            if (this.zzpow.pos != this.zzpow.limit) continue;
            zzfbm zzfbm2 = this.zzpow;
            this.zzpow = zzfbm2.zzdbf();
            zzfbn.zzb(zzfbm2);
        }
    }

    public final zzfba zzb(zzfbd zzfbd2) {
        if (zzfbd2 == null) {
            throw new IllegalArgumentException("byteString == null");
        }
        zzfbd2.zza(this);
        return this;
    }

    public final zzfba zzo(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("source == null");
        }
        zzfbt.checkOffsetAndCount(byArray.length, n, n2);
        int n3 = n + n2;
        while (n < n3) {
            zzfbm zzfbm2 = this.zzly(1);
            int n4 = Math.min(n3 - n, 8192 - zzfbm2.limit);
            System.arraycopy(byArray, n, zzfbm2.data, zzfbm2.limit, n4);
            n += n4;
            zzfbm2.limit += n4;
        }
        this.zzbz += (long)n2;
        return this;
    }

    final zzfbm zzly(int n) {
        if (n <= 0 || n > 8192) {
            throw new IllegalArgumentException();
        }
        if (this.zzpow == null) {
            this.zzpow.zzppi = this.zzpow.zzppj = (this.zzpow = zzfbn.zzdbg());
            return this.zzpow.zzppj;
        }
        zzfbm zzfbm2 = this.zzpow.zzppj;
        if (zzfbm2.limit + n > 8192 || !zzfbm2.zzpph) {
            zzfbm2 = zzfbm2.zza(zzfbn.zzdbg());
        }
        return zzfbm2;
    }

    @Override
    public final void write(zzfba zzfba2, long l) {
        if (zzfba2 == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (zzfba2 == this) {
            throw new IllegalArgumentException("source == this");
        }
        zzfbt.checkOffsetAndCount(zzfba2.zzbz, 0L, l);
        while (l > 0L) {
            zzfbm zzfbm2;
            int n;
            zzfbm zzfbm3;
            if (l < (long)(zzfba2.zzpow.limit - zzfba2.zzpow.pos)) {
                zzfbm zzfbm4;
                zzfbm3 = this.zzpow != null ? this.zzpow.zzppj : null;
                if (zzfbm3 != null && zzfbm3.zzpph && l + (long)zzfbm3.limit - (long)(zzfbm3.zzppg ? 0 : zzfbm3.pos) <= 8192L) {
                    zzfba2.zzpow.zza(zzfbm3, (int)l);
                    zzfba2.zzbz -= l;
                    this.zzbz += l;
                    return;
                }
                n = (int)l;
                zzfbm2 = zzfba2.zzpow;
                if (n <= 0 || n > zzfbm2.limit - zzfbm2.pos) {
                    throw new IllegalArgumentException();
                }
                if (n >= 1024) {
                    zzfbm4 = new zzfbm(zzfbm2);
                } else {
                    zzfbm4 = zzfbn.zzdbg();
                    System.arraycopy(zzfbm2.data, zzfbm2.pos, zzfbm4.data, 0, n);
                }
                zzfbm4.limit = zzfbm4.pos + n;
                zzfbm2.pos += n;
                zzfbm2.zzppj.zza(zzfbm4);
                zzfba2.zzpow = zzfbm4;
            }
            zzfbm3 = zzfba2.zzpow;
            long l2 = zzfbm3.limit - zzfbm3.pos;
            zzfba2.zzpow = zzfbm3.zzdbf();
            if (this.zzpow == null) {
                this.zzpow.zzppi = this.zzpow.zzppj = (this.zzpow = zzfbm3);
            } else {
                int n2;
                zzfbm2 = this.zzpow.zzppj.zza(zzfbm3);
                if (zzfbm2.zzppj == zzfbm2) {
                    throw new IllegalStateException();
                }
                if (zzfbm2.zzppj.zzpph && (n = zzfbm2.limit - zzfbm2.pos) <= (n2 = 8192 - zzfbm2.zzppj.limit + (zzfbm2.zzppj.zzppg ? 0 : zzfbm2.zzppj.pos))) {
                    zzfbm2.zza(zzfbm2.zzppj, n);
                    zzfbm2.zzdbf();
                    zzfbn.zzb(zzfbm2);
                }
            }
            zzfba2.zzbz -= l2;
            this.zzbz += l2;
            l -= l2;
        }
    }

    @Override
    public final long read(zzfba zzfba2, long l) {
        if (zzfba2 == null) {
            throw new IllegalArgumentException("sink == null");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l);
        }
        if (this.zzbz == 0L) {
            return -1L;
        }
        if (l > this.zzbz) {
            l = this.zzbz;
        }
        zzfba2.write(this, l);
        return l;
    }

    private final long zza(byte by, long l, long l2) {
        long l3;
        if (0L < 0L || l2 < 0L) {
            throw new IllegalArgumentException(String.format("size=%s fromIndex=%s toIndex=%s", this.zzbz, 0L, l2));
        }
        if (l2 > this.zzbz) {
            l2 = this.zzbz;
        }
        if (0L == l2) {
            return -1L;
        }
        zzfbm zzfbm2 = this.zzpow;
        if (zzfbm2 == null) {
            return -1L;
        }
        if (this.zzbz < 0L) {
            for (l3 = this.zzbz; l3 > 0L; l3 -= (long)(zzfbm2.limit - zzfbm2.pos)) {
                zzfbm2 = zzfbm2.zzppj;
            }
        } else {
            long l4;
            l3 = 0L;
            while ((l4 = l3 + (long)(zzfbm2.limit - zzfbm2.pos)) < 0L) {
                zzfbm2 = zzfbm2.zzppi;
                l3 = l4;
            }
        }
        while (l3 < l2) {
            byte[] byArray = zzfbm2.data;
            int n = (int)Math.min((long)zzfbm2.limit, (long)zzfbm2.pos + l2 - l3);
            for (int i = (int)((long)zzfbm2.pos + l - l3); i < n; ++i) {
                if (byArray[i] != 10) continue;
                return (long)(i - zzfbm2.pos) + l3;
            }
            l = l3 += (long)(zzfbm2.limit - zzfbm2.pos);
            zzfbm2 = zzfbm2.zzppi;
        }
        return -1L;
    }

    @Override
    public final void flush() {
    }

    @Override
    public final void close() {
    }

    public final boolean equals(Object object) {
        long l;
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfba)) {
            return false;
        }
        zzfba zzfba2 = (zzfba)object;
        if (this.zzbz != zzfba2.zzbz) {
            return false;
        }
        if (this.zzbz == 0L) {
            return true;
        }
        zzfbm zzfbm2 = this.zzpow;
        zzfbm zzfbm3 = zzfba2.zzpow;
        int n = zzfbm2.pos;
        int n2 = zzfbm3.pos;
        for (long i = 0L; i < this.zzbz; i += l) {
            l = Math.min(zzfbm2.limit - n, zzfbm3.limit - n2);
            int n3 = 0;
            while ((long)n3 < l) {
                if (zzfbm2.data[n++] != zzfbm3.data[n2++]) {
                    return false;
                }
                ++n3;
            }
            if (n == zzfbm2.limit) {
                zzfbm2 = zzfbm2.zzppi;
                n = zzfbm2.pos;
            }
            if (n2 != zzfbm3.limit) continue;
            zzfbm3 = zzfbm3.zzppi;
            n2 = zzfbm3.pos;
        }
        return true;
    }

    public final int hashCode() {
        zzfbm zzfbm2 = this.zzpow;
        if (zzfbm2 == null) {
            return 0;
        }
        int n = 1;
        do {
            int n2 = zzfbm2.limit;
            for (int i = zzfbm2.pos; i < n2; ++i) {
                n = n * 31 + zzfbm2.data[i];
            }
        } while ((zzfbm2 = zzfbm2.zzppi) != this.zzpow);
        return n;
    }

    public final String toString() {
        zzfba zzfba2 = this;
        if (zzfba2.zzbz > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size > Integer.MAX_VALUE: " + zzfba2.zzbz);
        }
        int n = (int)zzfba2.zzbz;
        zzfba zzfba3 = zzfba2;
        return (n == 0 ? zzfbd.zzpoy : new zzfbo(zzfba3, n)).toString();
    }

    public final /* synthetic */ Object clone() throws CloneNotSupportedException {
        zzfba zzfba2 = this;
        zzfba zzfba3 = new zzfba();
        if (zzfba2.zzbz == 0L) {
            return zzfba3;
        }
        zzfba3.zzpow.zzppi = zzfba3.zzpow.zzppj = (zzfba3.zzpow = new zzfbm(zzfba2.zzpow));
        zzfbm zzfbm2 = zzfba2.zzpow.zzppi;
        while (zzfbm2 != zzfba2.zzpow) {
            zzfba3.zzpow.zzppj.zza(new zzfbm(zzfbm2));
            zzfbm2 = zzfbm2.zzppi;
        }
        zzfba3.zzbz = zzfba2.zzbz;
        return zzfba3;
    }

    @Override
    public final /* synthetic */ zzfbb zzlz(int n) throws IOException {
        int n2 = n;
        zzfba zzfba2 = this;
        zzfbm zzfbm2 = zzfba2.zzly(4);
        byte[] byArray = zzfbm2.data;
        int n3 = zzfbm2.limit;
        byArray[n3++] = n2 >> 24;
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        zzfbm2.limit = n3;
        zzfba2.zzbz += 4L;
        return zzfba2;
    }

    @Override
    public final /* synthetic */ zzfbb zzma(int n) throws IOException {
        int n2 = n;
        zzfba zzfba2 = this;
        zzfbm zzfbm2 = zzfba2.zzly(2);
        byte[] byArray = zzfbm2.data;
        int n3 = zzfbm2.limit;
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        zzfbm2.limit = n3;
        zzfba2.zzbz += 2L;
        return zzfba2;
    }

    @Override
    public final /* synthetic */ zzfbb zzmb(int n) throws IOException {
        int n2 = n;
        zzfba zzfba2 = this;
        zzfbm zzfbm2 = zzfba2.zzly(1);
        zzfbm2.data[zzfbm2.limit++] = (byte)n2;
        ++zzfba2.zzbz;
        return zzfba2;
    }

    @Override
    public final /* synthetic */ zzfbb zzud(String string) throws IOException {
        String string2 = string;
        int n = string2.length();
        String string3 = string2;
        zzfba zzfba2 = this;
        if (string3 == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("endIndex < beginIndex: " + n + " < 0");
        }
        if (n > string3.length()) {
            throw new IllegalArgumentException("endIndex > string.length: " + n + " > " + string3.length());
        }
        int n2 = 0;
        while (n2 < n) {
            char c;
            zzfbm zzfbm2;
            zzfba zzfba3;
            int n3;
            int n4;
            char c2 = string3.charAt(n2);
            if (c2 < '\u0080') {
                zzfbm zzfbm3 = zzfba2.zzly(1);
                byte[] byArray = zzfbm3.data;
                int n5 = zzfbm3.limit - n2;
                int n6 = Math.min(n, 8192 - n5);
                byArray[n5 + n2++] = (byte)c2;
                while (n2 < n6 && (c2 = string3.charAt(n2)) < '\u0080') {
                    byArray[n5 + n2++] = (byte)c2;
                }
                int n7 = n2 + n5 - zzfbm3.limit;
                zzfbm3.limit += n7;
                zzfba2.zzbz += (long)n7;
                continue;
            }
            if (c2 < '\u0800') {
                n3 = n4 = c2 >> 6 | 0xC0;
                zzfba3 = zzfba2;
                zzfbm2 = zzfba3.zzly(1);
                zzfbm2.data[zzfbm2.limit++] = (byte)n3;
                ++zzfba3.zzbz;
                n3 = n4 = c2 & 0x3F | 0x80;
                zzfba3 = zzfba2;
                zzfbm2 = zzfba3.zzly(1);
                zzfbm2.data[zzfbm2.limit++] = (byte)n3;
                ++zzfba3.zzbz;
                ++n2;
                continue;
            }
            if (c2 < '\ud800' || c2 > '\udfff') {
                n3 = n4 = c2 >> 12 | 0xE0;
                zzfba3 = zzfba2;
                zzfbm2 = zzfba3.zzly(1);
                zzfbm2.data[zzfbm2.limit++] = (byte)n3;
                ++zzfba3.zzbz;
                n3 = n4 = c2 >> 6 & 0x3F | 0x80;
                zzfba3 = zzfba2;
                zzfbm2 = zzfba3.zzly(1);
                zzfbm2.data[zzfbm2.limit++] = (byte)n3;
                ++zzfba3.zzbz;
                n3 = n4 = c2 & 0x3F | 0x80;
                zzfba3 = zzfba2;
                zzfbm2 = zzfba3.zzly(1);
                zzfbm2.data[zzfbm2.limit++] = (byte)n3;
                ++zzfba3.zzbz;
                ++n2;
                continue;
            }
            char c3 = c = n2 + 1 < n ? string3.charAt(n2 + 1) : (char)'\u0000';
            if (c2 > '\udbff' || c < '\udc00' || c > '\udfff') {
                zzfba3 = zzfba2;
                zzfbm2 = zzfba3.zzly(1);
                zzfbm2.data[zzfbm2.limit++] = 63;
                ++zzfba3.zzbz;
                ++n2;
                continue;
            }
            int n8 = 65536 + ((c2 & 0xFFFF27FF) << 10 | c & 0xFFFF23FF);
            n3 = n4 = n8 >> 18 | 0xF0;
            zzfba3 = zzfba2;
            zzfbm2 = zzfba3.zzly(1);
            zzfbm2.data[zzfbm2.limit++] = (byte)n3;
            ++zzfba3.zzbz;
            n3 = n4 = n8 >> 12 & 0x3F | 0x80;
            zzfba3 = zzfba2;
            zzfbm2 = zzfba3.zzly(1);
            zzfbm2.data[zzfbm2.limit++] = (byte)n3;
            ++zzfba3.zzbz;
            n3 = n4 = n8 >> 6 & 0x3F | 0x80;
            zzfba3 = zzfba2;
            zzfbm2 = zzfba3.zzly(1);
            zzfbm2.data[zzfbm2.limit++] = (byte)n3;
            ++zzfba3.zzbz;
            n3 = n4 = n8 & 0x3F | 0x80;
            zzfba3 = zzfba2;
            zzfbm2 = zzfba3.zzly(1);
            zzfbm2.data[zzfbm2.limit++] = (byte)n3;
            ++zzfba3.zzbz;
            n2 += 2;
        }
        return zzfba2;
    }

    @Override
    public final /* synthetic */ zzfbb zzbm(byte[] byArray) throws IOException {
        byte[] byArray2 = byArray;
        zzfba zzfba2 = this;
        if (byArray2 == null) {
            throw new IllegalArgumentException("source == null");
        }
        return zzfba2.zzo(byArray2, 0, byArray2.length);
    }
}

