/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzebx;
import com.google.android.gms.internal.zzeco;
import com.google.android.gms.internal.zzecq;
import com.google.android.gms.internal.zzedi;
import com.google.android.gms.internal.zzega;
import com.google.android.gms.internal.zzegc;
import com.google.android.gms.internal.zzegf;
import com.google.android.gms.internal.zzegm;
import com.google.android.gms.internal.zzegp;
import com.google.android.gms.internal.zzegz;
import com.google.android.gms.internal.zzejo;
import com.google.android.gms.internal.zzejz;
import com.google.android.gms.internal.zzekb;
import com.google.android.gms.internal.zzekk;
import com.google.android.gms.internal.zzekp;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentListenOptions;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.zzc;
import com.google.firebase.firestore.zzd;
import com.google.firebase.firestore.zzk;
import com.google.firebase.firestore.zzm;
import com.google.firebase.firestore.zzn;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;

public class DocumentReference {
    private final zzegf zzmnc;
    private final FirebaseFirestore zzmnd;

    DocumentReference(zzegf zzegf2, FirebaseFirestore firebaseFirestore) {
        this.zzmnc = (zzegf)zzbp.zzu((Object)zzegf2);
        this.zzmnd = firebaseFirestore;
    }

    public static DocumentReference zza(zzegm zzegm2, FirebaseFirestore firebaseFirestore) {
        if (zzegm2.length() % 2 != 0) {
            String string = ((zzega)zzegm2).zzbzf();
            int n = zzegm2.length();
            throw new IllegalArgumentException(new StringBuilder(106 + String.valueOf(string).length()).append("Invalid document reference. Document references must have an even number of segments, but ").append(string).append(" has ").append(n).toString());
        }
        return new DocumentReference(zzegf.zzb(zzegm2), firebaseFirestore);
    }

    final zzegf zzbyq() {
        return this.zzmnc;
    }

    @NonNull
    public FirebaseFirestore getFirestore() {
        return this.zzmnd;
    }

    @NonNull
    public String getId() {
        return this.zzmnc.zzbzm().zzcbm();
    }

    @NonNull
    public CollectionReference getParent() {
        return new CollectionReference((zzegm)this.zzmnc.zzbzm().zzcbl(), this.zzmnd);
    }

    @NonNull
    public String getPath() {
        return ((zzega)this.zzmnc.zzbzm()).zzbzf();
    }

    @NonNull
    public CollectionReference collection(@NonNull String string) {
        zzbp.zzb((Object)string, (Object)"Provided collection path must not be null.");
        return new CollectionReference(this.zzmnc.zzbzm().zzb(zzegm.zzqp(string)), this.zzmnd);
    }

    @NonNull
    public Task<Void> set(@NonNull Map<String, Object> map) {
        return this.set(map, SetOptions.zzmoo);
    }

    @NonNull
    public Task<Void> set(@NonNull Map<String, Object> map, @NonNull SetOptions setOptions) {
        zzbp.zzb(map, (Object)"Provided data must not be null.");
        zzbp.zzb((Object)setOptions, (Object)"Provided options must not be null.");
        zzm zzm2 = this.zzmnd.zzbyx().zza(map, setOptions);
        return this.zzmnd.zzbyv().zzaw(zzm2.zza(this.zzmnc, zzegz.zzmyc)).continueWith(zzekb.zzdfn, zzekp.zzcfu());
    }

    @NonNull
    public Task<Void> set(@NonNull Object object) {
        this.zzmnd.zzbyx();
        return this.set(zzk.zzbw(object), SetOptions.zzmoo);
    }

    @NonNull
    public Task<Void> set(@NonNull Object object, @NonNull SetOptions setOptions) {
        this.zzmnd.zzbyx();
        return this.set(zzk.zzbw(object), setOptions);
    }

    @NonNull
    public Task<Void> update(@NonNull Map<String, Object> map) {
        zzn zzn2 = this.zzmnd.zzbyx().zzai(map);
        return this.zza(zzn2);
    }

    @NonNull
    public Task<Void> update(@NonNull String string, Object object, Object ... objectArray) {
        zzn zzn2 = this.zzmnd.zzbyx().zzau(zzekp.zza(1, string, object, objectArray));
        return this.zza(zzn2);
    }

    @NonNull
    public Task<Void> update(@NonNull FieldPath fieldPath, Object object, Object ... objectArray) {
        zzn zzn2 = this.zzmnd.zzbyx().zzau(zzekp.zza(1, fieldPath, object, objectArray));
        return this.zza(zzn2);
    }

    private final Task<Void> zza(@NonNull zzn zzn2) {
        return this.zzmnd.zzbyv().zzaw(zzn2.zza(this.zzmnc, zzegz.zzcl(true))).continueWith(zzekb.zzdfn, zzekp.zzcfu());
    }

    @NonNull
    public Task<Void> delete() {
        return this.zzmnd.zzbyv().zzaw(Collections.singletonList(new zzegp(this.zzmnc, zzegz.zzmyc))).continueWith(zzekb.zzdfn, zzekp.zzcfu());
    }

    @NonNull
    public Task<DocumentSnapshot> get() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        TaskCompletionSource taskCompletionSource2 = new TaskCompletionSource();
        zzebx zzebx2 = new zzebx();
        new zzebx().zzmoi = true;
        zzebx2.zzmoh = true;
        zzebx2.zzmqf = true;
        ListenerRegistration listenerRegistration = this.zza(zzekb.zzdfn, zzebx2, null, new zzc(taskCompletionSource, taskCompletionSource2));
        taskCompletionSource2.setResult((Object)listenerRegistration);
        return taskCompletionSource.getTask();
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull EventListener<DocumentSnapshot> eventListener) {
        return this.addSnapshotListener(new DocumentListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull EventListener<DocumentSnapshot> eventListener) {
        return this.addSnapshotListener(executor, new DocumentListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull EventListener<DocumentSnapshot> eventListener) {
        return this.addSnapshotListener(activity, new DocumentListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull DocumentListenOptions documentListenOptions, @NonNull EventListener<DocumentSnapshot> eventListener) {
        return this.addSnapshotListener(zzekb.zzndq, documentListenOptions, eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull DocumentListenOptions documentListenOptions, @NonNull EventListener<DocumentSnapshot> eventListener) {
        zzbp.zzb((Object)executor, (Object)"Provided executor must not be null.");
        zzbp.zzb((Object)documentListenOptions, (Object)"Provided listen options must not be null.");
        zzbp.zzb(eventListener, (Object)"Provided EventListener must not be null.");
        return this.zza(executor, DocumentReference.zza(documentListenOptions), null, eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull DocumentListenOptions documentListenOptions, @NonNull EventListener<DocumentSnapshot> eventListener) {
        zzbp.zzb((Object)activity, (Object)"Provided activity must not be null.");
        zzbp.zzb((Object)documentListenOptions, (Object)"Provided listen options must not be null.");
        zzbp.zzb(eventListener, (Object)"Provided EventListener must not be null.");
        return this.zza(zzekb.zzndq, DocumentReference.zza(documentListenOptions), activity, eventListener);
    }

    private final ListenerRegistration zza(Executor executor, zzebx zzebx2, Activity activity, EventListener<DocumentSnapshot> eventListener) {
        zzejz<zzedi> zzejz2 = new zzejz<zzedi>(executor, new zzd(this, eventListener));
        zzeco zzeco2 = zzeco.zza(this.zzmnc.zzbzm());
        zzecq zzecq2 = this.zzmnd.zzbyv().zza(zzeco2, zzebx2, zzejz2);
        return new zzekk(this.zzmnd.zzbyv(), zzecq2, activity, zzejz2);
    }

    private static zzebx zza(DocumentListenOptions documentListenOptions) {
        zzebx zzebx2 = new zzebx();
        new zzebx().zzmoi = documentListenOptions.zzmnb;
        zzebx2.zzmoh = documentListenOptions.zzmnb;
        zzebx2.zzmqf = false;
        return zzebx2;
    }

    final /* synthetic */ void zza(EventListener eventListener, zzedi zzedi2, FirebaseFirestoreException firebaseFirestoreException) {
        if (zzedi2 != null) {
            zzejo.zzc(zzedi2.zzcaj().size() <= 1, "Too many documents returned on a document query", new Object[0]);
            zzegc zzegc2 = zzedi2.zzcaj().zzk(this.zzmnc);
            DocumentSnapshot documentSnapshot = zzegc2 != null ? DocumentSnapshot.zza(this.zzmnd, zzegc2, zzedi2.isFromCache()) : DocumentSnapshot.zza(this.zzmnd, this.zzmnc, zzedi2.isFromCache());
            eventListener.onEvent(documentSnapshot, null);
            return;
        }
        zzejo.zzc(firebaseFirestoreException != null, "Got event without value or error set", new Object[0]);
        eventListener.onEvent(null, firebaseFirestoreException);
    }
}

