/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.util.SparseArray;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzejo;
import com.google.firebase.FirebaseException;

public class FirebaseFirestoreException
extends FirebaseException {
    @NonNull
    private final Code zzmoa;

    public FirebaseFirestoreException(@NonNull String string, @NonNull Code code) {
        super(string);
        zzbp.zzb((Object)string, (Object)"Provided message must not be null.");
        zzejo.zzc(code != Code.OK, "A FirebaseFirestoreException should never be thrown for OK", new Object[0]);
        this.zzmoa = (Code)((Object)zzbp.zzb((Object)((Object)code), (Object)"Provided code must not be null."));
    }

    public FirebaseFirestoreException(@NonNull String string, @NonNull Code code, Throwable throwable) {
        super(string, throwable);
        zzbp.zzb((Object)string, (Object)"Provided message must not be null.");
        zzejo.zzc(code != Code.OK, "A FirebaseFirestoreException should never be thrown for OK", new Object[0]);
        this.zzmoa = (Code)((Object)zzbp.zzb((Object)((Object)code), (Object)"Provided code must not be null."));
    }

    @NonNull
    public Code getCode() {
        return this.zzmoa;
    }

    public static enum Code {
        OK(0),
        CANCELLED(1),
        UNKNOWN(2),
        INVALID_ARGUMENT(3),
        DEADLINE_EXCEEDED(4),
        NOT_FOUND(5),
        ALREADY_EXISTS(6),
        PERMISSION_DENIED(7),
        RESOURCE_EXHAUSTED(8),
        FAILED_PRECONDITION(9),
        ABORTED(10),
        OUT_OF_RANGE(11),
        UNIMPLEMENTED(12),
        INTERNAL(13),
        UNAVAILABLE(14),
        DATA_LOSS(15),
        UNAUTHENTICATED(16);

        private final int value;
        private static final SparseArray<Code> zzmob;

        private Code(int n2) {
            this.value = n2;
        }

        public final int value() {
            return this.value;
        }

        @NonNull
        public static Code fromValue(int n) {
            return (Code)((Object)zzmob.get(n, (Object)UNKNOWN));
        }

        static {
            SparseArray sparseArray = new SparseArray();
            for (Code code : Code.values()) {
                Code code2 = (Code)((Object)sparseArray.get(code.value()));
                if (code2 != null) {
                    String string = String.valueOf((Object)code2);
                    String string2 = code.name();
                    throw new IllegalStateException(new StringBuilder(32 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Code value duplication between ").append(string).append("&").append(string2).toString());
                }
                sparseArray.put(code.value(), (Object)code);
            }
            zzmob = sparseArray;
        }
    }
}

