/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.firebase.firestore.zzg;

public final class FirebaseFirestoreSettings {
    private final String host;
    private final boolean zzmod;
    private final boolean zzltv;

    private FirebaseFirestoreSettings(Builder builder) {
        this.host = builder.host;
        this.zzmod = builder.zzmod;
        this.zzltv = builder.zzltv;
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FirebaseFirestoreSettings firebaseFirestoreSettings = (FirebaseFirestoreSettings)object;
        return this.host.equals(firebaseFirestoreSettings.host) && this.zzmod == firebaseFirestoreSettings.zzmod && this.zzltv == firebaseFirestoreSettings.zzltv;
    }

    public final int hashCode() {
        int n = this.host.hashCode();
        n = n * 31 + (this.zzmod ? 1 : 0);
        return n * 31 + (this.zzltv ? 1 : 0);
    }

    @NonNull
    public final String toString() {
        return zzbf.zzt((Object)this).zzg("host", (Object)this.host).zzg("sslEnabled", (Object)this.zzmod).zzg("persistenceEnabled", (Object)this.zzltv).toString();
    }

    @NonNull
    public final String getHost() {
        return this.host;
    }

    public final boolean isSslEnabled() {
        return this.zzmod;
    }

    public final boolean isPersistenceEnabled() {
        return this.zzltv;
    }

    /* synthetic */ FirebaseFirestoreSettings(Builder builder, zzg zzg2) {
        this(builder);
    }

    public static final class Builder {
        private String host;
        private boolean zzmod;
        private boolean zzltv;

        public Builder() {
            this.host = "firestore.googleapis.com";
            this.zzmod = true;
            this.zzltv = true;
        }

        public Builder(@NonNull FirebaseFirestoreSettings firebaseFirestoreSettings) {
            zzbp.zzb((Object)firebaseFirestoreSettings, (Object)"Provided settings must not be null.");
            this.host = firebaseFirestoreSettings.host;
            this.zzmod = firebaseFirestoreSettings.zzmod;
            this.zzltv = firebaseFirestoreSettings.zzltv;
        }

        @NonNull
        public final Builder setHost(@NonNull String string) {
            this.host = (String)zzbp.zzb((Object)string, (Object)"Provided host must not be null.");
            return this;
        }

        @NonNull
        public final Builder setSslEnabled(boolean bl) {
            this.zzmod = bl;
            return this;
        }

        @NonNull
        public final Builder setPersistenceEnabled(boolean bl) {
            this.zzltv = bl;
            return this;
        }

        @NonNull
        public final FirebaseFirestoreSettings build() {
            if (!this.zzmod && this.host.equals("firestore.googleapis.com")) {
                throw new IllegalStateException("You can't set the 'sslEnabled' setting unless you also set a non-default 'host'.");
            }
            return new FirebaseFirestoreSettings(this, null);
        }
    }
}

