/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzekp;

public class GeoPoint
implements Comparable<GeoPoint> {
    private final double latitude;
    private final double longitude;

    public GeoPoint(double d, double d2) {
        if (Double.isNaN(d) || d < -90.0 || d > 90.0) {
            throw new IllegalArgumentException("Latitude must be in the range of [-90, 90]");
        }
        if (Double.isNaN(d2) || d2 < -180.0 || d2 > 180.0) {
            throw new IllegalArgumentException("Longitude must be in the range of [-180, 180]");
        }
        this.latitude = d;
        this.longitude = d2;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public int compareTo(@NonNull GeoPoint geoPoint) {
        int n = zzekp.zzf(this.latitude, geoPoint.latitude);
        if (n == 0) {
            return zzekp.zzf(this.longitude, geoPoint.longitude);
        }
        return n;
    }

    @NonNull
    public String toString() {
        double d = this.latitude;
        double d2 = this.longitude;
        return new StringBuilder(82).append("GeoPoint { latitude=").append(d).append(", longitude=").append(d2).append(" }").toString();
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof GeoPoint)) {
            return false;
        }
        GeoPoint geoPoint = (GeoPoint)object;
        return this.latitude == geoPoint.latitude && this.longitude == geoPoint.longitude;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.latitude);
        int n = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.longitude);
        return n * 31 + (int)(l ^ l >>> 32);
    }
}

